//#include <QCoreApplication>
#include "miscellaneous.h"
#include <sstream>

//dsString q2d(const QString &s)
//{
//    return dsString( s.toStdWString().c_str() );
//}
//
//QString d2q(const dsString &s)
//{
//    return QString::fromWCharArray((const wchar_t*)s);
//}

std::wstring d2s(const dsWindowState_e &state)
{
    switch (state)
    {
    case dsWindowState_Min: return L"dsWindowState_Min";
    case dsWindowState_Max: return L"dsWindowState_Max";
    case dsWindowState_Norm: return L"dsWindowState_Norm";
    default: return L"Unknown: %1 (Maybe not synchronous to dsWindowState_e in dsConstants.h?)";
    }
}

void printWindowInfo(dsCommandMessage_c *commandline, dsDSWindow_c *window)
{
    long x, y, w, h;
    bool visible;
    dsWindowState_e state;

    // Frame
    commandline->PrintLine(L"Frame");

    window->GetFramePosition(&x, &y);
	std::wostringstream prompt;
	prompt << L"Position x = "
            << x
			<< L" y = "
			<< y;
    commandline->PrintLine( prompt.str().c_str() );
	prompt.str(std::wstring());

    window->GetFrameSize(&h, &w);
	prompt << L"Size width = "
            << w
			<< L" height = "
			<< h;
	commandline->PrintLine( prompt.str().c_str() );
	prompt.str(std::wstring());

    // Geometry
    commandline->PrintLine(L"Geometry");

    window->GetGeometryPosition(&x, &y);
	prompt << L"Position x = "
            << x
			<< L" y = "
			<< y;
    commandline->PrintLine( prompt.str().c_str() );
	prompt.str(std::wstring());

    window->GetGeometrySize(&h, &w);
	prompt << L"Size width = "
            << w
			<< L" height = "
			<< h;
	commandline->PrintLine( prompt.str().c_str() );
	prompt.str(std::wstring()); 

    // Visibility
    window->get_Visible(&visible);
	prompt << L"Visible = "
            << visible;
	commandline->PrintLine( prompt.str().c_str() );
	prompt.str(std::wstring()); 

    // Window state
    window->get_WindowState(&state);
	prompt << L"Window state = "
            << d2s(state)
			<< L" ("
			<< state
			<< L")";
	commandline->PrintLine( prompt.str().c_str() );
	prompt.str(std::wstring());
}
