//========================================================================//
//                        SOURCE CODE LICENSE                             //
//  Copyright 2014 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsApplication.js, JavaScript API dsApplication interface 		  //

var djApplicationEventManager = new Object();
djApplicationEventManager.fireEvent =  function (objectID, eventId) {
    var djEventObject = this[objectID];
    if ( typeof djEventObject != "undefined" ) {
        return djEventObject.events[eventId](arguments[2], arguments[3], arguments[4]);
    }
}
djApplicationEventManager.registerEvent = djRegisterEvent;
djApplicationEventManager.unregisterEvent = djUnRegisterEvent;

djObjectExtendCollection.dsApplication = djApplicationExtend;

function djApplicationExtend(dsObj) {
	dsObj.release =  function() { return djProcessCommand(this, 'release', arguments); };
	dsObj.releaseAll =  function() { return djProcessCommand(this, 'releaseAll', arguments); };
	dsObj.GetActiveDocument = function() {return djProcessCommand(this, 'GetActiveDocument', arguments); };
	dsObj.get_Visible = function() {return djProcessCommand(this, 'get_Visible', arguments); };
	dsObj.put_Visible = function(NewVal) {return djProcessCommand(this, 'put_Visible', arguments); };
	dsObj.GetDocuments = function() {return djProcessCommand(this, 'GetDocuments', arguments); };
	dsObj.GetVersion = function() {return djProcessCommand(this, 'GetVersion', arguments); };
	dsObj.OpenDocument = function(PathName, Option) {return djProcessCommand(this, 'OpenDocument', arguments); };
	dsObj.CloseDocument = function(PathName, SaveChanges) {return djProcessCommand(this, 'CloseDocument', arguments); };
	dsObj.RunCommand = function(CommandString, HideCommandTitle) {return djProcessCommand(this, 'RunCommand', arguments); };
	dsObj.RunScript = function(FilePathName) {return djProcessCommand(this, 'RunScript', arguments); };
	dsObj.GetRunningCommand = function() {return djProcessCommand(this, 'GetRunningCommand', arguments); };
	dsObj.AbortRunningCommand = function() {return djProcessCommand(this, 'AbortRunningCommand', arguments); };
	dsObj.ExitApplication = function() {return djProcessCommand(this, 'ExitApplication', arguments); };
	dsObj.GetPrintManager = function() {return djProcessCommand(this, 'GetPrintManager', arguments); };
	dsObj.GetHWND = function() {return djProcessCommand(this, 'GetHWND', arguments); };
	dsObj.CreateUserCommand = function(ApiUuid, UserCmdName, CmdString, Description, SmallIcon, LargeIcon, UiState) {return djProcessCommand(this, 'CreateUserCommand', arguments); };
	dsObj.RemoveUserInterface = function(ApiUuid) {return djProcessCommand(this, 'RemoveUserInterface', arguments); };
	dsObj.GetMenuItems = function(UiState) {return djProcessCommand(this, 'GetMenuItems', arguments); };
	dsObj.AddMenu = function(ApiUuid, UiState, Position, MenuName) {return djProcessCommand(this, 'AddMenu', arguments); };
	dsObj.GetToolbars = function(UiState) {return djProcessCommand(this, 'GetToolbars', arguments); };
	dsObj.AddToolbar = function(ApiUuid, UiState, ToolBarName) {return djProcessCommand(this, 'AddToolbar', arguments); };
	dsObj.CreateCommand = function(ApiUuid, CmdName) {return djProcessCommand(this, 'CreateCommand', arguments); };
	dsObj.GetLanguage = function() {return djProcessCommand(this, 'GetLanguage', arguments); };
	dsObj.GetMessageFolder = function() {return djProcessCommand(this, 'GetMessageFolder', arguments); };
	dsObj.GetCommandMessage = function() {return djProcessCommand(this, 'GetCommandMessage', arguments); };
	dsObj.GetRGBColor = function(Red, Green, Blue) {return djProcessCommand(this, 'GetRGBColor', arguments); };
	dsObj.GetNamedColor = function(ColorName) {return djProcessCommand(this, 'GetNamedColor', arguments); };
	dsObj.GetColorByIndex = function(Index) {return djProcessCommand(this, 'GetColorByIndex', arguments); };
	dsObj.get_WindowState = function() {return djProcessCommand(this, 'get_WindowState', arguments); };
	dsObj.put_WindowState = function(NewVal) {return djProcessCommand(this, 'put_WindowState', arguments); };
	dsObj.Zoom = function(Range, LowerLeftDblArray, UpperRightDblArray) {return djProcessCommand(this, 'Zoom', arguments); };
	dsObj.CreateCustomPropertyControl = function(ControlName) {return djProcessCommand(this, 'CreateCustomPropertyControl', arguments); };
	dsObj.OpenDocument2 = function(PathName, Option, EncodingId) {return djProcessCommand(this, 'OpenDocument2', arguments); };
	dsObj.NewDocument = function(TemplateName) {return djProcessCommand(this, 'NewDocument', arguments); };
	dsObj.GetMathUtility = function() {return djProcessCommand(this, 'GetMathUtility', arguments); };
	dsObj.Recover = function(FilePath) {return djProcessCommand(this, 'Recover', arguments); };
	dsObj.GetObjectType = function(Obj) {return djProcessCommand(this, 'GetObjectType', arguments); };
	dsObj.GetMainWindow = function() {return djProcessCommand(this, 'GetMainWindow', arguments); };
	dsObj.GetPreviewBitmap = function(DocumentPath) {return djProcessCommand(this, 'GetPreviewBitmap', arguments); };
	dsObj.GetPreviewBitmapFile = function(DocumentPath, BitmapFile) {return djProcessCommand(this, 'GetPreviewBitmapFile', arguments); };
	dsObj.GetSystemFiles = function() {return djProcessCommand(this, 'GetSystemFiles', arguments); };
	dsObj.GetPreviewBitmapBytes = function(DocumentPath, Format) {return djProcessCommand(this, 'GetPreviewBitmapBytes', arguments); };
	dsObj.GetEntityHelper = function() {return djProcessCommand(this, 'GetEntityHelper', arguments); };
	dsObj.get_TemporaryEntityMode = function() {return djProcessCommand(this, 'get_TemporaryEntityMode', arguments); };
	dsObj.put_TemporaryEntityMode = function(NewVal) {return djProcessCommand(this, 'put_TemporaryEntityMode', arguments); };
	dsObj.IsTemporaryEntity = function(Obj) {return djProcessCommand(this, 'IsTemporaryEntity', arguments); };
	dsObj.GetApplicationOptions = function() {return djProcessCommand(this, 'GetApplicationOptions', arguments); };
	dsObj.CreateTracker = function() {return djProcessCommand(this, 'CreateTracker', arguments); };
	dsObj.CreateLineStyle = function(Name, FileName, Description, Pattern) {return djProcessCommand(this, 'CreateLineStyle', arguments); };
	dsObj.GetLineStyleListFromFile = function(FileName) {return djProcessCommand(this, 'GetLineStyleListFromFile', arguments); };
	dsObj.GetPreviewOfEntities = function(EntitiesArray, Format, PreviewRange, NamedView, WinMin, WinMax, Width, Height) {return djProcessCommand(this, 'GetPreviewOfEntities', arguments); };
	dsObj.CreateCommand2 = function(ApiUuid, GlobalCmdName, LocalCmdName) {return djProcessCommand(this, 'CreateCommand2', arguments); };
	dsObj.RemoveCommand = function(Cmd) {return djProcessCommand(this, 'RemoveCommand', arguments); };
	dsObj.CreateCustomPropertyControl2 = function(ControlName, InitialArea, AllowedAreas) {return djProcessCommand(this, 'CreateCustomPropertyControl2', arguments); };
	dsObj.GetDrawingSupportFiles = function() {return djProcessCommand(this, 'GetDrawingSupportFiles', arguments); };
	dsObj.GetInterfaceFiles = function() {return djProcessCommand(this, 'GetInterfaceFiles', arguments); };
	dsObj.AddDefaultContextMenu = function(ApiUuid, ItemType, ItemName, UserCmdID) {return djProcessCommand(this, 'AddDefaultContextMenu', arguments); };
	dsObj.AddObjectContextMenu = function(ApiUuid, ItemType, ItemName, UserCmdID, ObjectType) {return djProcessCommand(this, 'AddObjectContextMenu', arguments); };
	dsObj.AddCommandContextMenu = function(ApiUuid, ItemType, ItemName, UserCmdID, CmdName) {return djProcessCommand(this, 'AddCommandContextMenu', arguments); };
	dsObj.GetContextMenuItems = function() {return djProcessCommand(this, 'GetContextMenuItems', arguments); };
	dsObj.GetMacroManager = function() {return djProcessCommand(this, 'GetMacroManager', arguments); };
	dsObj.CreateColorPicker = function(OnlyColorByIndex, EnableByBlockAndLayer) {return djProcessCommand(this, 'CreateColorPicker', arguments); };
	dsObj.RegisterOnIdleNotify = function() {return djProcessCommand(this, 'RegisterOnIdleNotify', arguments); };
	//Add forward methods above this line
}
