//========================================================================//
//                        SOURCE CODE LICENSE                             //
//  Copyright 2014 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCommandMessage.js, JavaScript API dsCommandMessage interface
//

djObjectExtendCollection.dsCommandMessage = djCommandMessageExtend;

function djCommandMessageExtend(dsObj) {
	dsObj.release =  function() { return djProcessCommand(this, 'release', arguments); };
	dsObj.PrintLine = function(Str) {return djProcessCommand(this, 'PrintLine', arguments); };
	dsObj.PromptForSelection = function(SingleSelection, Prompt, ErrorMsg) {return djProcessCommand(this, 'PromptForSelection', arguments); };
	dsObj.PromptForInteger = function(Prompt, DefaultValue) {return djProcessCommand(this, 'PromptForInteger', arguments); };
	dsObj.PromptForDouble = function(Prompt, DefaultValue) {return djProcessCommand(this, 'PromptForDouble', arguments); };
	dsObj.PromptForPoint = function(Prompt) {return djProcessCommand(this, 'PromptForPoint', arguments); };
	dsObj.PromptForBool = function(Prompt, StringForTrue, StringForFalse, DefaultValue) {return djProcessCommand(this, 'PromptForBool', arguments); };
	dsObj.PromptForString = function(IgnoreSpaces, Prompt, DefaultString) {return djProcessCommand(this, 'PromptForString', arguments); };
	dsObj.PromptForDistance = function(Prompt, DefaultValue) {return djProcessCommand(this, 'PromptForDistance', arguments); };
	dsObj.PromptForAngle = function(Prompt, DefaultValue) {return djProcessCommand(this, 'PromptForAngle', arguments); };
	dsObj.PromptForOrientation = function(Prompt, DefaultValue) {return djProcessCommand(this, 'PromptForOrientation', arguments); };
	dsObj.PromptForKeyword = function(Prompt, KeywordsStrArray, DefaultValue) {return djProcessCommand(this, 'PromptForKeyword', arguments); };
	dsObj.PromptForPoint2 = function(Prompt, ShowRubberLine, BasePointX, BasePointY, BasePointZ, Plane) {return djProcessCommand(this, 'PromptForPoint2', arguments); };
	dsObj.PromptForFileName = function(Prompt) {return djProcessCommand(this, 'PromptForFileName', arguments); };
	dsObj.GetLastError = function() {return djProcessCommand(this, 'GetLastError', arguments); };
	dsObj.PromptForBlockInsertion = function(PreviewBlockName, SpecifyScale, DefaultScaleX, DefaultScaleY, DefaultScaleZ, SpecifyRotation, DefaultRotation) {return djProcessCommand(this, 'PromptForBlockInsertion', arguments); };
	dsObj.PromptForAngleOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultValue) {return djProcessCommand(this, 'PromptForAngleOrKeyword', arguments); };
	dsObj.PromptForBoolOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, StringForTrue, StringForFalse, DefaultValue) {return djProcessCommand(this, 'PromptForBoolOrKeyword', arguments); };
	dsObj.PromptForDistanceOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultValue) {return djProcessCommand(this, 'PromptForDistanceOrKeyword', arguments); };
	dsObj.PromptForDoubleOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultValue) {return djProcessCommand(this, 'PromptForDoubleOrKeyword', arguments); };
	dsObj.PromptForFileNameOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultFileName) {return djProcessCommand(this, 'PromptForFileNameOrKeyword', arguments); };
	dsObj.PromptForIntegerOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultValue) {return djProcessCommand(this, 'PromptForIntegerOrKeyword', arguments); };
	dsObj.PromptForOrientationOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultValue) {return djProcessCommand(this, 'PromptForOrientationOrKeyword', arguments); };
	dsObj.PromptForPointOrKeyword = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, ShowRubberLine, DefaultValue, BasePoint, Plane) {return djProcessCommand(this, 'PromptForPointOrKeyword', arguments); };
	dsObj.PromptForSelectionOrKeyword = function(SingleSelection, Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit) {return djProcessCommand(this, 'PromptForSelectionOrKeyword', arguments); };
	dsObj.PromptForStringOrKeyword = function(IgnoreSpaces, Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultString) {return djProcessCommand(this, 'PromptForStringOrKeyword', arguments); };
	dsObj.PromptForKeyword2 = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, DefaultValue) {return djProcessCommand(this, 'PromptForKeyword2', arguments); };
	dsObj.AddTracker = function(Tracker) {return djProcessCommand(this, 'AddTracker', arguments); };
	dsObj.RemoveTracker = function(Tracker) {return djProcessCommand(this, 'RemoveTracker', arguments); };
	dsObj.PromptForAngleOrKeyword2 = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, ShowRubberLine, DefaultValue, BasePoint) {return djProcessCommand(this, 'PromptForAngleOrKeyword2', arguments); };
	dsObj.get_PromptExplanation = function() {return djProcessCommand(this, 'get_PromptExplanation', arguments); };
	dsObj.put_PromptExplanation = function(NewVal) {return djProcessCommand(this, 'put_PromptExplanation', arguments); };
	dsObj.PromptForDistanceOrKeyword2 = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, ShowRubberLine, DefaultValue, BasePoint) {return djProcessCommand(this, 'PromptForDistanceOrKeyword2', arguments); };
	dsObj.PromptForOrientationOrKeyword2 = function(Prompt, ErrorMsg, GlobalKeywordStrArray, LocalKeywordStrArray, PromptInit, ShowRubberLine, DefaultValue, BasePoint) {return djProcessCommand(this, 'PromptForOrientationOrKeyword2', arguments); };
	dsObj.GetLastUserInput = function() {return djProcessCommand(this, 'GetLastUserInput', arguments); };
	//Add forward methods above this line
}
