//========================================================================//
//                        SOURCE CODE LICENSE                             //
//  Copyright 2014 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsViewManager.js, JavaScript API dsViewManager interface
//

djObjectExtendCollection.dsViewManager = djViewManagerExtend;

function djViewManagerExtend(dsObj) {
	dsObj.release =  function() { return djProcessCommand(this, 'release', arguments); };
	dsObj.GetModelNamedViewList = function() {return djProcessCommand(this, 'GetModelNamedViewList', arguments); };
	dsObj.GetSheetNamedViewList = function() {return djProcessCommand(this, 'GetSheetNamedViewList', arguments); };
	dsObj.GetModelNamedView = function(Name) {return djProcessCommand(this, 'GetModelNamedView', arguments); };
	dsObj.GetSheetNamedView = function(Name) {return djProcessCommand(this, 'GetSheetNamedView', arguments); };
	dsObj.ActivateModelView = function(Name) {return djProcessCommand(this, 'ActivateModelView', arguments); };
	dsObj.ActivateSheetView = function(Name) {return djProcessCommand(this, 'ActivateSheetView', arguments); };
	dsObj.SaveCurrentViewAsModelView = function(Name, Class) {return djProcessCommand(this, 'SaveCurrentViewAsModelView', arguments); };
	dsObj.SaveCurrentViewAsSheetView = function(Name, Class) {return djProcessCommand(this, 'SaveCurrentViewAsSheetView', arguments); };
	dsObj.CreateModelNamedView = function(Name, Class, FirstCornerDblArray, OppositeCornerDblArray) {return djProcessCommand(this, 'CreateModelNamedView', arguments); };
	dsObj.CreateSheetNamedView = function(Name, Class, FirstCornerDblArray, OppositeCornerDblArray) {return djProcessCommand(this, 'CreateSheetNamedView', arguments); };
	dsObj.SetPredefinedView = function(PredefinedView) {return djProcessCommand(this, 'SetPredefinedView', arguments); };
	dsObj.CreateSolidBackground = function(SolidColor) {return djProcessCommand(this, 'CreateSolidBackground', arguments); };
	dsObj.CreateGradientBackground = function(TopColor, MiddleColor, BottomColor, UseTwoColors, Angle) {return djProcessCommand(this, 'CreateGradientBackground', arguments); };
	dsObj.CreateImageBackground = function(FileName, Position, OffsetX, OffsetY, ScaleX, ScaleY) {return djProcessCommand(this, 'CreateImageBackground', arguments); };
	dsObj.RemoveModelNamedView = function(NamedView) {return djProcessCommand(this, 'RemoveModelNamedView', arguments); };
	dsObj.RemoveSheetNamedView = function(NamedView) {return djProcessCommand(this, 'RemoveSheetNamedView', arguments); };
	//Add forward methods above this line
}
