//========================================================================//
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsApplication.h, C++ API dsApplication interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsDoubleArray.h"
#include "dsStringArray.h"
#include "dsMathPoint_c.h"


class dsSystemFiles_c;
class dsDocument_c;
class dsUserCommand_c;
class dsCommand_c;
class dsMenuItem_c;
class dsToolbar_c;
class dsPrintManager_c;
class dsCommandMessage_c;
class dsColor_c;
class dsCustomPropertyControl_c;
class dsMathUtility_c;
class dsDSWindow_c;
class dsByteArray;
class dsApplication_p;
class dsApplication;
class dsEntityHelper_c;
class dsApplicationOptions_c;
class dsTracker_c;
class dsDrawingSupportFiles_c;
class dsInterfaceFiles_c;
class dsContextMenuItem_c;
class dsMacroManager_c;
class dsColorPicker_c;

class DSINTERFACE_EXPORT dsApplication_c : public dsObject
{
    DECLARE_DSCPP_INTERFACE(dsApplication)
public:
    DSRESULT RegisterEvent(dsApplicationEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
    DSRESULT UnRegisterEvent(dsApplicationEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
    DSRESULT IsSame(dsApplication_c* Obj);


    DSRESULT GetActiveDocument(dsDocument_c** Doc);
    DSRESULT get_Visible(bool* Val);
    DSRESULT put_Visible(bool NewVal);
    DSRESULT GetDocuments(dsObjectPtrArray* DocumentArray);
    DSRESULT GetVersion(dsString* Version);
    DSRESULT OpenDocument(const dsString& PathName, dsDocumentOpenOption_e Option, dsDocument_c** Doc);
    DSRESULT CloseDocument(const dsString& PathName, bool SaveChanges);
    DSRESULT RunCommand(const dsString& CommandString, bool HideCommandTitle, dsRunCommandError_e *Errors);
    DSRESULT RunScript(const dsString& FilePathName);
    DSRESULT GetRunningCommand(dsString* CommandName);
    DSRESULT AbortRunningCommand(void);
    DSRESULT ExitApplication(void);
    DSRESULT GetPrintManager(dsPrintManager_c** PrintMgr);
    DSRESULT GetHWND(long* HWND);
    DSRESULT CreateUserCommand(const dsString& ApiUuid, const dsString& UserCmdName, const dsString& CmdString, const dsString& Description, const dsString& SmallIcon, const dsString& LargeIcon, dsUIState_e UiState, dsCreateCommandError_e* Error, dsUserCommand_c** Cmd);
    DSRESULT RemoveUserInterface(const dsString& ApiUuid);
    DSRESULT GetMenuItems(dsUIState_e UiState, dsObjectPtrArray* MenuItemArray);
    DSRESULT AddMenu(const dsString& ApiUuid, dsUIState_e UiState, long Position, const dsString& MenuName, dsMenuItem_c** Item);
    DSRESULT GetToolbars(dsUIState_e UiState, dsObjectPtrArray* ToolbarArray);
    DSRESULT AddToolbar(const dsString& ApiUuid, dsUIState_e UiState, const dsString& ToolBarName, dsToolbar_c** Toolbar);
    DSRESULT CreateCommand(const dsString& ApiUuid, const dsString& CmdName, dsCreateCommandError_e* Error, dsCommand_c** Cmd);
    DSRESULT GetLanguage(dsLanguage_e* Language);
    DSRESULT GetMessageFolder(dsString* MsgFolder);
    DSRESULT GetCommandMessage(dsCommandMessage_c ** CmdMsg);
    DSRESULT GetRGBColor( long Red,  long Green,  long Blue, dsColor_c ** NewColor);
    DSRESULT GetNamedColor(dsNamedColor_e ColorName, dsColor_c ** NewColor);
    DSRESULT GetColorByIndex( long Index, dsColor_c ** NewColor);
    DSRESULT get_WindowState(dsWindowState_e* Val);
    DSRESULT put_WindowState(dsWindowState_e NewVal);
    DSRESULT Zoom(dsZoomRange_e Range, const dsDoubleArray& LowerLeftDblArray, const dsDoubleArray& UpperRightDblArray);
    DSRESULT CreateCustomPropertyControl(const dsString& ControlName, dsCustomPropertyControl_c ** CustomPropertyControl);
    DSRESULT OpenDocument2(const dsString&  PathName, dsDocumentOpenOption_e Option, dsEncoding_e EncodingId, dsDocument_c ** Document);
    DSRESULT NewDocument(const dsString&  TemplateName, dsDocument_c ** Document);
    DSRESULT GetMathUtility(dsMathUtility_c ** MathUtility);
    DSRESULT Recover(const dsString&  FilePath, long * ProcessedEntitiesNumber, long * ErrorsNumber, long * FixedErrorsNumber, dsStringArray * ReportStrArray, dsDocument_c ** Document);
    DSRESULT GetObjectType(dsObject* Obj, dsObjectType_e* ObjectType);
    DSRESULT GetMainWindow(dsDSWindow_c ** Window);
    DSRESULT GetPreviewBitmap(const dsString&  DocumentPath, dsByteArray* BitmapByteArray, bool * RetVal);
    DSRESULT GetPreviewBitmapFile(const dsString&  DocumentPath, const dsString&  BitmapFile, bool * RetVal);
    DSRESULT GetSystemFiles(dsSystemFiles_c ** SystemFiles);
    DSRESULT GetPreviewBitmapBytes(const dsString&  DocumentPath, dsBitmapFormat_e Format, long * Width, long * Height, dsByteArray * BitmapByteArray, bool * RetVal);
    DSRESULT GetEntityHelper(dsEntityHelper_c ** EntityHelper);
    DSRESULT get_TemporaryEntityMode(bool* Val);
    DSRESULT put_TemporaryEntityMode(bool NewVal);
    DSRESULT IsTemporaryEntity(dsObject * Obj, bool * Val);
    DSRESULT GetApplicationOptions(dsApplicationOptions_c ** ApplicationOptions);
    DSRESULT CreateTracker(dsTracker_c ** Tracker);
    DSRESULT CreateLineStyle(const dsString& Name, const dsString& FileName, const dsString& Description, const dsString& Pattern, bool* Result);
    DSRESULT GetLineStyleListFromFile(const dsString& FileName, dsStringArray * NameStrArray, dsStringArray * DescriptionStrArray);
    DSRESULT GetPreviewOfEntities(const dsObjectPtrArray& EntitiesArray, dsBitmapFormat_e  Format, dsPreviewRange_e  PreviewRange, const dsString&  NamedView, dsMathPoint_c * WinMin, dsMathPoint_c * WinMax, long  Width, long  Height, dsByteArray * BitmapByteArray, bool * RetVal);
    DSRESULT AddDefaultContextMenu(const dsString& ApiUuid, dsMenuItemType_e ItemType, const dsString& ItemName, const dsString& UserCmdID, dsContextMenuItem_c** ContextMenuItem);
    DSRESULT AddObjectContextMenu (const dsString& ApiUuid, dsMenuItemType_e ItemType, const dsString& ItemName, const dsString& UserCmdID, dsObjectType_e ObjectType, dsContextMenuItem_c** ContextMenuItem);
    DSRESULT AddCommandContextMenu(const dsString& ApiUuid, dsMenuItemType_e ItemType, const dsString& ItemName, const dsString& UserCmdID, const dsString& CmdName, dsContextMenuItem_c** ContextMenuItem);
    DSRESULT GetContextMenuItems(dsObjectPtrArray* ContextMenuItemArray);
    DSRESULT CreateCommand2(const dsString& ApiUuid, const dsString& GlobalCmdName, const dsString& LocalCmdName, dsCreateCommandError_e* Error, dsCommand_c** Cmd);
    DSRESULT RemoveCommand(dsCommand_c* Cmd);
    DSRESULT CreateCustomPropertyControl2(const dsString& ControlName, dsCustomPropertyControlArea_e InitialArea, long AllowedAreas, dsCustomPropertyControl_c ** CustomPropertyControl);
    DSRESULT GetDrawingSupportFiles(dsDrawingSupportFiles_c ** DrawingSupportFiles);
    DSRESULT GetInterfaceFiles(dsInterfaceFiles_c ** InterfaceFiles);
    DSRESULT GetMacroManager(dsMacroManager_c ** MacroManager);
	DSRESULT CreateColorPicker(bool  OnlyColorByIndex , bool  EnableByBlockAndLayer , dsColorPicker_c ** ColorPicker);
	DSRESULT RegisterOnIdleNotify();
	DSRESULT GetRecentFiles(dsStringArray * FilesStrArray);
};


class dsApplicationEvents_c
{
public:
	virtual bool FileNewNotify(dsDocument_c *Doc) {return true;}
	virtual bool FileOpenPreNotify(const dsString& FileName, dsDocumentOpenOption_e Option) { return true; }
	virtual bool FileOpenPostNotify(dsDocument_c* Document) {return true;}
	virtual bool DestroyNotify() {return true;}
	virtual bool ActiveDocumentChangedNotify(){return true;}
	virtual bool CommandPreNotify(const dsString&  CommandName,dsDocument_c * Document) {return true;}
	virtual bool CommandPostNotify(const dsString&  CommandName,dsDocument_c * Document) {return true;}
	virtual bool CommandCancelNotify(const dsString&  CommandName,dsDocument_c * Document) {return true;}
	virtual bool ApplicationOptionBoolChangeNotify(dsApplicationOptionBool_e Option) {return true;}
	virtual bool ApplicationOptionInt16ChangeNotify(dsApplicationOptionInt16_e Option) {return true;}
	virtual bool ApplicationOptionInt32ChangeNotify(dsApplicationOptionInt32_e Option) {return true;}
	virtual bool ApplicationOptionDoubleChangeNotify(dsApplicationOptionDouble_e Option) {return true;}
	virtual bool ApplicationOptionStringChangeNotify(dsApplicationOptionString_e Option) {return true;}
	virtual bool OnIdleNotify() {return true;}
};


//---------------------

#define DeclareApplicationFileNewNotifyHook static bool FileNewNotifyHook(void* eventClassPtr, dsDocument_c *Doc);
#define DeclareApplicationFileOpenPreNotifyHook	static bool FileOpenPreNotifyHook(void* eventClassPtr, const dsString& FileName, dsDocumentOpenOption_e Option);
#define DeclareApplicationFileOpenPostNotifyHook	static bool FileOpenPostNotifyHook(void* eventClassPtr, dsDocument_c *Document);
#define DeclareApplicationDestroyNotifyHook static bool DestroyNotifyHook(void* eventClassPtr);
#define DeclareApplicationActiveDocumentChangedNotifyHook static bool ActiveDocumentChangedNotifyHook(void* eventClassPtr);

#define DeclareApplicationCommandPreNotifyHook static bool CommandPreNotifyHook(void* eventClassPtr,  const dsString& CommandName,  dsDocument_c *Doc);
#define DeclareApplicationCommandPostNotifyHook static bool CommandPostNotifyHook(void* eventClassPtr,  const dsString& CommandName,  dsDocument_c *Doc);
#define DeclareApplicationCommandCancelNotifyHook static bool CommandCancelNotifyHook(void* eventClassPtr,  const dsString& CommandName,  dsDocument_c *Doc);
#define DeclareApplicationOptionBoolChangeNotifyHook static bool ApplicationOptionBoolChangeNotifyHook(void* eventClassPtr,  dsApplicationOptionBool_e Option);
#define DeclareApplicationOptionInt16ChangeNotifyHook static bool ApplicationOptionInt16ChangeNotifyHook(void* eventClassPtr,  dsApplicationOptionInt16_e Option);
#define DeclareApplicationOptionInt32ChangeNotifyHook static bool ApplicationOptionInt32ChangeNotifyHook(void* eventClassPtr,  dsApplicationOptionInt32_e Option);
#define DeclareApplicationOptionDoubleChangeNotifyHook static bool ApplicationOptionDoubleChangeNotifyHook(void* eventClassPtr,  dsApplicationOptionDouble_e Option);
#define DeclareApplicationOptionStringChangeNotifyHook static bool ApplicationOptionStringChangeNotifyHook(void* eventClassPtr,  dsApplicationOptionString_e Option);
#define DeclareApplicationOnIdleNotifyHook static bool OnIdleNotifyHook(void* eventClassPtr);

//---------------------

#define ImplementApplicationFileNewNotifyHook(EventClass)\
bool EventClass::FileNewNotifyHook(void* eventClassPtr, dsDocument_c *Doc) \
{ \
	return ((EventClass *) eventClassPtr)->FileNewNotify(Doc); \
}

#define ImplementApplicationFileOpenPreNotifyHook(EventClass) \
bool EventClass::FileOpenPreNotifyHook(void* eventClassPtr, const dsString& FileName, dsDocumentOpenOption_e Option) \
{ \
	return ((EventClass *) eventClassPtr)->FileOpenPreNotify(FileName, Option); \
}

#define ImplementApplicationFileOpenPostNotifyHook(EventClass) \
bool EventClass::FileOpenPostNotifyHook(void* eventClassPtr, dsDocument_c *Document) \
{ \
	return ((EventClass *) eventClassPtr)->FileOpenPostNotify(Document); \
}

#define ImplementApplicationDestroyNotifyHook(EventClass)\
bool EventClass::DestroyNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->DestroyNotify(); \
}


#define ImplementApplicationActiveDocumentChangedNotifyHook(EventClass)\
bool EventClass::ActiveDocumentChangedNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->ActiveDocumentChangedNotify(); \
}

#define ImplementApplicationCommandPreNotifyHook(EventClass)\
bool EventClass::CommandPreNotifyHook(void* eventClassPtr,const dsString& CommandName,  dsDocument_c *Doc) \
{ \
	return ((EventClass *) eventClassPtr)->CommandPreNotify(CommandName, Doc ); \
}

#define ImplementApplicationCommandPostNotifyHook(EventClass)\
bool EventClass::CommandPostNotifyHook(void* eventClassPtr, const dsString& CommandName,  dsDocument_c *Doc) \
{ \
	return ((EventClass *) eventClassPtr)->CommandPostNotify(CommandName, Doc); \
}

#define ImplementApplicationCommandCancelNotifyHook(EventClass)\
bool EventClass::CommandCancelNotifyHook(void* eventClassPtr, const dsString& CommandName,  dsDocument_c *Doc) \
{ \
	return ((EventClass *) eventClassPtr)->CommandCancelNotify(CommandName, Doc); \
}

#define ImplementApplicationOptionBoolChangeNotifyHook(EventClass)\
bool EventClass::ApplicationOptionBoolChangeNotifyHook(void* eventClassPtr, dsApplicationOptionBool_e Option) \
{ \
	return ((EventClass *) eventClassPtr)->ApplicationOptionBoolChangeNotify(Option); \
}

#define ImplementApplicationOptionInt16ChangeNotifyHook(EventClass)\
bool EventClass::ApplicationOptionInt16ChangeNotifyHook(void* eventClassPtr, dsApplicationOptionInt16_e Option) \
{ \
	return ((EventClass *) eventClassPtr)->ApplicationOptionInt16ChangeNotify(Option); \
}

#define ImplementApplicationOptionInt32ChangeNotifyHook(EventClass)\
bool EventClass::ApplicationOptionInt32ChangeNotifyHook(void* eventClassPtr, dsApplicationOptionInt32_e Option) \
{ \
	return ((EventClass *) eventClassPtr)->ApplicationOptionInt32ChangeNotify(Option); \
}

#define ImplementApplicationOptionDoubleChangeNotifyHook(EventClass)\
bool EventClass::ApplicationOptionDoubleChangeNotifyHook(void* eventClassPtr, dsApplicationOptionDouble_e Option) \
{ \
	return ((EventClass *) eventClassPtr)->ApplicationOptionDoubleChangeNotify(Option); \
}

#define ImplementApplicationOptionStringChangeNotifyHook(EventClass)\
bool EventClass::ApplicationOptionStringChangeNotifyHook(void* eventClassPtr, dsApplicationOptionString_e Option) \
{ \
	return ((EventClass *) eventClassPtr)->ApplicationOptionStringChangeNotify(Option); \
}

#define ImplementApplicationOnIdleNotifyHook(EventClass)\
bool EventClass::OnIdleNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->OnIdleNotify(Option); \
}
//---------------------

#define RegisterApplicationFileNewNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_FileNewNotify_id, this, (void *) FileNewNotifyHook);

#define RegisterApplicationFileOpenPreNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_FileOpenPreNotify_id, this, (void *) FileOpenPreNotifyHook);

#define RegisterApplicationFileOpenPostNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_FileOpenPostNotify_id, this, (void *) FileOpenPostNotifyHook);

#define RegisterApplicationDestroyNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_DestroyNotify_id, this, (void *) DestroyNotifyHook);


#define RegisterApplicationActiveDocumentChangedNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_ActiveDocumentChangedNotify_id, this, (void *) ActiveDocumentChangedNotifyHook);


#define RegisterApplicationCommandPreNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_CommandPreNotify_id, this, (void *) CommandPreNotifyHook);

#define RegisterApplicationCommandPostNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_CommandPostNotify_id, this, (void *)CommandPostNotifyHook);

#define RegisterApplicationCommandCancelNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_CommandCancelNotify_id, this, (void *)CommandCancelNotifyHook);
  
#define RegisterApplicationOptionBoolChangeNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_ApplicationOptionBoolChangeNotify_id, this, (void *)ApplicationOptionBoolChangeNotifyHook);
  
#define RegisterApplicationOptionInt16ChangeNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_ApplicationOptionInt16ChangeNotify_id, this, (void *)ApplicationOptionInt16ChangeNotifyHook);
  
#define RegisterApplicationOptionInt32ChangeNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_ApplicationOptionInt32ChangeNotify_id, this, (void *)ApplicationOptionInt32ChangeNotifyHook);
  
#define RegisterApplicationOptionDoubleChangeNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_ApplicationOptionDoubleChangeNotify_id, this, (void *)ApplicationOptionDoubleChangeNotifyHook);
  
#define RegisterApplicationOptionStringChangeNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_ApplicationOptionStringChangeNotify_id, this, (void *)ApplicationOptionStringChangeNotifyHook);
  
#define RegisterApplicationOnIdleNotifyHook(dsObject)\
  dsObject->RegisterEvent(dsApplication_OnIdleNotify_id, this, (void *)OnIdleNotifyHook);
  
  //---------------------

#define UnRegisterApplicationFileNewNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_FileNewNotify_id, this, (void *) FileNewNotifyHook);

#define UnRegisterApplicationFileOpenPreNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_FileOpenPreNotify_id, this, (void *) FileOpenPreNotifyHook);

#define UnRegisterApplicationFileOpenPostNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_FileOpenPostNotify_id, this, (void *) FileOpenPostNotifyHook);

#define UnRegisterApplicationDestroyNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_DestroyNotify_id, this, (void *) DestroyNotifyHook);

#define UnRegisterApplicationActiveDocumentChangedNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_ActiveDocumentChangedNotify_id, this, (void *) ActiveDocumentChangedNotifyHook);

#define UnRegisterApplicationCommandPreNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_CommandPreNotify_id, this, (void *) CommandPreNotifyHook);

#define UnRegisterApplicationCommandPostNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_CommandPostNotify_id, this, (void *)CommandPostNotifyHook);

#define UnRegisterApplicationCommandCancelNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_CommandCancelNotify_id, this, (void *)CommandCancelNotifyHook);
	
#define UnRegisterApplicationOptionBoolChangeNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_ApplicationOptionBoolChangeNotify_id, this, (void *)ApplicationOptionBoolChangeNotifyHook);
	
#define UnRegisterApplicationOptionInt16ChangeNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_ApplicationOptionInt16ChangeNotify_id, this, (void *)ApplicationOptionInt16ChangeNotifyHook);
	
#define UnRegisterApplicationOptionInt32ChangeNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_ApplicationOptionInt32ChangeNotify_id, this, (void *)ApplicationOptionInt32ChangeNotifyHook);
	
#define UnRegisterApplicationOptionDoubleChangeNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_ApplicationOptionDoubleChangeNotify_id, this, (void *)ApplicationOptionDoubleChangeNotifyHook);
	
#define UnRegisterApplicationOptionStringChangeNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_ApplicationOptionStringChangeNotify_id, this, (void *)ApplicationOptionStringChangeNotifyHook);
	
#define UnRegisterApplicationOnIdleNotifyHook(dsObject)\
	dsObject->UnRegisterEvent(dsApplication_OnIdleNotify_id, this, (void *)OnIdleNotifyHook);	