//========================================================================//
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsConstants.h, C++ API dsConstants interface
//

#pragma once

#ifndef __DraftSight_LIBRARY_DEFINED__


#include "dsCommandOption_B.h"
;
#include "dsCommandOption_S.h"
;
#include "dsCommandOption_I8.h"
;
#include "dsCommandOption_I16.h"
;
#include "dsCommandOption_I32.h"
;
#include "dsCommandOption_D.h"
;
#include "dsCommandOption_2P.h"
;
#include "dsCommandOption_3P.h"
;
    enum dsPolyLineSegmentType_e
    {
        dsPolyLineSegmentType_Linear = 0,
        dsPolyLineSegmentType_Arc = 1,
        dsPolyLineSegmentType_Coincident = 2,
        dsPolyLineSegmentType_Point = 3,
        dsPolyLineSegmentType_Empty = 4
    };

	enum dsApplicationEvent_id_e
	{
		dsApplication_FileNewNotify_id = 1,
		dsApplication_FileOpenPreNotify_id = 2,
		dsApplication_FileOpenPostNotify_id = 3,
		dsApplication_DestroyNotify_id = 4,
		dsApplication_ActiveDocumentChangedNotify_id = 5,
		dsApplication_CommandPreNotify_id = 6,
		dsApplication_CommandPostNotify_id = 7,
		dsApplication_CommandCancelNotify_id = 8,
		dsApplication_ApplicationOptionBoolChangeNotify_id = 9,
		dsApplication_ApplicationOptionInt16ChangeNotify_id = 10,
		dsApplication_ApplicationOptionInt32ChangeNotify_id = 11,
		dsApplication_ApplicationOptionDoubleChangeNotify_id = 12,
		dsApplication_ApplicationOptionStringChangeNotify_id = 13,
		dsApplication_OnIdleNotify_id = 14
	};


	enum dsDocumentEvent_id_e
	{
		dsDocument_DestroyNotify_id = 1,
		dsDocument_FileSavePreNotify_id = 2,
		dsDocument_FileSavePostNotify_id = 3,
		dsDocument_ModifyNotify_id = 4,
		dsDocument_ObjectModifyNotify_id = 5,
		dsDocument_ObjectEraseNotify_id = 6,
		dsDocument_ObjectAppendNotify_id = 7,
		dsDocument_CommandOptionInt8ChangeNotify_id = 8,
		dsDocument_CommandOptionInt16ChangeNotify_id = 9,
		dsDocument_CommandOptionInt32ChangeNotify_id = 10,
		dsDocument_CommandOptionBoolChangeNotify_id = 11,
		dsDocument_CommandOptionStringChangeNotify_id = 12,
		dsDocument_CommandOptionPoint2DChangeNotify_id = 13,
		dsDocument_CommandOptionPoint3DChangeNotify_id = 14,
		dsDocument_ActiveSheetChangeNotify_id = 15,
		dsDocument_CommandOptionDoubleChangeNotify_id = 16,
        dsDocument_DestroyPreNotify_id = 17,
        dsDocument_FileSavePostNotify2_id = 18
	};

	enum dsSelectionManagerEvent_id_e
	{
		dsSelectionManager_SelectionChangedNotify_id = 1,
		dsSelectionManager_SelectionPreNotify_id = 2
	};

	enum dsCommandEvent_id_e
	{
		dsCommand_ExecuteNotify_id = 1
	};

    enum dsTrackerEvent_id_e
    {
        dsTracker_UpdateNotify_id = 1
    };

	enum dsLispFunctionEvent_id_e
	{
		dsLispFunction_ExecuteFunctionNotify_id = 1
	};

    enum dsObjectType_e
    {
        dsObjectUndefinedType = 0,
        dsApplicationType = 1,
        dsDocumentType = 2, 
        dsModelType = 3, 
        dsSheetType = 4,
        dsSelectionManagerType = 5,
        dsBlockDefinitionType = 6,
        dsBlockInstanceType = 7,
        dsAttributeDefinitionType = 8,
        dsExternalReferenceType = 9,
        dsAttributeInstanceType = 10,
        dsPrintManagerType = 11,
        dsSketchManagerType = 12,
        dsReferenceImageType = 13,
        dsDocumentExporterType = 14,
        dsCommandType = 15,
        dsUserCommandType = 16,
        dsMenuItemType = 17,
        dsToolbarType = 18,
        dsToolbarItemType = 19,
        dsCommandMessageType = 20,
        dsLineType = 21,
        dsCircleType = 22,
        dsCircleArcType = 23,
        dsSimpleNoteType = 24,
        dsPointType = 25,
        dsEllipseArcType = 26,
        dsPolyLineType = 27,
        dsRayType = 28,
        dsInfiniteLineType = 29,
        dsNoteType = 30,
        dsLayerType = 31,
        dsColorType = 32,
        dsLayerManagerType = 33,
        dsTextStyleManagerType = 34,
        dsTextStyleType = 35,
        dsDimensionStyleType = 36,
        dsDimensionStyleManagerType = 37,
        dsSelectionFilterType = 38,
        dsRichLineType = 39,
        dsRichLineStyleType = 40,
        dsRichLineStyleManagerType = 41,
        dsCustomDataType = 42,
        dsDimensionStyleAngularDimensionOptionsType = 43,
        dsDimensionStyleArrowsOptionsType = 44,
        dsDimensionStyleDualDimensionOptionsType = 45,
        dsDimensionStyleLinearDimensionOptionsType = 46,
        dsDimensionStyleRadialDiameterDimensionOptionsType = 47,
        dsDimensionStyleFitOptionsType = 48,
        dsDimensionStyleLineOptionsType = 49,
        dsDimensionStyleTextOptionsType = 50,
        dsDimensionStyleToleranceOptionsType = 51,
        dsAngularDimensionType = 52,
        dsGeneralDimensionType = 53,
        dsAlignedDimensionType = 54,
        dsRotatedDimensionType = 55,
        dsArcLengthDimensionType = 56,
        dsDiameterDimensionType = 57,
        dsRadialDimensionType = 58,
        dsJoggedDimensionType = 59,
        dsOrdinateDimensionType = 60,
        dsLeaderType = 61,
        dsToleranceType = 62,
        dsCustomPropertyControlType = 63,
        dsHyperLinkType = 64,
        dsPolyLine3DType = 65,
        dsSplineType = 66,
        dsFaceType = 67,
        dsSolidType = 68,
        dsPolygonMeshType = 69,
        dsPolyFaceMeshType = 70,
        dsHatchType = 71,
        dsHatchPatternType = 72,
        dsHatchBoundaryLoopType = 73,
        dsMathUtilityType = 74,
        dsMathTransformType = 75,
        dsMathPointType = 76,
        dsMathLineType = 77,
        dsMathVectorType = 78,
        dsMathPlaneType = 79,
        dsCustomCoordinateSystemManagerType = 80,
        dsCustomCoordinateSystemType = 81,
        dsViewManagerType = 82,
        dsNamedViewType = 83,
        dsModelNamedViewType = 84,
        dsSheetNamedViewType = 85,
        dsEmbeddedObjectType = 86,
        dsDSWindowType = 87,
        dsRegionType = 88,
        dsTableType = 89,
        dsSystemFilesType = 90,
        dsTableStyleType = 91,
        dsTableStyleManagerType = 92,
        dsViewportType = 93,
        dsEntityHelperType = 94,
        dsGroupType = 95,
        dsApplicationOptionsType = 96,
        dsTrackerType = 97,
        dsDictionaryType = 98,
        dsXRecordType = 99,
        dsShapeType = 100,
        dsLineStyleType = 101,
        dsLineStyleManagerType = 102,
        dsShapeManagerType = 103,
        dsLispFunctionType = 104,
        dsLispParameterType = 105,
        dsDimensionStyleUserDataType = 106,
        dsMathCircArcType = 107,
        dsMathEllipArcType = 108,
        dsDrawingSupportFilesType = 109,
        dsInterfaceFilesType = 110,
        dsTraceType = 111,
        dsContextMenuItemType = 112,
        dsHighlightSetType = 113,
        dsMacroManagerType = 114,
        dsColorPickerType = 115,
        dsDrawingPropertiesType = 116,
		dsSolidBackgroundType = 117,
		dsGradientBackgroundType = 118,
		dsImageBackgroundType = 119,
        dsTransparencyType = 120,
        dsViewTileType = 121,
        //Add enum DsObjectType above this line and increase the count
        dsObjectTypeCount = 122
    };


	enum dsDocumentOpenOption_e
	{
		dsDocumentOpen_Default =  0,
		dsDocumentOpen_ReadOnly = 1,
		dsDocumentOpen_Encoding = 2,
        dsDocumentOpen_Hidden = 3,
	};

	enum dsRunCommandError_e
	{
		dsRunCommand_Succeeded = 0x0,
		dsRunCommand_InvalidCommand = 0x1,
		dsRunCommand_Canceled = 0x2
	};

    enum dsCreateCommandError_e
	{
		dsCreateCommand_Succeeded = 0,
		dsCreateCommand_CommandNameExisted = 1
	};

	enum dsDocumentSaveAsOption_e
	{
		dsDocumentSaveAs_R2010_Default = 0,
		dsDocumentSaveAs_R2010_DWG = 1,
		dsDocumentSaveAs_R2007_R2009_DWG = 2,
		dsDocumentSaveAs_R2004_R2006_DWG = 3,
		dsDocumentSaveAs_R2000_R2002_DWG = 4,
		dsDocumentSaveAs_R14_DWG = 5,
		dsDocumentSaveAs_R13_DWG = 6,
		dsDocumentSaveAs_R12_DWG = 7,
		dsDocumentSaveAs_R2010_ASCII_DXF = 8,
		dsDocumentSaveAs_R2007_R2009_ASCII_DXF = 9,
		dsDocumentSaveAs_R2004_R2006_ASCII_DXF = 10,
		dsDocumentSaveAs_R2000_R2002_ASCII_DXF = 11,
		dsDocumentSaveAs_R14_ASCII_DXF = 12,
		dsDocumentSaveAs_R13_ASCII_DXF = 13,
		dsDocumentSaveAs_R12_ASCII_DXF = 14,
		dsDocumentSaveAs_R2010_BINARY_DXF = 15,
		dsDocumentSaveAs_R2007_R2009_BINARY_DXF = 16,
		dsDocumentSaveAs_R2004_R2006_BINARY_DXF = 17,
		dsDocumentSaveAs_R2000_R2002_BINARY_DXF = 18,
		dsDocumentSaveAs_R14_BINARY_DXF = 19,
		dsDocumentSaveAs_R13_BINARY_DXF = 20,
		dsDocumentSaveAs_R12_BINARY_DXF = 21,
		dsDocumentSaveAs_TEMPLATE_DWT = 22,
        dsDocumentSaveAs_Default = 23,
        dsDocumentSaveAs_R2013_DWG = 24, 
        dsDocumentSaveAs_R2013_ASCII_DXF = 25,
        dsDocumentSaveAs_R2013_BINARY_DXF = 26,
        dsDocumentSaveAs_STANDARDS_DWS = 27
	};

	enum dsDocumentSaveError_e
	{
		dsDocumentSave_Succeeded = 0x0,
		dsDocumentSave_GenericError = 0x1,
		dsDocumentSave_ReadOnlyError = 0x2,
		dsDocumentSave_FileLockError = 0x4,
		dsDocumentSave_InvalidPathName = 0x8,
		dsDocumentSave_EditComponentIsActive = 0x10
	};

	enum dsScaleUnit_e
	{
		dsScaleUnit_Unitless = 0,
		dsScaleUnit_Centimeters = 1,
		dsScaleUnit_Decimeters = 2,
		dsScaleUnit_Gigameters = 3,
		dsScaleUnit_Hectometers = 4,
		dsScaleUnit_Kilometers = 5,
		dsScaleUnit_Meters = 6,
		dsScaleUnit_Microns = 7,
		dsScaleUnit_Millimeters = 8,
		dsScaleUnit_Nanometers = 9,
		dsScaleUnit_Feet = 10,
		dsScaleUnit_Inches = 11,
		dsScaleUnit_Microinches = 12,
		dsScaleUnit_Miles = 13,
		dsScaleUnit_Yards = 14,
		dsScaleUnit_Angstroms = 15,
		dsScaleUnit_Astronomical = 16,
		dsScaleUnit_LightYears = 17,
		dsScaleUnit_Mils = 18,
		dsScaleUnit_Parsecs = 19
	};


	enum dsLengthType_e
	{
		dsLengthType_Architectural = 1,
		dsLengthType_Decimal = 2,
		dsLengthType_Engineering = 3,
		dsLengthType_Fractional = 4,
		dsLengthType_Scientific = 5
	};


	enum dsAngleType_e
	{
		dsAngleType_DecimalDegrees = 1,
		dsAngleType_Deg_Min_Sec = 2,
		dsAngleType_Grads = 3,
		dsAngleType_Radians = 4,
		dsAngleType_SurveyorUnit = 5
	};

	enum dsUnitPrecision_e
	{
		dsUnitPrecision_0 = 0,
		dsUnitPrecision_1 = 1,
		dsUnitPrecision_2 = 2,
		dsUnitPrecision_3 = 3,
		dsUnitPrecision_4 = 4,
		dsUnitPrecision_5 = 5,
		dsUnitPrecision_6 = 6,
		dsUnitPrecision_7 = 7,
		dsUnitPrecision_8 = 8
	};


    enum dsViewDisplayStyle_e
	{
		dsViewDisplayStyle_Default = 0,
		dsViewDisplayStyle_Hidden = 1,
		dsViewDisplayStyle_Rendered = 2,
		dsViewDisplayStyle_Wireframe = 3
	};


    enum dsPrintOrientation_e
	{
		dsPrintOrientation_Portrait = 1,
		dsPrintOrientation_Landscape = 2
	};


    enum dsUIState_e
	{
		dsUIState_Frame = 1,
		dsUIState_Document = 2
	};

    enum dsMenuItemType_e
    {
        dsMenuItemType_Menu = 1,
        dsMenuItemType_UserCommand = 2,
        dsMenuItemType_Separator = 3
    };

    enum dsContextMenuType_e
    {
        dsContextMenuType_Default = 0,
        dsContextMenuType_Object = 1,
        dsContextMenuType_Command = 2
    };

    enum dsToolbarItemType_e
	{
		dsToolBarItemType_UserCommand = 1,
		dsToolBarItemType_Separator = 2
	};

    enum dsSelectionSetType_e
	{
		dsSelectionSetType_Current = 1,
		dsSelectionSetType_Previous = 2
	};

    enum dsLineWeight_e
	{
		dsLnWt_000          =   0,
		dsLnWt_005          =   5,
		dsLnWt_009          =   9,
		dsLnWt_013          =  13,
		dsLnWt_015          =  15,
		dsLnWt_018          =  18,
		dsLnWt_020          =  20,
		dsLnWt_025          =  25,
		dsLnWt_030          =  30,
		dsLnWt_035          =  35,
		dsLnWt_040          =  40,
		dsLnWt_050          =  50,
		dsLnWt_053          =  53,
		dsLnWt_060          =  60,
		dsLnWt_070          =  70,
		dsLnWt_080          =  80,
		dsLnWt_090          =  90,
		dsLnWt_100          = 100,
		dsLnWt_106          = 106,
		dsLnWt_120          = 120,
		dsLnWt_140          = 140,
		dsLnWt_158          = 158,
		dsLnWt_200          = 200,
		dsLnWt_211          = 211,
		dsLnWt_ByLayer      = -1,
		dsLnWt_ByBlock      = -2,
		dsLnWt_ByLwDefault  = -3
	};

    enum dsLanguage_e
	{
		dsLanguage_German       =   1,
		dsLanguage_English      =   2,
		dsLanguage_Turkish      =   3,
		dsLanguage_Hungarian    =   4,
		dsLanguage_Polish       =   5,
		dsLanguage_Japanese     =   6,
		dsLanguage_French       =   7,
		dsLanguage_ChineseTrad  =   8,
		dsLanguage_ChineseSimp  =   9,
		dsLanguage_Italian      =  10,
		dsLanguage_Spanish      =  11,
		dsLanguage_Greek        =  12,
		dsLanguage_Korean       =  13,
		dsLanguage_Vietnamese   =  14,
		dsLanguage_Catalan      =  15,
		dsLanguage_Thai         =  16,
		dsLanguage_Dutch        =  17,
		dsLanguage_Russian      =  18,
		dsLanguage_Portuguese   =  19,
		dsLanguage_Czech        =  20 
	};

    enum dsCreateObjectResult_e
	{
		dsCreateObjectResult_Success		= 1,
		dsCreateObjectResult_AlreadyExists	= 2,
		dsCreateObjectResult_Error			= 3
	};

    enum dsSetCommandOptionResult_e
	{
		dsSetCommandOptionResult_Success			= 1,
		dsSetCommandOptionResult_NoVariable		= 2,
		dsSetCommandOptionResult_ReadOnly		= 3,
		dsSetCommandOptionResult_InvalidValue	= 4
	};

    enum dsGetCommandOptionResult_e
	{
		dsGetCommandOptionResult_Success	= 1,
		dsGetCommandOptionResult_NoVariable	= 2
	};

    enum dsTextJustification_e
	{
		dsTextJustification_Left			= 1,
		dsTextJustification_Center			= 2,
		dsTextJustification_Right			= 3,
		dsTextJustification_Aligned			= 4,
		dsTextJustification_Middle			= 5,
		dsTextJustification_Fit				= 6,
		dsTextJustification_TopLeft			= 7,
		dsTextJustification_TopCenter		= 8,
		dsTextJustification_TopRight		= 9,
		dsTextJustification_MiddleLeft		= 10,
		dsTextJustification_MiddleCenter	= 11,
		dsTextJustification_MiddleRight		= 12,
		dsTextJustification_BottomLeft		= 13,
		dsTextJustification_BottomCenter	= 14,
		dsTextJustification_BottomRight		= 15
	};

	enum dsTextStyleFontType_e
	{
		dsTextStyleFontType_TrueType = 1,
		dsTextStyleFontType_Shape = 2,
		dsTextStyleFontType_ShapeWithBigFont = 3
	};

	enum dsStandardPrintQuality_e
	{
		dsStandardPrintQuality_Draft          = 0, // Draft
		dsStandardPrintQuality_Preview        = 1, // Preview
		dsStandardPrintQuality_Normal         = 2, // Normal
		dsStandardPrintQuality_Presentation   = 3, // Presentation
		dsStandardPrintQuality_Maximum        = 4, // Maximum
		dsStandardPrintQuality_Custom         = 5  // Custom
	};

	enum dsStandardPrintScale_e
	{
		dsStandardPrintScale_ScaleToFit     = 0,   // Scaled to Fit
		dsStandardPrintScale_1_128in_1ft    = 1,   // 1/128" = 1'
		dsStandardPrintScale_1_64in_1ft     = 2,   // 1/64" = 1'
		dsStandardPrintScale_1_32in_1ft     = 3,   // 1/32" = 1'
		dsStandardPrintScale_1_16in_1ft     = 4,   // 1/16" = 1'
		dsStandardPrintScale_3_32in_1ft     = 5,   // 3/32" = 1'
		dsStandardPrintScale_1_8in_1ft      = 6,   // 1/8" = 1'
		dsStandardPrintScale_3_16in_1ft     = 7,   // 3/16" = 1'
		dsStandardPrintScale_1_4in_1ft      = 8,   // 1/4" = 1'
		dsStandardPrintScale_3_8in_1ft      = 9,   // 3/8" = 1'
		dsStandardPrintScale_1_2in_1ft      = 10,  // 1/2" = 1'
		dsStandardPrintScale_3_4in_1ft      = 11,  // 3/4" = 1'
		dsStandardPrintScale_1in_1ft        = 12,  // 1" = 1'
		dsStandardPrintScale_3in_1ft        = 13,  // 3" = 1'
		dsStandardPrintScale_6in_1ft        = 14,  // 6" = 1'
		dsStandardPrintScale_1ft_1ft        = 15,  // 1' = 1'
		dsStandardPrintScale_1_1            = 16,  // 1:1
		dsStandardPrintScale_1_2            = 17,  // 1:2
		dsStandardPrintScale_1_4            = 18,  // 1:4
		dsStandardPrintScale_1_8            = 19,  // 1:8
		dsStandardPrintScale_1_10           = 20,  // 1:10
		dsStandardPrintScale_1_16           = 21,  // 1:16
		dsStandardPrintScale_1_20           = 22,  // 1:20
		dsStandardPrintScale_1_30           = 23,  // 1:30
		dsStandardPrintScale_1_40           = 24,  // 1:40
		dsStandardPrintScale_1_50           = 25,  // 1:50
		dsStandardPrintScale_1_100          = 26,  // 1:100
		dsStandardPrintScale_2_1            = 27,  // 2:1
		dsStandardPrintScale_4_1            = 28,  // 4:1
		dsStandardPrintScale_8_1            = 29,  // 8:1
		dsStandardPrintScale_10_1           = 30,  // 10:1
		dsStandardPrintScale_100_1          = 31,  // 100:1
		dsStandardPrintScale_1000_1         = 32   // 1000:1
	};

	enum dsPrintRange_e
	{
		dsPrintRange_AllGeometry			= 1,
		dsPrintRange_DrawingBoundary		= 2,
		dsPrintRange_CurrentView			= 3,
		dsPrintRange_NamedView				= 4,
		dsPrintRange_SpecifyWindow			= 5
	};

    enum dsNoteJustification_e
	{
		dsNoteJustification_TopLeft			= 1,
		dsNoteJustification_TopCenter		= 2,
		dsNoteJustification_TopRight		= 3,
		dsNoteJustification_MiddleLeft		= 4,
		dsNoteJustification_MiddleCenter	= 5,
		dsNoteJustification_MiddleRight		= 6,
		dsNoteJustification_BottomLeft		= 7,
		dsNoteJustification_BottomCenter	= 8,
		dsNoteJustification_BottomRight		= 9
	};

    enum dsNoteLineSpacingStyle_e
	{
		dsNoteLineSpacingStyle_AtLeast		= 1,
		dsNoteLineSpacingStyle_Exactly		= 2
	};

	enum dsNoteDirection_e
	{
		dsNoteDirection_Horizontal		= 1,
		dsNoteDirection_Vertical		= 2,
		dsNoteDirection_ByStyle			= 3
	};

    enum dsNamedColor_e
	{
		dsNamedColor_ByBlock		= 1,
		dsNamedColor_ByLayer		= 2,
		dsNamedColor_Red			= 3,
		dsNamedColor_Yellow			= 4,
		dsNamedColor_Green			= 5,
		dsNamedColor_Cyan			= 6,
		dsNamedColor_Blue			= 7,
		dsNamedColor_Magenta		= 8,
		dsNamedColor_White			= 9
	};

	enum dsPolyLine2DType_e
	{
		dsPolyLine2DType_Simple		= 1,
		dsPolyLine2DType_Fit		= 2,
		dsPolyLine2DType_Spline		= 3
	};

    enum dsRichLineJustification_e
	{
		dsRichLineJustification_Top		= 1,
		dsRichLineJustification_Zero	= 2,
		dsRichLineJustification_Bottom	= 3,
	};

    enum dsTableHeaderOrientation_e
	{
		dsTableHeaderOrientation_Down	= 1,
		dsTableHeaderOrientation_Up		= 2,
	};

    enum dsTableCellType_e
	{
		dsTableCellType_Title		= 1,
		dsTableCellType_Header		= 2,
		dsTableCellType_Data		= 3
	};

    enum dsTableCellAlignment_e
	{
		dsTableCellAlignment_TopLeft 		= 1,
		dsTableCellAlignment_TopCenter 		= 2,
		dsTableCellAlignment_TopRight 		= 3,
		dsTableCellAlignment_MiddleLeft 	= 4,
		dsTableCellAlignment_MiddleCenter 	= 5,
		dsTableCellAlignment_MiddleRight 	= 6,
		dsTableCellAlignment_BottomLeft 	= 7,
		dsTableCellAlignment_BottomCenter 	= 8,
		dsTableCellAlignment_BottomRight 	= 9,
	};

    enum dsTableBordersLineType_e
	{
		dsTableBordersLineType_HorizontalTop	= 0x01,
		dsTableBordersLineType_HorizontalInside	= 0x02,
		dsTableBordersLineType_HorizontalBottom	= 0x04,
		dsTableBordersLineType_VerticalLeft		= 0x08,
		dsTableBordersLineType_VerticalInside	= 0x10,
		dsTableBordersLineType_VerticalRight	= 0x20,
	};

	enum dsCustomDataType_e
	{
		dsCustomDataType_Unknown         = 0,
		dsCustomDataType_String          = 1,
		dsCustomDataType_Integer16       = 2,
		dsCustomDataType_Integer32       = 3,
		dsCustomDataType_Double          = 4,
		dsCustomDataType_Point           = 5,
		dsCustomDataType_BinaryData      = 6,
		dsCustomDataType_LayerName       = 7,
		dsCustomDataType_Handle          = 8,
		dsCustomDataType_CustomData      = 9,
		dsCustomDataType_Integer8       = 10,
		dsCustomDataType_Integer64       = 11
	};

	enum dsWindowState_e
	{
		dsWindowState_Min				 = 0,
		dsWindowState_Max				 = 1,
		dsWindowState_Norm				 = 2
	};

	enum dsRebuildType_e
	{
		dsRebuildType_ActiveViewport	 = 0,
		dsRebuildType_AllViewports		 = 1
	};

	enum dsZoomRange_e
	{
		dsZoomRange_Fit					 = 0,
		dsZoomRange_Bounds				 = 1,
		dsZoomRange_Window				 = 2
	};

    enum dsDimensionStyleAngleFormat_e
	{
		dsDimensionStyleAngleFormat_DecimalDegrees	= 1,
		dsDimensionStyleAngleFormat_Deg_Min_Sec		= 2,
		dsDimensionStyleAngleFormat_Grads			= 3,
		dsDimensionStyleAngleFormat_Radians			= 4
	};

    enum dsDimensionArrowType_e
	{
		dsDimensionArrowType_ArchitecturalTick		= 1,
		dsDimensionArrowType_Box					= 2,
		dsDimensionArrowType_BoxFilled				= 3,
		dsDimensionArrowType_Closed					= 4,
		dsDimensionArrowType_ClosedBlank			= 5,
		dsDimensionArrowType_ClosedFilled			= 6,
		dsDimensionArrowType_DatumTriangle			= 7,
		dsDimensionArrowType_DatumTriangleFilled	= 8,
		dsDimensionArrowType_Dot					= 9,
		dsDimensionArrowType_DotBlank				= 10,
		dsDimensionArrowType_DotSmall				= 11,
		dsDimensionArrowType_DotSmallBlank			= 12,
		dsDimensionArrowType_Integral				= 13,
		dsDimensionArrowType_Oblique				= 14,
		dsDimensionArrowType_Open					= 15,
		dsDimensionArrowType_Open30					= 16,
		dsDimensionArrowType_OriginIndicator		= 17,
		dsDimensionArrowType_OriginIndicator2		= 18,
		dsDimensionArrowType_RightAngle				= 19,
		dsDimensionArrowType_None					= 20,
		dsDimensionArrowType_Custom					= 21
	};

	enum dsDualDimensionFormat_e
	{
		dsDualDimensionFormat_Scientific			= 1,
		dsDualDimensionFormat_Decimal				= 2,
		dsDualDimensionFormat_Engineering			= 3,
		dsDualDimensionFormat_ArchitecturalStacked	= 4,
		dsDualDimensionFormat_FractionalStacked		= 5,
		dsDualDimensionFormat_Architectural			= 6,
		dsDualDimensionFormat_Fractional			= 7,
		dsDualDimensionFormat_WindowsDesktop		= 8
	};

	enum dsDualDimensionInsertPlacement_e
	{
		dsDualDimensionInsertPlacement_AfterPrimaryUnits	= 1,
		dsDualDimensionInsertPlacement_BelowPrimaryUnits	= 2
	};

	enum dsDimensionFitGeometry_e
	{
		dsDimensionFitGeometry_Automatic						= 1,
		dsDimensionFitGeometry_Arrows							= 2,
		dsDimensionFitGeometry_Text							= 3,
		dsDimensionFitGeometry_TextAndArrows					= 4,
		dsDimensionFitGeometry_KeepTextBetweenExtensionLines	= 5
	};

	enum dsDimensionFitDimensionText_e
	{
		dsDimensionFitDimensionText_NextToDimensionLine				= 0,
		dsDimensionFitDimensionText_AboveDimensionLineWithLeader		= 1,
		dsDimensionFitDimensionText_AboveDimensionLineWithoutLeader	= 2
	};

	enum dsDimensionScale_e
	{
		dsDimensionScale_UseScaleFactor					= 1,
		dsDimensionScale_ScaleDimensionsAccordingToSheet	= 2
	};

	enum dsLinearDimensionFormat_e
	{
		dsLinearDimensionFormat_Scientific			= 1,
		dsLinearDimensionFormat_Decimal				= 2,
		dsLinearDimensionFormat_Engineering			= 3,
		dsLinearDimensionFormat_Architectural		= 4,
		dsLinearDimensionFormat_Fractional			= 5,
		dsLinearDimensionFormat_WindowsDesktop		= 6
	};

	enum dsLinearDimensionFractionalDisplay_e
	{
		dsLinearDimensionFractionalDisplay_Horizontal	= 0,
		dsLinearDimensionFractionalDisplay_Diagonal		= 1,
		dsLinearDimensionFractionalDisplay_NotStacked	= 2
	};

	enum dsLinearDimensionDecimalSeparator_e
	{
		dsLinearDimensionDecimalSeparator_Comma		= 0,
		dsLinearDimensionDecimalSeparator_Period	= 1,
		dsLinearDimensionDecimalSeparator_Space		= 2
	};

	enum dsDimensionCenterMarkDisplay_e
	{
		dsDimensionCenterMarkDisplay_None			= 1,
		dsDimensionCenterMarkDisplay_AsMark			= 2,
		dsDimensionCenterMarkDisplay_AsCenterLine	= 3
	};

	enum dsDimensionTextHorizontalPosition_e
	{
		dsDimensionTextHorizontalPosition_Centered		= 0,
		dsDimensionTextHorizontalPosition_AtExtLine1	= 1,
		dsDimensionTextHorizontalPosition_AtExtLine2	= 2,
		dsDimensionTextHorizontalPosition_OverExtLine1	= 3,
		dsDimensionTextHorizontalPosition_OverExtLine2	= 4
	};

	enum dsDimensionTextVerticalPosition_e
	{
		dsDimensionTextVerticalPosition_Centered	= 0,
		dsDimensionTextVerticalPosition_Above		= 1,
		dsDimensionTextVerticalPosition_Outside		= 2,
		dsDimensionTextVerticalPosition_JIS			= 3
	};

	enum dsDimensionTextAlignment_e
	{
		dsDimensionTextAlignment_UseISOStandard		= 0,
		dsDimensionTextAlignment_AlignHorizontally	= 1,
		dsDimensionTextAlignment_AlignWithDimensionLines	= 2
	};

	enum dsToleranceCalculation_e
	{
		dsToleranceCalculation_Basic			= 1,
		dsToleranceCalculation_Deviation		= 2,
		dsToleranceCalculation_Limits			= 3,
		dsToleranceCalculation_None			= 4,
		dsToleranceCalculation_Symmetrical	= 5 
	};

	enum dsToleranceVerticalTextJustification_e
	{
		dsToleranceVerticalTextJustification_Bottom	= 0,
		dsToleranceVerticalTextJustification_Middle	= 1,
		dsToleranceVerticalTextJustification_Top	= 2
	};

	enum dsAngularDimensionType_e
	{
		dsAngularDimensionType_3Point	= 1,
		dsAngularDimensionType_2Line	= 2
	};

	enum dsArcSymbolType_e
	{
		dsArcSymbolType_PrecedingDimensionText	= 0,
		dsArcSymbolType_AboveDimensionText		= 1,
		dsArcSymbolType_None					= 2
	};

	enum dsOrdinateDimensionMeasure_e
	{
		dsOrdinateDimensionMeasure_UseXAxis	= 1,
		dsOrdinateDimensionMeasure_UseYAxis	= 2
	};

	enum dsLeaderAnnotationType_e
	{
		dsLeaderAnnotationType_Note				= 0,
		dsLeaderAnnotationType_Tolerance		= 1,
		dsLeaderAnnotationType_BlockInstance	= 2,
		dsLeaderAnnotationType_NoAnnotation		= 3
	};

	enum dsLeaderType_e
	{
		dsLeaderType_LineWithNoArrow	= 1,
		dsLeaderType_SplineWithNoArrow	= 2,
		dsLeaderType_LineWithArrow		= 3,
		dsLeaderType_SplineWithArrow	= 4
	};

	enum dsCustomPropertyControlEvent_id_e
	{
		dsCustomPropertyControl_SizeChangedNotify_id = 1
	};

	enum dsEncoding_e
	{
		dsEncoding_Default		= 0,
		dsEncoding_dsEncoding_CP_ASCII     = 1,   // ascii
		dsEncoding_CP_8859_1    = 2,   // iso8859-1
		dsEncoding_CP_8859_2    = 3,   // iso8859-2
		dsEncoding_CP_8859_3    = 4,   // iso8859-3   
		dsEncoding_CP_8859_4    = 5,   // iso8859-4   
		dsEncoding_CP_8859_5    = 6,   // iso8859-5
		dsEncoding_CP_8859_6    = 7,   // iso8859-6
		dsEncoding_CP_8859_7    = 8,   // iso8859-7
		dsEncoding_CP_8859_8    = 9,   // iso8859-8
		dsEncoding_CP_8859_9    = 10,  // iso8859-9
		dsEncoding_CP_DOS437    = 11,  // dos437 
		dsEncoding_CP_DOS850    = 12,  // dos850 
		dsEncoding_CP_DOS852    = 13,  // dos852 
		dsEncoding_CP_DOS855    = 14,  // dos855 
		dsEncoding_CP_DOS857    = 15,  // dos857 
		dsEncoding_CP_DOS860    = 16,  // dos860 
		dsEncoding_CP_DOS861    = 17,  // dos861 
		dsEncoding_CP_DOS863    = 18,  // dos863 
		dsEncoding_CP_DOS864    = 19,  // dos864 
		dsEncoding_CP_DOS865    = 20,  // dos865 
		dsEncoding_CP_DOS869    = 21,  // dos869 
		dsEncoding_CP_DOS932    = 22,  // dos932 
		dsEncoding_CP_MACINTOSH = 23,  // mac-roman
		dsEncoding_CP_BIG5      = 24,  // big5
		dsEncoding_CP_KSC5601   = 25,  // ksc5601   
		dsEncoding_CP_JOHAB     = 26,  // johab     
		dsEncoding_CP_DOS866    = 27,  // dos866    
		dsEncoding_CP_ANSI_1250 = 28,  // ansi 1250 
		dsEncoding_CP_ANSI_1251 = 29,  // ansi 1251 
		dsEncoding_CP_ANSI_1252 = 30,  // ansi 1252 
		dsEncoding_CP_GB2312    = 31,  // gb2312    
		dsEncoding_CP_ANSI_1253 = 32,  // ansi 1253 
		dsEncoding_CP_ANSI_1254 = 33,  // ansi 1254 
		dsEncoding_CP_ANSI_1255 = 34,  // ansi 1255 
		dsEncoding_CP_ANSI_1256 = 35,  // ansi 1256 
		dsEncoding_CP_ANSI_1257 = 36,  // ansi 1257 
		dsEncoding_CP_ANSI_874  = 37,  // ansi 874  
		dsEncoding_CP_ANSI_932  = 38,  // ansi 932  
		dsEncoding_CP_ANSI_936  = 39,  // ansi 936  
		dsEncoding_CP_ANSI_949  = 40,  // ansi 949  
		dsEncoding_CP_ANSI_950  = 41,  // ansi 950  
		dsEncoding_CP_ANSI_1361 = 42,  // ansi 1361 
		dsEncoding_CP_ANSI_1200 = 43,  // ansi 1200 
		dsEncoding_CP_ANSI_1258 = 44,  // ansi 1258 
		dsEncoding_CP_CNT       = 45
	};

	enum dsHyperLinkType_e
	{
		dsHyperLinkType_None				= 0,
		dsHyperLinkType_FileOrWebPage		= 1,
		dsHyperLinkType_PlaceInThisDrawing	= 2,
		dsHyperLinkType_EmailAddress		= 3
	};

	enum dsPolyLine3DFitSmooth_e 
	{
		dsPolyLine3DFitSmooth_None		= 0,
		dsPolyLine3DFitSmooth_Qudratic	= 1,
		dsPolyLine3DFitSmooth_Cubic		= 2
	};

	enum dsPolygonMeshFitSmooth_e 
	{
		dsPolygonMeshFitSmooth_None		= 0,
		dsPolygonMeshFitSmooth_Qudratic	= 1,
		dsPolygonMeshFitSmooth_Cubic	= 2,
		dsPolygonMeshFitSmooth_Bezier	= 3
	};

	enum dsBasePatternOn_e 
	{
		dsBasePatternOn_AngleBetweenAndElementsNumber	= 1,
		dsBasePatternOn_FillAngleAndAngleBetween			= 2,
		dsBasePatternOn_FillAngleAndElementsNumber		= 3
	};

	enum dsHatchPatternInternalRegionDetection_e 
	{
		dsHatchPatternInternalRegionDetection_Normal		= 1,
		dsHatchPatternInternalRegionDetection_Outer		= 2,
		dsHatchPatternInternalRegionDetection_Ignore		= 3
	};

	enum dsHatchPatternType_e 
	{
		dsHatchPatternType_UserDefined	= 0,
		dsHatchPatternType_Predefined	= 1,
		dsHatchPatternType_Custom		= 2
	};

	enum dsPolyFaceMeshEditResult_e 
	{
		dsPolyFaceMeshEditResult_OK						= 0,
		dsPolyFaceMeshEditResult_VertexAfterFace		= 1,
		dsPolyFaceMeshEditResult_InvalidMeshVertexIndex	= 2
	};

	enum dsHatchBoundaryLoopType_e
	  {
		dsHatchBoundaryLoopType_Default             = 0,
		dsHatchBoundaryLoopType_External            = 1,
		dsHatchBoundaryLoopType_Polyline            = 2,
		dsHatchBoundaryLoopType_Derived             = 4,
		dsHatchBoundaryLoopType_Textbox             = 8,
		dsHatchBoundaryLoopType_Outermost           = 0x10,
		dsHatchBoundaryLoopType_NotClosed           = 0x20,
		dsHatchBoundaryLoopType_SelfIntersecting    = 0x40,
		dsHatchBoundaryLoopType_TextIsland          = 0x80,
		dsHatchBoundaryLoopType_Duplicate           = 0x100,
		dsHatchBoundaryLoopType_IsAnnotative        = 0x200,
		dsHatchBoundaryLoopType_DoesNotSupportScale = 0x400,
		dsHatchBoundaryLoopType_ForceAnnoAllVisible = 0x800,
		dsHatchBoundaryLoopType_OrientToPaper       = 0x1000,
		dsHatchBoundaryLoopType_IsAnnotativeBlock   = 0x2000
	  };

	enum dsHatchEdgeType_e
	{
		dsHatchEdgeType_Line     = 1,
		dsHatchEdgeType_CircleArc   = 2,
		dsHatchEdgeType_EllipseArc   = 3,
		dsHatchEdgeType_Spline   = 4
	};

	enum dsHatchFillType_e
	{
		dsHatchFillType_Hatch		= 1,
		dsHatchFillType_Solid		= 2,
		dsHatchFillType_Gradient	= 3
	};

	enum dsBlockDefinitionEntities_e
	{
		dsBlockDefinitionEntities_PreserveAsSeparateEntities	= 1,
		dsBlockDefinitionEntities_ConvertToBlock				= 2,
		dsBlockDefinitionEntities_RemoveFromDrawing				= 3
	};

	enum dsBlockInsertUnits_e
	{
		dsBlockInsertUnits_Unitless = 0,
		dsBlockInsertUnits_Inches = 1,
		dsBlockInsertUnits_Feet = 2,
		dsBlockInsertUnits_Miles = 3,
		dsBlockInsertUnits_Millimeters = 4,
		dsBlockInsertUnits_Centimeters = 5,
		dsBlockInsertUnits_Meters = 6,
		dsBlockInsertUnits_Kilometers = 7,
		dsBlockInsertUnits_Microinches = 8,
		dsBlockInsertUnits_Mils = 9,
		dsBlockInsertUnits_Yards = 10,
		dsBlockInsertUnits_Angstroms = 11,
		dsBlockInsertUnits_Nanometers = 12,
		dsBlockInsertUnits_Microns = 13,
		dsBlockInsertUnits_Decimeters = 14,
		dsBlockInsertUnits_Dekameters = 15,
		dsBlockInsertUnits_Hectometers = 16,
		dsBlockInsertUnits_Gigameters = 17,
		dsBlockInsertUnits_Astronomical = 18,
		dsBlockInsertUnits_LightYears = 19,
		dsBlockInsertUnits_Parsecs = 20
	};

	enum dsDefaultCustomCoordinateSystem_e
	{
		dsDefaultCustomCoordinateSystem_Top = 1,
		dsDefaultCustomCoordinateSystem_Bottom = 2,
		dsDefaultCustomCoordinateSystem_Front = 3,
		dsDefaultCustomCoordinateSystem_Back = 4,
		dsDefaultCustomCoordinateSystem_Left = 5,
		dsDefaultCustomCoordinateSystem_Right = 6
	};

	enum dsPredefinedView_e
	{
		dsPredefinedView_Top = 1,
		dsPredefinedView_Bottom = 2,
		dsPredefinedView_Left = 5,
		dsPredefinedView_Right = 6,
		dsPredefinedView_Front = 3,
		dsPredefinedView_Back = 4,
		dsPredefinedView_SWIsometric = 7,
		dsPredefinedView_SeIsometric = 8,
		dsPredefinedView_NEIsometric = 9,
		dsPredefinedView_NWIsometric = 10
	};

	enum dsEmbeddedObjectPrintQuality_e
	{
		dsEmbeddedObjectPrintQuality_Monochrome  = 0,
		dsEmbeddedObjectPrintQuality_LowGraphics = 1,
		dsEmbeddedObjectPrintQuality_HighGraphics = 2
	};

	enum dsEmbeddedObjectType_e
	{
		dsEmbeddedObjectType_Unknown   = 0,
		dsEmbeddedObjectType_Link = 1,
		dsEmbeddedObjectType_Embedded  = 2,
		dsEmbeddedObjectType_Static  = 3
	};

	enum dsCleanObjectType_e
	{
		dsCleanObjectType_Blocks			= 0x001,
		dsCleanObjectType_DimensionStyles	= 0x002,
		dsCleanObjectType_Layers			= 0x004,
		dsCleanObjectType_LineStyles		= 0x008,
		dsCleanObjectType_Materials			= 0x010,
		dsCleanObjectType_PrintStyles		= 0x020,
		dsCleanObjectType_RLineStyles		= 0x040,
		dsCleanObjectType_Shapes			= 0x080,
		dsCleanObjectType_TableStyles		= 0x100,
		dsCleanObjectType_TextStyles		= 0x200
	};
	
	enum dsMathLineType_e
	{
		dsMathLineType_Bounded			= 1,
		dsMathLineType_Ray				= 2,
		dsMathLineType_Infinite			= 3
	};

	enum dsViewportStandardScale_e
	{
		dsViewportStandardScale_ScaleToFit = 0,
		dsViewportStandardScale_CustomScale = 1,
		dsViewportStandardScale_1_1 = 2,
		dsViewportStandardScale_1_2 = 3,
		dsViewportStandardScale_1_4 = 4,
		dsViewportStandardScale_1_8 = 5,
		dsViewportStandardScale_1_10 = 6,
		dsViewportStandardScale_1_16 = 7,
		dsViewportStandardScale_1_20 = 8,
		dsViewportStandardScale_1_30 = 9,
		dsViewportStandardScale_1_40 = 10,
		dsViewportStandardScale_1_50 = 11,
		dsViewportStandardScale_1_100 = 12,
		dsViewportStandardScale_2_1 = 13,
		dsViewportStandardScale_4_1 = 14,
		dsViewportStandardScale_8_1 = 15,
		dsViewportStandardScale_10_1 = 16,
		dsViewportStandardScale_100_1 = 17,
		dsViewportStandardScale_1_128in_1ft = 18,
		dsViewportStandardScale_1_64in_1ft = 19,
		dsViewportStandardScale_1_32in_1ft = 20,
		dsViewportStandardScale_1_16in_1ft = 21,
		dsViewportStandardScale_3_32in_1ft = 22,
		dsViewportStandardScale_1_8in_1ft = 23,
		dsViewportStandardScale_3_16in_1ft = 24,
		dsViewportStandardScale_1_4in_1ft = 25,
		dsViewportStandardScale_3_8in_1ft = 26,
		dsViewportStandardScale_1_2in_1ft = 27,
		dsViewportStandardScale_3_4in_1ft = 28,
		dsViewportStandardScale_1in_1ft = 29,
		dsViewportStandardScale_3in_1ft = 30,
		dsViewportStandardScale_6in_1ft = 31,
		dsViewportStandardScale_1ft_1ft = 32 
	};

	enum dsViewportShadePrintStyle_e
	{
		dsViewportShadePrintStyle_AsDisplayed = 0, 
		dsViewportShadePrintStyle_Wireframe = 1,
		dsViewportShadePrintStyle_Hidden = 2,
		dsViewportShadePrintStyle_Rendered = 3
	};

	enum dsStandardViewports_e
	{
		dsStandardViewports_1 = 0,
		dsStandardViewports_2_Horizontal = 1,
		dsStandardViewports_2_Vertical = 2,
		dsStandardViewports_3_Above = 3,
		dsStandardViewports_3_Below = 4,
		dsStandardViewports_3_Horizontal = 5,
		dsStandardViewports_3_Left = 6,
		dsStandardViewports_3_Right = 7,
		dsStandardViewports_3_Vertical = 8,
		dsStandardViewports_4 = 9
	};

    enum dsBitmapFormat_e
    {	
        dsBitmapFormat_RGBA = 0,
        dsBitmapFormat_PNG = 1,
        dsBitmapFormat_GIF = 2,
        dsBitmapFormat_JPEG = 3,
        dsBitmapFormat_BMP = 4
    };

    enum dsPromptResultType_e
    {   
        dsPromptResultType_Failed   = 0,
        dsPromptResultType_Value    = 1,
        dsPromptResultType_Keyword  = 2,
        dsPromptResultType_Cancel   = 3,
        dsPromptResultType_None     = 4
    };

    enum dsPromptInit_e
    {
        dsPromptInit_NoNull = 0x001,   // No null input accepted
        dsPromptInit_NoZero = 0x002,   // No zero input accepted
        dsPromptInit_NoNeg = 0x004,    // No negative value input accepted
        dsPromptInit_NoLim = 0x008,    // (not yet evaluated)
        dsPromptInit_GetZ = 0x010,     // Returns Z coordinate
        dsPromptInit_Dash = 0x020,     // (not yes evaluated)
        dsPromptInit_2D = 0x040,       // Z coordinate ignored
        dsPromptInit_Other = 0x080,    // Any keyboard input accepted
        dsPromptInit_Button = 0x100,   // Keywords are displayed in options bar
        dsPromptInit_NoButton = 0x200, // Keywords are not displayed in options bar
        dsPromptInit_NoDefault = 0x400, // No default value available
        dsPromptInit_UsePromptExplanation  = 0x800 // User explanation prompt
    };

	enum dsElementColor_e
	{
		dsElementColor_CommandWindowBackground = 0,
		dsElementColor_CommandWindowText = 1,
		dsElementColor_CursorX = 2,
		dsElementColor_CursorY = 3,
		dsElementColor_CursorZ = 4,
		dsElementColor_ESnapCue = 5,
		dsElementColor_ModelReferenceGuides = 6,
		dsElementColor_ModelBackground = 7,
		dsElementColor_ModelCrosshair = 8,
		dsElementColor_SheetReferenceGuides = 9,
		dsElementColor_SheetBackground = 10,
		dsElementColor_SheetCrosshair = 11
	};

	enum dsLispParameterType_e
	{
		dsLispParameterType_None        = 0,
		dsLispParameterType_Integer     = 1,
		dsLispParameterType_Double      = 2,
		dsLispParameterType_Point       = 3,
		dsLispParameterType_Nil         = 4,
		dsLispParameterType_Void        = 5,
		dsLispParameterType_True        = 6,
		dsLispParameterType_String      = 7,
		dsLispParameterType_Handle      = 8,
		dsLispParameterType_List        = 9
	};

	enum dsPreviewRange_e
	{
		dsPreviewRange_AllGeometry = 0,
		dsPreviewRange_CurrentView = 1,
		dsPreviewRange_NamedView = 2,
		dsPreviewRange_SpecifyWindow = 3
	};

    enum dsTableDirection_e
    {
        dsTableDirection_TopToBottom = 0,
        dsTableDirection_BottomToTop = 1
    };
    enum dsArcLengthSymbols_e
    {
        dsArcLengthSymbols_BeforeDimText = 0, //Before the dimension text.
        dsArcLengthSymbols_AboveDimText = 1, //Above the dimension text.
        dsArcLengthSymbols_None = 2 //Not displayed.
    };

    enum dsCustomPropertyControlArea_e
    {
        dsCustomPropertyControlArea_No = 0x0,
        dsCustomPropertyControlArea_Left = 0x1,
        dsCustomPropertyControlArea_Right = 0x2,
        dsCustomPropertyControlArea_Top = 0x4,
        dsCustomPropertyControlArea_Bottom = 0x8
    };
    
    enum dsGetApplicationOptionResult_e
    {
        dsGetApplicationOptionResult_Success = 1,	//Success
        dsGetApplicationOptionResult_NoVariable = 2	//No such option
    };

    enum dsSetApplicationOptionResult_e
    {
        dsSetApplicationOptionResult_Success = 1,	//Success
        dsSetApplicationOptionResult_NoVariable = 2,	//No such option
        dsSetApplicationOptionResult_ReadOnly = 3,	//Option is read only
        dsSetApplicationOptionResult_InvalidValue = 4	//Invalid value specified
    };

    enum dsApplicationOptionBool_e
    {
        dsApplicationOptionBool_Undefined = 0,
        dsApplicationOptionBool_EnblBAttDlgs = 1,
        dsApplicationOptionBool_EnblBAttVrfy = 2,
        dsApplicationOptionBool_EnblBMPPrvw = 3,
        dsApplicationOptionBool_EnblEntSelPreSel = 4,
        dsApplicationOptionBool_EnblGBox = 5,
        dsApplicationOptionBool_EnblImgHlt = 6,
        dsApplicationOptionBool_EnblNavDlgs = 7,
        dsApplicationOptionBool_EnblPrxyWrng = 8,
        dsApplicationOptionBool_EnblRgnBndryDel = 9,
        dsApplicationOptionBool_EnblRstrOleDsp = 10,
        dsApplicationOptionBool_SetTxtPrnFill = 11,
        dsApplicationOptionBool_Count = 12
    };

    enum dsApplicationOptionInt16_e
    {
        dsApplicationOptionInt16_Undefined = 0,
        dsApplicationOptionInt16_EnblBlkXpld = 1,
        dsApplicationOptionInt16_EnblChmfAng = 2,
        dsApplicationOptionInt16_EnblCmdDlgs = 3,
        dsApplicationOptionInt16_EnblDrgDsp = 4,
        dsApplicationOptionInt16_EnblEdgeExtd = 5,
        dsApplicationOptionInt16_EnblEGripBlk = 6,
        dsApplicationOptionInt16_EnblEGripTpDsp = 7,
        dsApplicationOptionInt16_EnblEntSelHlt = 8,
        dsApplicationOptionInt16_EnblETrkDsp = 9,
        dsApplicationOptionInt16_EnblFltTrm = 10,
        dsApplicationOptionInt16_EnblMMBPan = 11,
        dsApplicationOptionInt16_EnblMutt = 12,
        dsApplicationOptionInt16_EnblPEdtCnvrtWrng = 13,
        dsApplicationOptionInt16_EnblRSnp = 14,
        dsApplicationOptionInt16_EnblTlTps = 15,
        dsApplicationOptionInt16_GetNmCdePg = 16,
        dsApplicationOptionInt16_GetStatScreen = 17,
        dsApplicationOptionInt16_LgcyACISOUTVER = 18,
        dsApplicationOptionInt16_LgcySTARTUP = 19,
        dsApplicationOptionInt16_LgcyWMFBKGND = 20,
        dsApplicationOptionInt16_LgcyWMFFOREGND = 21,
        dsApplicationOptionInt16_SetActBlkInsUnt = 22,
        dsApplicationOptionInt16_SetBAttMode = 23,
        dsApplicationOptionInt16_SetCCSAxisAng = 24,
        dsApplicationOptionInt16_SetCompEdFd = 25,
        dsApplicationOptionInt16_SetCrdDsp = 26,
        dsApplicationOptionInt16_SetDfltLWt = 27,
        dsApplicationOptionInt16_SetEGripActClr = 28,
        dsApplicationOptionInt16_SetEGripDspLmt = 29,
        dsApplicationOptionInt16_SetEGripDspMode = 30,
        dsApplicationOptionInt16_SetEGripInActClr = 31,
        dsApplicationOptionInt16_SetEntSelMode = 32,
        dsApplicationOptionInt16_SetESnpMode = 33,
        dsApplicationOptionInt16_SetGBoxSz = 34,
        dsApplicationOptionInt16_SetHtchRltvMode = 35,
        dsApplicationOptionInt16_SetLogMode = 36,
        dsApplicationOptionInt16_SetLWtUnt = 37,
        dsApplicationOptionInt16_SetMnuEcho = 38,
        dsApplicationOptionInt16_SetOfstGapMode = 39,
        dsApplicationOptionInt16_SetOLEQlty = 40,
        dsApplicationOptionInt16_SetPGonSides = 41,
        dsApplicationOptionInt16_SetPntrSz = 42,
        dsApplicationOptionInt16_SetPrnRot = 43,
        dsApplicationOptionInt16_SetProjMode = 44,
        dsApplicationOptionInt16_SetPrxyDspMode = 45,
        dsApplicationOptionInt16_SetSelBoxSz = 46,
        dsApplicationOptionInt16_SetShrtCtMnuMode = 47,
        dsApplicationOptionInt16_Count = 48
    };

    enum dsApplicationOptionInt32_e
    {
        dsApplicationOptionInt32_Undefined = 0,
        dsApplicationOptionInt32_EnblClkDrg = 1,
        dsApplicationOptionInt32_EnblEntSelAuto = 2,
        dsApplicationOptionInt32_SetCmdPrmtLvl = 3,
        dsApplicationOptionInt32_SetCrdInptMode = 4,
        dsApplicationOptionInt32_SetEntSelAdd = 5,
        dsApplicationOptionInt32_SetSvTm = 6,
        dsApplicationOptionInt32_Count = 7
    };

    enum dsApplicationOptionDouble_e
    {
        dsApplicationOptionDouble_Undefined = 0,
        dsApplicationOptionDouble_GetDt = 1,
        dsApplicationOptionDouble_GetDtJul = 2,
        dsApplicationOptionDouble_SetPGdAng = 3,
        dsApplicationOptionDouble_SetRSnpSpc = 4,
        dsApplicationOptionDouble_Count = 5
    };

    enum dsApplicationOptionString_e
    {
        dsApplicationOptionString_Undefined = 0,
        dsApplicationOptionString_GetActDict = 1,
        dsApplicationOptionString_GetActUsr = 2,
        dsApplicationOptionString_GetInfOS = 3,
        dsApplicationOptionString_GetLstSvNm = 4,
        dsApplicationOptionString_GetNmActPrfl = 5,
        dsApplicationOptionString_GetNmAutoSvFl = 6,
        dsApplicationOptionString_GetNmPrdct = 7,
        dsApplicationOptionString_GetNmPrgm = 8,
        dsApplicationOptionString_GetPlatform = 9,
        dsApplicationOptionString_GetPthDS = 10,
        dsApplicationOptionString_GetPthDWG = 11,
        dsApplicationOptionString_Lgcy_PKSER = 12,
        dsApplicationOptionString_LgcySHPNAME = 13,
        dsApplicationOptionString_SetActMnu = 14,
        dsApplicationOptionString_SetAltFnt = 15,
        dsApplicationOptionString_SetAutoSvPth = 16,
        dsApplicationOptionString_SetBrwsrUrl = 17,
        dsApplicationOptionString_SetDictFNm = 18,
        dsApplicationOptionString_SetFntMpFNm = 19,
        dsApplicationOptionString_SetLogPth = 20,
        dsApplicationOptionString_SetPGdSpcAng = 21,
        dsApplicationOptionString_SetPrmptTxt = 22,
        dsApplicationOptionString_SetPSProLog = 23,
        dsApplicationOptionString_SetPthTemp = 24,
        dsApplicationOptionString_SetAltShp = 25,
        dsApplicationOptionString_SetAltBgFnt = 26,
        dsApplicationOptionString_SetWSCURRENT = 27,
        dsApplicationOptionString_Count = 28
    };
    enum dsExecuteDlgResult_e
    {
        dsExecuteDlgResult_Rejected = 0,
        dsExecuteDlgResult_Accepted = 1
    };
    enum dsMacroLevelOfDetail_e
    {
        dsMacroLevelOfDetail_Low = 0,
        dsMacroLevelOfDetail_High = 1
    };

    enum dsMacroLanguage_e
    {
        dsMacroLanguage_Cpp = 0,
        dsMacroLanguage_CSharp = 1,
        dsMacroLanguage_JavaScript = 2,
		dsMacroLanguage_VB = 3,
        dsMacroLanguage_CPPCOM = 4,
		dsMacroLanguage_VBA = 5
    };

	enum dsViewBackgroundType_e
	{
		dsViewBackgroundType_None = 0,
		dsViewBackgroundType_Solid = 1,
		dsViewBackgroundType_Gradient = 2,
		dsViewBackgroundType_Image = 3
	};

	enum dsImageBackgroundPosition_e
	{
		dsImageBackgroundPosition_Center = 0,
		dsImageBackgroundPosition_Stretch = 1,
		dsImageBackgroundPosition_Tile = 2
	};
    enum dsHatchGradientStyle_e
    {
        dsHatchGradientStyle_Linear = 0,
        dsHatchGradientStyle_Cylinder = 1,
        dsHatchGradientStyle_InvCylinder = 2,
        dsHatchGradientStyle_Spherical = 3,
        dsHatchGradientStyle_InvSpherical = 4,
        dsHatchGradientStyle_Hemispherical = 5,
        dsHatchGradientStyle_InvHemispherical = 6,
        dsHatchGradientStyle_Curved = 7,
        dsHatchGradientStyle_InvCurved = 8
    };

    enum dsSelectionRemove_e
    {
        dsSelectionRemove_None = 0x0,
        dsSelectionRemove_OnLockedLayers = 0x1,
        dsSelectionRemove_OnOffLayers = 0x2,
        dsSelectionRemove_OnFrozenLayers = 0x4,
        dsSelectionRemove_NotInCurrentSpace = 0x8,
        dsSelectionRemove_NotRectViewports = 0x10,
        dsSelectionRemove_OverallViewports = 0x20,
        dsSelectionRemove_NotInWorkingSet = 0x40,
        dsSelectionRemove_Cloud = 0x80
    };

    enum dsViewTilesMode_e
    {
        dsViewTilesMode_1 = 0,
        dsViewTilesMode_2_Horizontal = 1,
        dsViewTilesMode_2_Vertical = 2,
        dsViewTilesMode_3_Above = 3,
        dsViewTilesMode_3_Below = 4,
        dsViewTilesMode_3_Horizontal = 5,
        dsViewTilesMode_3_Left = 6,
        dsViewTilesMode_3_Right = 7,
        dsViewTilesMode_3_Vertical = 8,
        dsViewTilesMode_4_Equal = 9,
        dsViewTilesMode_4_Left = 10,
        dsViewTilesMode_4_Right = 11
    };

    enum dsViewTilesApplyTo_e
    {
        dsViewTilesApplyTo_ActiveViewTile = 0,
        dsViewTilesApplyTo_Display = 1
    };


#endif // __DraftSight_LIBRARY_DEFINED__
