//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCustomCoordinateSystem_c.h, C++ API dsCustomCoordinateSystem_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsCustomCoordinateSystem_p;
class dsCustomCoordinateSystem;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsCustomCoordinateSystem_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCustomCoordinateSystem)
public:
	DSRESULT IsSame(dsCustomCoordinateSystem_c* dsObj);

	DSRESULT GetName(dsString*  Name);
	DSRESULT GetDefaultCustomCoordinateSystemFlag(bool * IsDefault, dsDefaultCustomCoordinateSystem_e* DefaultCustomCoordinateSystemFlag);
	DSRESULT GetOrigin(double * OriginX, double * OriginY, double * OriginZ);
	DSRESULT GetXAxisDirection(double * X, double * Y, double * Z);
	DSRESULT GetYAxisDirection(double * X, double * Y, double * Z);
	DSRESULT GetZAxisDirection(double * X, double * Y, double * Z);
	DSRESULT Rename(const dsString&  NewName, dsCreateObjectResult_e* Result);
	DSRESULT Activate( );
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
