//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsCustomData_c.h, C++ API dsCustomData_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsByteArray.h"

class dsCustomData_p;
class dsCustomData;
class DSINTERFACE_EXPORT dsCustomData_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsCustomData)
public:
	DSRESULT IsSame(dsCustomData_c* dsObj);

	DSRESULT GetDataCount(long * Count);
	DSRESULT GetDataMarker(long  Index, long * Marker);
	DSRESULT GetDataType(long  Index, dsCustomDataType_e* DataType);
	DSRESULT GetStringData (long  Index, dsString*  Value);
	DSRESULT GetInteger16Data (long  Index, long * Value);
	DSRESULT GetInteger32Data (long  Index, long * Value);
	DSRESULT GetDoubleData (long  Index, double * Value);
	DSRESULT GetPointData  (long  Index, double * X, double * Y, double * Z);
	DSRESULT GetLayerName  (long  Index, dsString*  Value);
	DSRESULT GetCustomData  (long  Index, dsCustomData_c ** Data);
	DSRESULT Empty( );
	DSRESULT Delete(long  Index);
	DSRESULT SetStringData(long  Index, const dsString&  Value);
	DSRESULT SetInteger16Data(long  Index, long  Value);
	DSRESULT SetInteger32Data(long  Index, long  Value);
	DSRESULT SetDoubleData(long  Index, double  Value);
	DSRESULT SetPointData(long  Index, double  X, double  Y, double  Z);
	DSRESULT SetLayerName(long  Index, const dsString&  Value);
	DSRESULT InsertStringData(long  Index, long  Marker, const dsString&  Value);
	DSRESULT InsertInteger16Data(long  Index, long  Marker, long  Value);
	DSRESULT InsertInteger32Data(long  Index, long  Marker, long  Value);
	DSRESULT InsertDoubleData(long  Index, long  Marker, double  Value);
	DSRESULT InsertPointData(long  Index, long  Marker, double  X, double  Y, double  Z);
	DSRESULT InsertLayerName(long  Index, const dsString&  Value);
	DSRESULT InsertCustomData(long  Index, dsCustomData_c ** CustomData);
	DSRESULT GetByteData(long  Index, dsByteArray* ByteArray);
	DSRESULT GetHandleData(long  Index, dsString*  Handle);
	DSRESULT SetByteData(long  Index, const dsByteArray&  ByteArray);
	DSRESULT SetHandle(long  Index, const dsString&  Handle);
	DSRESULT InsertByteData(long  Index, const dsByteArray&  ByteArray);
	DSRESULT InsertHandle(long  Index, const dsString&  Handle);
};
