//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleArrowsOptions_c.h, C++ API dsDimensionStyleArrowsOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsDimensionStyleArrowsOptions_p;
class dsDimensionStyleArrowsOptions;
class DSINTERFACE_EXPORT dsDimensionStyleArrowsOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleArrowsOptions)
public:
	DSRESULT IsSame(dsDimensionStyleArrowsOptions_c* dsObj);

	DSRESULT GetStartArrow(dsDimensionArrowType_e* ArrowType, dsString*  CustomArrowBlockName);
	DSRESULT SetStartArrow(dsDimensionArrowType_e ArrowType, const dsString&  CustomArrowBlockName);
	DSRESULT GetEndArrow(dsDimensionArrowType_e* ArrowType, dsString*  CustomArrowBlockName);
	DSRESULT SetEndArrow(dsDimensionArrowType_e ArrowType, const dsString&  CustomArrowBlockName);
	DSRESULT GetLeaderArrow(dsDimensionArrowType_e* ArrowType, dsString*  CustomArrowBlockName);
	DSRESULT SetLeaderArrow(dsDimensionArrowType_e ArrowType, const dsString&  CustomArrowBlockName);
	DSRESULT get_Size(double * Val);
	DSRESULT put_Size(double  NewVal);
};
