//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyleLineOptions_c.h, C++ API dsDimensionStyleLineOptions_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsDimensionStyleLineOptions_p;
class dsDimensionStyleLineOptions;
class dsColor_c;
class DSINTERFACE_EXPORT dsDimensionStyleLineOptions_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyleLineOptions)
public:
	DSRESULT IsSame(dsDimensionStyleLineOptions_c* dsObj);

	DSRESULT get_DimensionLineStyle(dsString*  Val);
	DSRESULT put_DimensionLineStyle(const dsString&  NewVal);
	DSRESULT get_DimensionLineLineWeight(dsLineWeight_e* Val);
	DSRESULT put_DimensionLineLineWeight(dsLineWeight_e NewVal);
	DSRESULT get_DimensionLineColor(dsColor_c ** Val);
	DSRESULT put_DimensionLineColor(dsColor_c * NewVal);
	DSRESULT get_DimensionLineOffset(double * Val);
	DSRESULT put_DimensionLineOffset(double  NewVal);
	DSRESULT get_DimensionLineDistancePastStartArrow(double * Val);
	DSRESULT put_DimensionLineDistancePastStartArrow(double  NewVal);
	DSRESULT get_HideDimensionLine1(bool * Val);
	DSRESULT put_HideDimensionLine1(bool  NewVal);
	DSRESULT get_HideDimensionLine2(bool * Val);
	DSRESULT put_HideDimensionLine2(bool  NewVal);
	DSRESULT get_ExtensionLine1Style(dsString*  Val);
	DSRESULT put_ExtensionLine1Style(const dsString&  NewVal);
	DSRESULT get_ExtensionLine2Style(dsString*  Val);
	DSRESULT put_ExtensionLine2Style(const dsString&  NewVal);
	DSRESULT get_ExtensionLineLineWeight(dsLineWeight_e* Val);
	DSRESULT put_ExtensionLineLineWeight(dsLineWeight_e NewVal);
	DSRESULT get_ExtensionLineColor(dsColor_c ** Val);
	DSRESULT put_ExtensionLineColor(dsColor_c * NewVal);
	DSRESULT get_ExtensionLineDistancePastDimensionLines(double * Val);
	DSRESULT put_ExtensionLineDistancePastDimensionLines(double  NewVal);
	DSRESULT get_HideExtensionLine1(bool * Val);
	DSRESULT put_HideExtensionLine1(bool  NewVal);
	DSRESULT get_HideExtensionLine2(bool * Val);
	DSRESULT put_HideExtensionLine2(bool  NewVal);
	DSRESULT GetExtensionLineFixedLength(bool * IsEnabled, double * Value);
	DSRESULT SetExtensionLineFixedLength(bool  IsEnabled, double  Value);
	DSRESULT get_ExtensionLineOffset(double * Val);
	DSRESULT put_ExtensionLineOffset(double  NewVal);
};
