//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDimensionStyle_c.h, C++ API dsDimensionStyle_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsDimensionStyle_p;
class dsDimensionStyle;
class dsDimensionStyleAngularDimensionOptions_c;
class dsDimensionStyleArrowsOptions_c;
class dsDimensionStyleDualDimensionOptions_c;
class dsDimensionStyleLinearDimensionOptions_c;
class dsDimensionStyleRadialDiameterDimensionOptions_c;
class dsDimensionStyleFitOptions_c;
class dsDimensionStyleLineOptions_c;
class dsDimensionStyleTextOptions_c;
class dsDimensionStyleToleranceOptions_c;
class dsCustomData_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsDimensionStyle_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDimensionStyle)
public:
	DSRESULT IsSame(dsDimensionStyle_c* dsObj);

	DSRESULT get_Name(dsString*  Val);
	DSRESULT Rename(const dsString&  Name, dsCreateObjectResult_e* Result);
	DSRESULT Activate( );
	DSRESULT GetDimensionStyleAngularDimensionOptions(dsDimensionStyleAngularDimensionOptions_c ** DimensionStyleAngularDimensionOptions);
	DSRESULT GetDimensionStyleArrowsOptions(dsDimensionStyleArrowsOptions_c ** DimensionStyleArrowsOptions);
	DSRESULT GetDimensionStyleDualDimensionOptions(dsDimensionStyleDualDimensionOptions_c ** DimensionStyleDualDimensionOptions);
	DSRESULT GetDimensionStyleLinearDimensionOptions(dsDimensionStyleLinearDimensionOptions_c ** DimensionStyleLinearDimensionOptions);
	DSRESULT GetDimensionStyleRadialDiameterDimensionOptions(dsDimensionStyleRadialDiameterDimensionOptions_c ** DimensionStyleRadialDiameterDimensionOptions);
	DSRESULT GetDimensionStyleFitOptions(dsDimensionStyleFitOptions_c ** DimensionStyleFitOptions);
	DSRESULT GetDimensionStyleLineOptions(dsDimensionStyleLineOptions_c ** DimensionStyleLineOptions);
	DSRESULT GetDimensionStyleTextOptions(dsDimensionStyleTextOptions_c ** DimensionStyleTextOptions);
	DSRESULT GetDimensionStyleToleranceOptions(dsDimensionStyleToleranceOptions_c ** DimensionStyleToleranceOptions);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
