//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDocumentExporter_c.h, C++ API dsDocumentExporter_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsStringArray.h"

class dsDocumentExporter_p;
class dsDocumentExporter;
class DSINTERFACE_EXPORT dsDocumentExporter_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsDocumentExporter)
public:
	DSRESULT IsSame(dsDocumentExporter_c* Obj);

	DSRESULT ExportToBmp(const dsString& PathName, bool* Success);
	DSRESULT ExportToEmf(const dsString& PathName, bool* Success);
	DSRESULT ExportToJpg(const dsString& PathName, bool* Success);
	DSRESULT ExportToPng(const dsString& PathName, bool* Success);
	DSRESULT ExportToSld(const dsString& PathName, bool* Success);
	DSRESULT ExportToSvg(const dsString& PathName, bool* Success);
	DSRESULT ExportToTiff(const dsString& PathName, bool* Success);
	DSRESULT ExportToStl(const dsString& PathName, bool* Success);
	DSRESULT ExportToPdf(const dsString& PathName, const dsStringArray& SheetsForExportStrArray, double PageLength, double PageWidth, bool* Success);
};
