//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDocument_c.h, C++ API dsDocument_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsStringArray.h"
#include "dsLongArray.h"

class dsModel_c;
class dsDocumentExporter_c;
class dsDocument_p;
class dsDocument;
class dsSelectionManager_c;
class dsLayerManager_c;
class dsTextStyleManager_c;
class dsDimensionStyleManager_c;
class dsRichLineStyleManager_c;
class dsTableStyleManager_c;
class dsBlockDefinition_c;
class dsCustomCoordinateSystemManager_c;
class dsViewManager_c;
class dsDSWindow_c;
class dsGroup_c;
class dsDictionary_c;
class dsLineStyleManager_c;
class dsShapeManager_c;
class dsLispFunction_c;
class dsLispParameter_c;
class dsHighlightSet_c;
class dsDrawingProperties_c;
class dsSheet_c;

class DSINTERFACE_EXPORT dsDocument_c : public dsObject
{
    DECLARE_DSCPP_INTERFACE(dsDocument)
public:
    DSRESULT RegisterEvent(dsDocumentEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
    DSRESULT UnRegisterEvent(dsDocumentEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
    DSRESULT IsSame(dsDocument_c* Obj);

    DSRESULT GetPathName(dsString *PathName);
    DSRESULT IsDirty(bool* Val);
    DSRESULT GetBlockDefinitions(dsObjectPtrArray* BlockDefinitionArray);
    DSRESULT GetModel(dsModel_c** ModelSpace);
    DSRESULT GetSheets(dsObjectPtrArray* SheetArray);
    DSRESULT GetSelectionManager(dsSelectionManager_c** SelManager);
    DSRESULT GetExternalReferences(dsObjectPtrArray* ExternalReferenceArray);
    DSRESULT Save(dsDocumentSaveError_e* Errors);
    DSRESULT SaveAs(const dsString& Name, dsDocumentSaveAsOption_e Options, dsDocumentSaveError_e* Errors);
    DSRESULT IsReadOnly(bool* ReadOnly);
    DSRESULT GetBaseAngle(double* Angle, bool* Clockwise);
    DSRESULT SetBaseAngle(double Angle, bool Clockwise);
    DSRESULT GetLengthUnitExpression(dsLengthType_e* LengthType, dsUnitPrecision_e* Precision);
    DSRESULT SetLengthUnitExpression(dsLengthType_e LengthType, dsUnitPrecision_e Precision);
    DSRESULT GetAngleUnitExpression(dsAngleType_e* AngleType, dsUnitPrecision_e* Precision);
    DSRESULT SetAngleUnitExpression(dsAngleType_e AngleType, dsUnitPrecision_e Precision);
    DSRESULT get_ScaleUnit(dsScaleUnit_e* Val);
    DSRESULT put_ScaleUnit(dsScaleUnit_e NewVal);
    DSRESULT IsActive(bool* Active);
    DSRESULT Activate(void);
    DSRESULT get_DimensionScale(double* Val);
    DSRESULT put_DimensionScale(double NewVal);
    DSRESULT GetDocumentExporter(dsDocumentExporter_c** DocExporter);
    DSRESULT GetLayerManager(dsLayerManager_c** LayerManager);
    DSRESULT GetCommandOptionInt8(dsCommandOptionInt8_e Var, long* Value, dsGetCommandOptionResult_e* Result);
    DSRESULT GetCommandOptionInt16(dsCommandOptionInt16_e Var, long* Value, dsGetCommandOptionResult_e* Result);
    DSRESULT GetCommandOptionInt32(dsCommandOptionInt32_e Var, long* Value, dsGetCommandOptionResult_e* Result);
    DSRESULT GetCommandOptionDouble(dsCommandOptionDouble_e Var, double* Value, dsGetCommandOptionResult_e* Result);
    DSRESULT GetCommandOptionBool(dsCommandOptionBool_e Var, bool* Value, dsGetCommandOptionResult_e* Result);
    DSRESULT GetCommandOptionString(dsCommandOptionString_e Var, dsString* Value, dsGetCommandOptionResult_e* Result);
    DSRESULT GetCommandOptionPoint2D(dsCommandOptionPoint2d_e Var, double* X, double* Y, dsGetCommandOptionResult_e* Result);
    DSRESULT GetCommandOptionPoint3D(dsCommandOptionPoint3d_e Var, double* X, double* Y, double* Z, dsGetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionInt8(dsCommandOptionInt8_e Var, long Value, dsSetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionInt16(dsCommandOptionInt16_e Var, long Value, dsSetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionInt32(dsCommandOptionInt32_e Var, long Value, dsSetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionDouble(dsCommandOptionDouble_e Var, double Value, dsSetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionBool(dsCommandOptionBool_e Var, bool Value, dsSetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionString(dsCommandOptionString_e Var, const dsString& Value, dsSetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionPoint2D(dsCommandOptionPoint2d_e Var, double X, double Y, dsSetCommandOptionResult_e* Result);
    DSRESULT SetCommandOptionPoint3D(dsCommandOptionPoint3d_e Var, double X, double Y, double Z, dsSetCommandOptionResult_e* Result);
    DSRESULT GetTextStyleManager(dsTextStyleManager_c ** TextStyleManager);
    DSRESULT GetDimensionStyleManager(dsDimensionStyleManager_c ** DimensionStyleManager);
    DSRESULT GetRichLineStyleManager(dsRichLineStyleManager_c ** RichLineStyleManager);
    DSRESULT GetTableStyleManager(dsTableStyleManager_c ** TableStyleManager);
    DSRESULT GetRegisteredApplications(dsStringArray * ApplicationNameStrArray);
    DSRESULT Rebuild(dsRebuildType_e RebuildType);
    DSRESULT SaveAs2(const dsString&  Name, dsDocumentSaveAsOption_e Options, bool  Overwrite, dsDocumentSaveError_e* Errors);
    DSRESULT GetObjectByHandle(const dsString&  Handle, dsObjectType_e* ObjType, dsObject ** DispObj);
    DSRESULT CreateBlockDefinition(const dsString&  BlockName, const dsString&  Description, double  BasePointX, double  BasePointY, double  BasePointZ, const dsLongArray& EntityTypeLongArray, const dsObjectPtrArray&  EntitiesArray, dsBlockDefinitionEntities_e BlockDefinitionEntities, dsBlockDefinition_c ** BlockDefinition);
    DSRESULT ErrorCheck(bool  FixErrors, long * ProcessedEntitiesNumber, long * ErrorsNumber, long * FixedErrorsNumber, dsStringArray * ReportStrArray);
    DSRESULT Clean(long  EntityTypesForClean, bool  DeleteDependedEntities);
    DSRESULT GetCustomCoordinateSystemManager (dsCustomCoordinateSystemManager_c ** CustomCoordinateSystemManager);
    DSRESULT GetViewManager(dsViewManager_c ** ViewManager);
    DSRESULT GetHandleFromObject(dsObject * Obj, dsString*  Handle);
    DSRESULT GetWindow(dsDSWindow_c ** Window);
    DSRESULT Pan(double  PanX, double  PanY);
    DSRESULT CreateGroup(const dsString& Name, bool Unnamed, const dsString& Description, const dsObjectPtrArray& EntitiesArray, dsGroup_c **Group);
    DSRESULT GetGroups(dsObjectPtrArray * GroupArray);
    DSRESULT GetGroup(const dsString& Name, dsGroup_c ** Group);
    DSRESULT GetNamedObjectsDictionary(dsDictionary_c ** Dictionary);
    DSRESULT GetLineStyleManager(dsLineStyleManager_c ** LineStyleManager);
    DSRESULT GetShapeManager(dsShapeManager_c ** ShapeManager);
    DSRESULT CreateLispFunction(const dsString&  ApiUuid, const dsString&  Name, dsCreateCommandError_e*  Error, dsLispFunction_c ** LispFunction);
    DSRESULT RemoveLispFunction(const dsString&  FunctionName);
    DSRESULT InvokeLisp(const dsString&  LispExpression, dsLispParameter_c ** Result);
    DSRESULT HasBlockDefinition(const dsString& BlockName, bool* HasBlockDef);
    DSRESULT GetBlockDefinition(const dsString& BlockName, dsBlockDefinition_c ** BlockDefinition);
    DSRESULT CreateHighlightSet(const dsObjectPtrArray&  EntitiesArray, dsHighlightSet_c ** HighlightSet);
    DSRESULT GetDrawingProperties(dsDrawingProperties_c ** DrawingProperties);
    DSRESULT CreateSheet(const dsString& Name, dsSheet_c** Sheet);
    DSRESULT CreateSheetByTemplate(const dsString& Name, const dsString& TemplateFileName, const dsString& TemplateSheetName, dsSheet_c** Sheet);
    DSRESULT CopySheet(const dsString& Name, const dsString& SheetToCopy, dsSheet_c** Sheet);
    DSRESULT RemoveSheet(const dsString& Name);
    DSRESULT HasSheet(const dsString& Name, bool* HasSheet);
    DSRESULT GetSheet(const dsString& Name, dsSheet_c** Sheet);
	DSRESULT GetSheets2(dsObjectPtrArray * SheetArray);
};


class dsDocumentEvents_c
{
public:
    virtual bool DestroyNotify() {return true;}
    virtual bool FileSavePreNotify(const dsString& FileName, dsDocumentSaveAsOption_e SaveOption) { return true; }
    virtual bool FileSavePostNotify() {return true;}
    virtual bool ModifyNotify() {return true;}
    virtual bool CommandOptionDoubleChangeNotify(dsCommandOptionDouble_e Option) {return true;}
    virtual bool CommandOptionInt8ChangeNotify(dsCommandOptionInt8_e Option) {return true;}
    virtual bool CommandOptionInt16ChangeNotify(dsCommandOptionInt16_e Option) {return true;}
    virtual bool CommandOptionInt32ChangeNotify(dsCommandOptionInt32_e Option) {return true;}
    virtual bool CommandOptionBoolChangeNotify(dsCommandOptionBool_e Option) {return true;}
    virtual bool CommandOptionStringChangeNotify(dsCommandOptionString_e Option) {return true;}
    virtual bool CommandOptionPoint2DChangeNotify(dsCommandOptionPoint2d_e Option) {return true;}
    virtual bool CommandOptionPoint3DChangeNotify(dsCommandOptionPoint3d_e Option) {return true;}
    virtual bool ActiveSheetChangeNotify(const dsString&  SheetName) {return true;}
    virtual bool ObjectModifyNotify(dsObject * object) {return true;}
    virtual bool ObjectEraseNotify(dsObject * object,bool  Erased) {return true;}
    virtual bool ObjectAppendNotify(dsObject * object,bool  Appended) {return true;}
    virtual bool DestroyPreNotify() {return true;}
    virtual bool FileSavePostNotify2(const dsString& FileName) { return true; }
};



#define DeclareDocumentDestroyNotifyHook static bool DestroyNotifyHook(void* eventClassPtr);
#define DeclareDocumentFileSavePreNotifyHook static bool FileSavePreNotifyHook(void* eventClassPtr, const dsString &FileName, dsDocumentSaveAsOption_e SaveOption);
#define DeclareDocumentFileSavePostNotifyHook static bool FileSavePostNotifyHook(void* eventClassPtr);
#define DeclareDocumentModifyNotifyHook static bool ModifyNotifyHook(void* eventClassPtr);
#define DeclareDocumentCommandOptionInt8ChangeNotifyHook static bool CommandOptionInt8ChangeNotifyHook(void* eventClassPtr, dsCommandOptionInt8_e Option);
#define DeclareDocumentCommandOptionInt16ChangeNotifyHook static bool CommandOptionInt16ChangeNotifyHook(void* eventClassPtr, dsCommandOptionInt16_e Option);
#define DeclareDocumentCommandOptionInt32ChangeNotifyHook static bool CommandOptionInt32ChangeNotifyHook(void* eventClassPtr, dsCommandOptionInt32_e Option);
#define DeclareDocumentCommandOptionBoolChangeNotifyHook static bool CommandOptionBoolChangeNotifyHook(void* eventClassPtr, dsCommandOptionBool_e Option);
#define DeclareDocumentCommandOptionStringChangeNotifyHook static bool CommandOptionStringChangeNotifyHook(void* eventClassPtr, dsCommandOptionString_e Option);
#define DeclareDocumentCommandOptionPoint2DChangeNotifyHook static bool CommandOptionPoint2DChangeNotifyHook(void* eventClassPtr, dsCommandOptionPoint2d_e Option);
#define DeclareDocumentCommandOptionPoint3DChangeNotifyHook static bool CommandOptionPoint3DChangeNotifyHook(void* eventClassPtr, dsCommandOptionPoint3d_e Option);
#define DeclareDocumentActiveSheetChangeNotifyHook static bool ActiveSheetChangeNotifyHook(void* eventClassPtr, const dsString &SheetName);

#define DeclareDocumentCommandOptionDoubleChangeNotifyHook static bool CommandOptionDoubleChangeNotifyHook(void* eventClassPtr, dsCommandOptionDouble_e Option);
#define DeclareDocumentObjectModifyNotifyHook static bool ObjectModifyNotifyHook(void* eventClassPtr, dsObject* obj);
#define DeclareDocumentObjectAppendNotifyHook static bool ObjectAppendNotifyHook(void* eventClassPtr, dsObject* obj, bool  Appended);
#define DeclareDocumentObjectEraseNotifyHook static bool ObjectEraseNotifyHook(void* eventClassPtr, dsObject* obj,bool Erased);
#define DeclareDocumentDestroyPreNotifyHook static bool DestroyPreNotifyHook(void* eventClassPtr);
#define DeclareDocumentFileSavePostNotify2Hook static bool FileSavePostNotify2Hook(void* eventClassPtr, const dsString &FileName);

#define ImplementDocumentDestroyNotifyHook(EventClass)\
bool EventClass::DestroyNotifyHook(void* eventClassPtr) \
{ \
    return ((EventClass *) eventClassPtr)->DestroyNotify(); \
}


#define ImplementDocumentFileSavePreNotifyHook(EventClass) \
bool EventClass::FileSavePreNotifyHook(void* eventClassPtr, const dsString &FileName, dsDocumentSaveAsOption_e SaveOption) \
{ \
    return ((EventClass *) eventClassPtr)->FileSavePreNotify(FileName, SaveOption); \
}

#define ImplementDocumentFileSavePostNotifyHook(EventClass) \
bool EventClass::FileSavePostNotifyHook(void* eventClassPtr) \
{ \
    return ((EventClass *) eventClassPtr)->FileSavePostNotify(); \
}

#define ImplementDocumentModifyNotifyHook(EventClass) \
bool EventClass::ModifyNotifyHook(void* eventClassPtr) \
{ \
    return ((EventClass *) eventClassPtr)->ModifyNotify(); \
}

#define ImplementDocumentCommandOptionDoubleChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionDoubleChangeNotifyHook(void* eventClassPtr, dsCommandOptionDouble_e Option) \
{ \
    return ((EventClass *) eventClassPtr)->CommandOptionDoubleChangeNotify(Option); \
}
#define ImplementDocumentCommandOptionInt8ChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionInt8ChangeNotifyHook(void* eventClassPtr, dsCommandOptionInt8_e Option) \
{ \
    return ((EventClass *) eventClassPtr)->CommandOptionInt8ChangeNotify(Option); \
}

#define ImplementDocumentCommandOptionInt16ChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionInt16ChangeNotifyHook(void* eventClassPtr, dsCommandOptionInt16_e Option) \
{ \
    return ((EventClass *) eventClassPtr)->CommandOptionInt16ChangeNotify(Option); \
}

#define ImplementDocumentCommandOptionInt32ChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionInt32ChangeNotifyHook(void* eventClassPtr, dsCommandOptionInt32_e Option) \
{ \
    return ((EventClass *) eventClassPtr)->CommandOptionInt32ChangeNotify(Option); \
}

#define ImplementDocumentCommandOptionBoolChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionBoolChangeNotifyHook(void* eventClassPtr, dsCommandOptionBool_e Option) \
{ \
    return ((EventClass *) eventClassPtr)->CommandOptionBoolChangeNotify(Option); \
}

#define ImplementDocumentCommandOptionStringChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionStringChangeNotifyHook(void* eventClassPtr, dsCommandOptionString_e Option) \
{ \
    return ((EventClass *) eventClassPtr)->CommandOptionStringChangeNotify(Option); \
}

#define ImplementDocumentCommandOptionPoint2DChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionPoint2DChangeNotifyHook(void* eventClassPtr, dsCommandOptionPoint2d_e Option) \
{ \
    return ((EventClass *) eventClassPtr)->CommandOptionPoint2DChangeNotify(Option); \
}

#define ImplementDocumentCommandOptionPoint3DChangeNotifyHook(EventClass) \
bool EventClass::CommandOptionPoint3DChangeNotifyHook(void* eventClassPtr, dsCommandOptionPoint3d_e Option) \
{ \
	return ((EventClass *) eventClassPtr)->CommandOptionPoint3DChangeNotify(Option); \
}

#define ImplementDocumentActiveSheetChangeNotifyHook(EventClass) \
bool EventClass::ActiveSheetChangeNotifyHook(void* eventClassPtr, const dsString &SheetName) \
{ \
	return ((EventClass *) eventClassPtr)->ActiveSheetChangeNotify(SheetName); \
}

#define ImplementDocumentObjectModifyNotifyHook(EventClass) \
bool EventClass::ObjectModifyNotifyHook(void* eventClassPtr, dsObject *obj) \
{ \
	return ((EventClass *) eventClassPtr)->ObjectModifyNotify(obj); \
}

#define ImplementDocumentObjectAppendNotifyHook(EventClass) \
bool EventClass::ObjectAppendNotifyHook(void* eventClassPtr, dsObject *obj,bool  Appended) \
{ \
	return ((EventClass *) eventClassPtr)->ObjectAppendNotify(obj,Appended); \
}

#define ImplementDocumentObjectEraseNotifyHook(EventClass) \
bool EventClass::ObjectEraseNotifyHook(void* eventClassPtr, dsObject *obj,bool Erased) \
{ \
	return ((EventClass *) eventClassPtr)->ObjectEraseNotify(obj,Erased ); \
}

#define ImplementDocumentDestroyPreNotifyHook(EventClass)\
    bool EventClass::DestroyPreNotifyHook(void* eventClassPtr) \
{ \
    return ((EventClass *) eventClassPtr)->DestroyPreNotify(); \
}

#define ImplementDocumentFileSavePostNotify2Hook(EventClass) \
    bool EventClass::FileSavePostNotify2Hook(void* eventClassPtr, const dsString &FileName) \
{ \
    return ((EventClass *) eventClassPtr)->FileSavePostNotify2(FileName); \
} 


#define RegisterDocumentDestroyNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_DestroyNotify_id, this, (void *) DestroyNotifyHook);

#define RegisterDocumentFileSavePreNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_FileSavePreNotify_id, this, (void *) FileSavePreNotifyHook);

#define RegisterDocumentFileSavePostNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_FileSavePostNotify_id, this, (void *) FileSavePostNotifyHook);


#define RegisterDocumentModifyNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_ModifyNotify_id, this, (void *) ModifyNotifyHook);

#define RegisterDocumentCommandOptionDoubleChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionDoubleChangeNotify_id, this, (void *) CommandOptionDoubleChangeNotifyHook);
#define RegisterDocumentCommandOptionInt8ChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionInt8ChangeNotify_id, this, (void *) CommandOptionInt8ChangeNotifyHook);

#define RegisterDocumentCommandOptionInt16ChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionInt16ChangeNotify_id, this, (void *) CommandOptionInt16ChangeNotifyHook);

#define RegisterDocumentCommandOptionInt32ChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionInt32ChangeNotify_id, this, (void *) CommandOptionInt32ChangeNotifyHook);

#define RegisterDocumentCommandOptionBoolChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionBoolChangeNotify_id, this, (void *) CommandOptionBoolChangeNotifyHook);

#define RegisterDocumentCommandOptionStringChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionStringChangeNotify_id, this, (void *) CommandOptionStringChangeNotifyHook);

#define RegisterDocumentCommandOptionPoint2DChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionPoint2DChangeNotify_id, this, (void *) CommandOptionPoint2DChangeNotifyHook);

#define RegisterDocumentCommandOptionPoint3DChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_CommandOptionPoint3DChangeNotify_id, this, (void *) CommandOptionPoint3DChangeNotifyHook);

#define RegisterDocumentActiveSheetChangeNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_ActiveSheetChangeNotify_id, this, (void *) ActiveSheetChangeNotifyHook);

#define RegisterDocumentObjectModifyNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_ObjectModifyNotify_id, this, (void *) ObjectModifyNotifyHook);

#define RegisterDocumentObjectAppendNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_ObjectAppendNotify_id, this, (void *) ObjectAppendNotifyHook);

#define RegisterDocumentObjectEraseNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_ObjectEraseNotify_id, this, (void *) ObjectEraseNotifyHook);

#define RegisterDocumentDestroyPreNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsDocument_DestroyPreNotify_id, this, (void *) DestroyPreNotifyHook);

#define RegisterDocumentFileSavePostNotify2Hook(dsObject)\
    dsObject->RegisterEvent(dsDocument_FileSavePostNotify2_id, this, (void *) FileSavePostNotify2Hook);

////////////
#define UnRegisterDocumentDestroyNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_DestroyNotify_id, this, (void *) DestroyNotifyHook);

#define UnRegisterDocumentFileSavePreNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_FileSavePreNotify_id, this, (void *) FileSavePreNotifyHook);

#define UnRegisterDocumentFileSavePostNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_FileSavePostNotify_id, this, (void *) FileSavePostNotifyHook);


#define UnRegisterDocumentModifyNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_ModifyNotify_id, this, (void *) ModifyNotifyHook);

#define UnRegisterDocumentCommandOptionDoubleChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionDoubleChangeNotify_id, this, (void *) CommandOptionDoubleChangeNotifyHook);
#define UnRegisterDocumentCommandOptionInt8ChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionInt8ChangeNotify_id, this, (void *) CommandOptionInt8ChangeNotifyHook);

#define UnRegisterDocumentCommandOptionInt16ChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionInt16ChangeNotify_id, this, (void *) CommandOptionInt16ChangeNotifyHook);

#define UnRegisterDocumentCommandOptionInt32ChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionInt32ChangeNotify_id, this, (void *) CommandOptionInt32ChangeNotifyHook);

#define UnRegisterDocumentCommandOptionBoolChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionBoolChangeNotify_id, this, (void *) CommandOptionBoolChangeNotifyHook);

#define UnRegisterDocumentCommandOptionStringChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionStringChangeNotify_id, this, (void *) CommandOptionStringChangeNotifyHook);

#define UnRegisterDocumentCommandOptionPoint2DChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionPoint2DChangeNotify_id, this, (void *) CommandOptionPoint2DChangeNotifyHook);

#define UnRegisterDocumentCommandOptionPoint3DChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_CommandOptionPoint3DChangeNotify_id, this, (void *) CommandOptionPoint3DChangeNotifyHook);

#define UnRegisterDocumentActiveSheetChangeNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_ActiveSheetChangeNotify_id, this, (void *) ActiveSheetChangeNotifyHook);

#define UnRegisterDocumentObjectModifyNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_ObjectModifyNotify_id, this, (void *) ObjectModifyNotifyHook);

#define UnRegisterDocumentObjectAppendNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_ObjectAppendNotify_id, this, (void *) ObjectAppendNotifyHook);

#define UnRegisterDocumentObjectEraseNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_ObjectEraseNotify_id, this, (void *) ObjectEraseNotifyHook);

#define UnRegisterDocumentDestroyPreNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_DestroyPreNotify_id, this, (void *) DestroyPreNotifyHook);

#define UnRegisterDocumentFileSavePostNotify2Hook(dsObject)\
    dsObject->UnRegisterEvent(dsDocument_FileSavePostNotify2_id, this, (void *) FileSavePostNotify2Hook);
