//========================================================================//
//							SOURCE CODE LICENSE							  //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDoubleArray.h, C++ API dsDoubleArray interface
//
#pragma once

#include "dsLibrary_global.h"

class dsDoubleArray_pimpl;
class DSLIBRARY_EXPORT dsDoubleArray
{
public:
    dsDoubleArray(); // constructor 
    dsDoubleArray(const dsDoubleArray &a); // copy constructor 
    ~dsDoubleArray(); // distructor 
    dsDoubleArray& operator = (const dsDoubleArray &a); // assignment operator 
 
    double& operator [] (unsigned int index) const; // get array item 
    void add(const double &item); // Add item to the end of array 
 
    unsigned int getSize() const; // get size of array (DTements)
    void setSize(unsigned int newsize); // set size of array (DTements)
    void clear(); // clear array
    bool removeAt(unsigned int pos); // delete array item 
	void* getptr(); // get void* pointer to array data
 
    enum exception { MEMFAIL, WRONG_INDEX  }; // exception enum 
 
private:
    dsDoubleArray_pimpl *m_pimpl;    
};
