//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsDrawingProperties_c.h, C++ API dsDrawingProperties_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsDrawingProperties_p;
class dsDrawingProperties;
class DSINTERFACE_EXPORT dsDrawingProperties_c : public dsObject
{
    DECLARE_DSCPP_INTERFACE(dsDrawingProperties)
public:

    DSRESULT IsSame(dsDrawingProperties_c* dsObj);
    DSRESULT get_Author(dsString* Val);
    DSRESULT put_Author(const dsString& NewVal);
    DSRESULT get_Keywords(dsString* Val);
    DSRESULT put_Keywords(const dsString& NewVal);
    DSRESULT get_Comments(dsString* Val);
    DSRESULT put_Comments(const dsString& NewVal);
    DSRESULT get_Title(dsString* Val);
    DSRESULT put_Title(const dsString& NewVal);
    DSRESULT get_Subject(dsString* Val);
    DSRESULT put_Subject(const dsString& NewVal);
	DSRESULT AddCustomProperty(const dsString& Key, const dsString& Value);
	DSRESULT RemoveCustomProperty(const dsString& Key);
	DSRESULT RemoveCustomPropertyAt(long Index);
	DSRESULT GetCustomPropertyCount(long * Count);
	DSRESULT HasCustomProperty(const dsString& Key, bool * HasProperty);
	DSRESULT GetCustomProperty(const dsString& Key, dsString* Value);
	DSRESULT GetCustomPropertyAt(long Index, dsString* Key, dsString* Value);
	DSRESULT SetCustomProperty(const dsString& Key, const dsString& Value);
	DSRESULT SetCustomPropertyAt(long Index, const dsString& Value);
};
