//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsGroup_c.h, C++ API dsGroup_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsLongArray.h"

class dsGroup_p;
class dsGroup;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsGroup_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsGroup)
public:
	DSRESULT IsSame(dsGroup_c *dsObj);

	DSRESULT AddEntities(const dsObjectPtrArray& EntitiesArray);
	DSRESULT InsertEntitiesAt(long Index, const dsObjectPtrArray& EntitiesArray);
	DSRESULT RemoveEntities(const dsObjectPtrArray& EntitiesArray);
	DSRESULT RemoveEntityAt(long Index);
	DSRESULT GetEntities(dsLongArray* EntityTypeLongArray, dsObjectPtrArray *EntitiesArray);
	DSRESULT HasEntity(dsObject * Entity, bool *HasEntity);
	DSRESULT GetIndex(dsObject * Entity, long* Index);
	DSRESULT Explode();
	DSRESULT Reorder(long CurrentIndex, long NewIndex, long EntityCount);
	DSRESULT ReverseOrder();
	DSRESULT Rename(const dsString& Name);
	DSRESULT get_Name(dsString* Val);
	DSRESULT get_Description(dsString* Val);
	DSRESULT put_Description(const dsString& NewVal);
	DSRESULT get_Selectable(bool* Val);
	DSRESULT put_Selectable(bool NewVal);
	DSRESULT get_Unnamed(bool* Val);
	DSRESULT get_Handle(dsString* Val);
    DSRESULT get_Erased(bool * Val);
    DSRESULT put_Erased(bool NewVal);
    DSRESULT GetEntitiesCount(long* Count);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
