//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsHatchBoundaryLoop_c.h, C++ API dsHatchBoundaryLoop_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsDoubleArray.h"

class dsHatchBoundaryLoop_p;
class dsHatchBoundaryLoop;
class DSINTERFACE_EXPORT dsHatchBoundaryLoop_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsHatchBoundaryLoop)
public:
	DSRESULT IsSame(dsHatchBoundaryLoop_c* dsObj);

	DSRESULT get_Type(long* Val);
	DSRESULT get_IsPolyLine(bool * Val);
	DSRESULT GetPolyLineBoundaryLoopData(bool * HasBulge, bool * IsClosed, dsDoubleArray * CoordinateDblArray, dsDoubleArray * BulgesDblArray);
	DSRESULT GetEdgesCount(long * Count);
	DSRESULT GetEdgeType(long  Index, dsHatchEdgeType_e* EdgeType);
	DSRESULT GetLineEdgeData(long  Index, double * StartPointX, double * StartPointY, double * EndPointX, double * EndPointY);
	DSRESULT GetArcEdgeData(long  Index, double * CenterX, double * CenterY, double * Radius, double * StartAngle, double * EndAngle, bool * IsCounterclockwiseFlag);
	DSRESULT GetEllipseEdgeData(long  Index, double * CenterX, double * CenterY, double * MajorAxisX, double * MajorAxisY, double * MinorAxisLengthRatio, double * StartAngle, double * EndAngle, bool * IsCounterclockwiseFlag);
	DSRESULT GetSplineEdgeData(long  Index, long * Degree, bool * Rational, bool * Periodic, dsDoubleArray * KnotValuesDblArray, dsDoubleArray * ControlPointsDblArray);
};
