//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLayerManager_c.h, C++ API dsLayerManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsLayerManager_p;
class dsLayer_c;
class dsLayerManager;
class dsViewport_c;
class DSINTERFACE_EXPORT dsLayerManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLayerManager)
public:
	DSRESULT IsSame(dsLayerManager_c* dsObj);

	DSRESULT CreateLayer(const dsString& Name, dsLayer_c** Layer, dsCreateObjectResult_e* Result);
	DSRESULT GetLayer(const dsString& Name, dsLayer_c** Layer);
	DSRESULT GetActiveLayer(dsLayer_c** Layer);
	DSRESULT GetLayers(dsObjectPtrArray* LayerArray);
	DSRESULT RemoveLayer(const dsString& Name, bool* Result);
	DSRESULT RemoveAllOverrides(const dsObjectPtrArray & LayerArray);
	DSRESULT RemoveViewportOverrides(const dsObjectPtrArray & LayerArray, dsViewport_c * Viewport);
	DSRESULT RemoveColorOverrides(const dsObjectPtrArray & LayerArray);
	DSRESULT RemoveColorOverride(const dsObjectPtrArray & LayerArray, dsViewport_c * Viewport);
	DSRESULT RemoveLineStyleOverrides(const dsObjectPtrArray & LayerArray);
	DSRESULT RemoveLineStyleOverride(const dsObjectPtrArray & LayerArray, dsViewport_c * Viewport);
	DSRESULT RemoveLineWeightOverrides(const dsObjectPtrArray & LayerArray);
	DSRESULT RemoveLineWeightOverride(const dsObjectPtrArray & LayerArray, dsViewport_c * Viewport);
	DSRESULT RemoveTransparencyOverrides(const dsObjectPtrArray & LayerArray);
	DSRESULT RemoveTransparencyOverride(const dsObjectPtrArray & LayerArray, dsViewport_c * Viewport);
	DSRESULT RemovePrintStyleOverrides(const dsObjectPtrArray & LayerArray);
	DSRESULT RemovePrintStyleOverride(const dsObjectPtrArray & LayerArray, dsViewport_c * Viewport);
};
