//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLispFunction_c.h, C++ API dsLispFunction_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsLispFunction_p;
class dsLispFunction;
class dsLispParameter_c;
class DSINTERFACE_EXPORT dsLispFunction_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLispFunction)
public:
	DSRESULT RegisterEvent(dsLispFunctionEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT UnRegisterEvent(dsLispFunctionEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT IsSame(dsLispFunction_c* dsObj);

	DSRESULT GetName(dsString*  Name);
	DSRESULT GetApiID(dsString*  ApiUuid);
	DSRESULT GetArguments(dsObjectPtrArray * ArgumentsArray);
	DSRESULT CreateReturnValue(dsLispParameter_c ** ReturnValue);
	DSRESULT SetReturnValue(dsLispParameter_c * Value);
};

class dsLispFunctionEvents_c
{
public:

	virtual bool ExecuteFunctionNotify( ) {return true;}
};

#define DeclareLispFunctionExecuteFunctionNotifyHook static bool ExecuteFunctionNotifyHook(void* eventClassPtr);

#define ImplementLispFunctionExecuteFunctionNotifyHook(EventClass)\
bool EventClass ::ExecuteFunctionNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->ExecuteFunctionNotify(); \
}

#define RegisterLispFunctionExecuteFunctionNotifyHook(dsObject)\
        dsObject->RegisterEvent(dsLispFunction_ExecuteFunctionNotify_id, this, reinterpret_cast< void * >( ExecuteFunctionNotifyHook ) );

#define UnRegisterLispFunctionExecuteFunctionNotifyHook(dsObject)\
        dsObject->UnRegisterEvent(dsLispFunction_ExecuteFunctionNotify_id, this, reinterpret_cast< void * >( ExecuteFunctionNotifyHook ));
