//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsLispParameter_c.h, C++ API dsLispParameter_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsLispParameter_p;
class dsLispParameter;
class dsMathPoint_c;
class DSINTERFACE_EXPORT dsLispParameter_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsLispParameter)
public:
	DSRESULT IsSame(dsLispParameter_c* dsObj);

	DSRESULT get_Type(dsLispParameterType_e*  Type);
	DSRESULT GetInteger(long * Value);
	DSRESULT GetDouble(double * Value);
	DSRESULT GetPoint(dsMathPoint_c ** Value);
	DSRESULT GetString(dsString*  Value);
	DSRESULT GetHandle(dsString*  Value);
	DSRESULT GetList(dsObjectPtrArray * LispParameterArray);
	DSRESULT SetToInteger(long  Value);
	DSRESULT SetToDouble(double  Value);
	DSRESULT SetToPoint(dsMathPoint_c * Value);
	DSRESULT SetToNil( );
	DSRESULT SetToVoid( );
	DSRESULT SetToTrue( );
	DSRESULT SetToString(const dsString&  Value);
	DSRESULT SetToHandle(const dsString&  Value);
	DSRESULT SetToList(const dsObjectPtrArray&  LispParameterArray);
};
