//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMacroManager_c.h, C++ API dsMacroManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsMacroManager_p;
class dsMacroManager;
class DSINTERFACE_EXPORT dsMacroManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMacroManager)
public:
	DSRESULT IsSame(dsMacroManager_c* dsObj);
    DSRESULT get_SavePath(dsString* Val);
    DSRESULT put_SavePath(const dsString& NewVal);
    DSRESULT get_LevelOfDetail(dsMacroLevelOfDetail_e* Val);
    DSRESULT put_LevelOfDetail(dsMacroLevelOfDetail_e NewVal);
    DSRESULT get_Language(dsMacroLanguage_e* Val);
    DSRESULT put_Language(dsMacroLanguage_e NewVal);
    DSRESULT StartMacroRecording(void);
    DSRESULT StopMacroRecording(const dsString& MacroName);

};
