//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMathCircArc_c.h, C++ API dsMathCircArc_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"


class dsMathCircArc_p;
class dsMathCircArc;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathVector_c;
class dsMathPoint_c;
class dsMathPlane_c;
class dsMathLine_c;
class dsMathTransform_c;
class dsMathEllipArc_c;

class DSINTERFACE_EXPORT dsMathCircArc_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMathCircArc)
public:
	DSRESULT IsSame(dsMathCircArc_c* dsObj);
	DSRESULT GetLength(double * Length);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT GetRefVector(dsMathVector_c ** RefVector);
	DSRESULT GetStartPoint(dsMathPoint_c ** StartPoint);
	DSRESULT GetEndPoint(dsMathPoint_c ** EndPoint);
	DSRESULT GetPlane(dsMathPlane_c ** Plane);
	DSRESULT SetAxes(dsMathVector_c * Normal, dsMathVector_c * RefVector);
	DSRESULT GetClosestPointTo(dsMathPoint_c * Point, dsMathPoint_c ** ClosestPoint);
	DSRESULT GetClosestPointToLinearObject(dsMathLine_c * LinearObject, dsMathPoint_c ** PointOnLinearObject, dsMathPoint_c ** ClosestPoint);
    DSRESULT GetClosestPointToCircArc(dsMathCircArc_c * CircArcObject , dsMathPoint_c ** PointOnCircArcObject , dsMathPoint_c ** ClosestPoint);
 	DSRESULT GetClosestPointToEllipArc(dsMathEllipArc_c * EllipArcObject, dsMathPoint_c ** PointOnEllipArcObject, dsMathPoint_c ** ClosestPoint);
	DSRESULT GetClosestPointToPlane(dsMathPlane_c * Plane, dsMathPoint_c ** PointOnPlane, dsMathPoint_c ** ClosestPoint);
	DSRESULT IntersectWithLinearObject(dsMathLine_c * LinearObject, dsMathPoint_c ** IntersectionPoint1, dsMathPoint_c ** IntersectionPoint2, long * NumIntersections);
	DSRESULT IntersectWithCircArc(dsMathCircArc_c * CircArc, dsMathPoint_c ** IntersectionPoint1, dsMathPoint_c ** IntersectionPoint2, long * NumIntersections);
	DSRESULT IntersectWithPlane(dsMathPlane_c * Plane , dsMathPoint_c ** IntersectionPoint1 , dsMathPoint_c ** IntersectionPoint2 , long*  NumIntersections);
	DSRESULT TransformBy(dsMathTransform_c * Transform);
	DSRESULT get_Center(dsMathPoint_c ** Val);
	DSRESULT put_Center(dsMathPoint_c * NewVal);
	DSRESULT get_StartAngle(double*  Val);
	DSRESULT put_StartAngle(double  NewVal);
	DSRESULT get_EndAngle(double*  Val);
	DSRESULT put_EndAngle(double  NewVal);
	DSRESULT get_Radius(double*  Val);
	DSRESULT put_Radius(double  NewVal);
};
