//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsMenuItem_c.h, C++ API dsMenuItem_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsMenuItem_p;
class dsMenuItem;
class DSINTERFACE_EXPORT dsMenuItem_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsMenuItem)
public:
	DSRESULT IsSame(dsMenuItem_c* Obj);
	DSRESULT GetType(dsMenuItemType_e* ItemType);
	DSRESULT GetMenuItems(dsObjectPtrArray* MenuItemArray);
	DSRESULT InsertMenuItem(const dsString& ApiUuid, dsMenuItemType_e ItemType, long Position, const dsString& ItemName, const dsString& UserCmdID, dsMenuItem_c** MenuItem);
	DSRESULT get_Name(dsString* Val);
	DSRESULT put_Name(const dsString& NewVal);
	DSRESULT GetID(dsString* ID);
	DSRESULT get_Enabled(bool* Val);
	DSRESULT put_Enabled(bool NewVal);

	DSRESULT Remove( );
	DSRESULT GetApiID(dsString*  ApiUuid);
};