//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsObjectPtrArray.h, C++ API dsObjectPtrArray interface
//

#pragma once
#include "dsLibrary_global.h"
#include "dsArray.h"

class dsObject;

class DSLIBRARY_EXPORT dsObjectPtrArray
{
public:
	dsObjectPtrArray(void);
    dsObjectPtrArray( const dsObjectPtrArray & src );

	~dsObjectPtrArray(void);

    dsObjectPtrArray& operator = ( const dsObjectPtrArray & src );
    dsObject * operator [] (unsigned int index);

    // Reference to an address of a constant. But constant dsObjects are not very useful. 
    // Left for backward compatibility.
    void add(const dsObject * &item);
    bool remove(const dsObject* &item); 
    
    // What was intended: reference to a constant address.
    // void add( dsObject * const & item );

    // But it's simpler to pass address by value.
    void add( dsObject * item );
    bool remove( dsObject* item ); 

    unsigned int getSize(); 
    void setSize(unsigned int newSize); 
    void clear(); 
	bool removeAt(unsigned int index); 

private:
	void *getPImpl() const ;
	void *m_pimpl;
};