//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsPolyLine_c.h, C++ API dsPolyLine_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsDoubleArray.h"

class dsTransparency_c;
class dsPolyLine_p;
class dsPolyLine;
class dsColor_c;
class dsLine_c;
class dsCircleArc_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathVector_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsPolyLine_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsPolyLine)
public:
	DSRESULT IsSame(dsPolyLine_c* val);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_GlobalWidth(double * Val);
	DSRESULT put_GlobalWidth(double  NewVal);
	DSRESULT get_Closed(bool * Val);
	DSRESULT put_Closed(bool  NewVal);
	DSRESULT get_LineStyleGeneration(bool * Val);
	DSRESULT put_LineStyleGeneration(bool  NewVal);
	DSRESULT GetVerticesCount( long* Val);
	DSRESULT GetVertexCoordinate( long VertexIndex, double * X, double * Y, bool * Success);
	DSRESULT GetSegmentStartWidth( long SegmentIndex, double * StartWidth, bool * Success);
	DSRESULT GetSegmentEndWidth( long SegmentIndex, double * EndWidth, bool * Success);
	DSRESULT SetVertexCoordinate( long VertexIndex, double  X, double  Y, bool * Success);
	DSRESULT SetSegmentStartWidth( long SegmentIndex, double  StartWidth, bool * Success);
	DSRESULT SetSegmentEndWidth( long SegmentIndex, double  EndWidth, bool * Success);
	DSRESULT AddVertexAfter( long VertexIndex, double  X, double  Y, bool * Success);
	DSRESULT Split( long VertexIndex, dsPolyLine_c ** NewPolyline, bool * Result);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT Decurve(bool * Success);
	DSRESULT Fit(bool * Success);
	DSRESULT Spline(bool * Success);
	DSRESULT JoinLine(dsLine_c * Line, bool * Success);
	DSRESULT JoinCircleArc(dsCircleArc_c * Arc, bool * Success);
	DSRESULT JoinPolyLine(dsPolyLine_c * PolyLine, bool * Success);
	DSRESULT get_Type(dsPolyLine2DType_e* Val);
	DSRESULT GetSegmentAngle( long  SegmentIndex, double * Angle, bool * Success);
	DSRESULT SetSegmentAngle( long  SegmentIndex, double  Angle, bool * Success);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetLength(double * Length);
	DSRESULT GetClosestPointOn(double  GivenPointX, double  GivenPointY, double  GivenPointZ, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ);
	DSRESULT GetEndParams(double * StartParameter, double * EndParameter);
	DSRESULT EvaluateAtParameter(double  Parameter, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ, double * Distance, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT EvaluateAtPoint(double  PointOnCurveX, double  PointOnCurveY, double  PointOnCurveZ, double * Parameter, double * Distance, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT EvaluateAtDistance(double  Distance, double * PointOnCurveX, double * PointOnCurveY, double * PointOnCurveZ, double * Parameter, dsDoubleArray * FirstDerivativeDblArray, dsDoubleArray * SecondDerivativeDblArray);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT get_Elevation(double * Val);
	DSRESULT put_Elevation(double  Val);
	DSRESULT get_Thickness(double * Val);
	DSRESULT put_Thickness(double  Val);
	DSRESULT RemoveVertex(long  VertexIndex);
	DSRESULT Straighten(long  VertexIndexStart, long  VertexIndexEnd);
	DSRESULT GetSegmentType(long  SegmentIndex, dsPolyLineSegmentType_e* SegmentType);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT SetNormal(dsMathVector_c * Normal);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
