//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsPrintManager_c.h, C++ API dsPrintManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsStringArray.h"

class dsPrintManager_p;
class dsPrintManager;
class DSINTERFACE_EXPORT dsPrintManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsPrintManager)
public:
	DSRESULT IsSame(dsPrintManager_c* Obj);

	DSRESULT get_Printer(dsString* Val);
	DSRESULT put_Printer(const dsString& NewVal);
	DSRESULT GetPaperSize(double* Length, double* Width);
	DSRESULT SetClosestValidPaperSize(double Length, double Width);
	DSRESULT get_ScaleToFit(bool* Val);
	DSRESULT put_ScaleToFit(bool NewVal);
	DSRESULT get_UserScale(bool* Val);
	DSRESULT put_UserScale(bool NewVal);
	DSRESULT get_ScaleLineWeight(bool* Val);
	DSRESULT put_ScaleLineWeight(bool NewVal);
	DSRESULT GetPrintMargins(double* Top, double* Bottom, double* Left, double* Right);
	DSRESULT SetPrintMargins(double Top, double Bottom, double Left, double Right);
	DSRESULT get_StyleTable(dsString* Val);
	DSRESULT put_StyleTable(const dsString& NewVal);
	DSRESULT get_ViewDisplayStyle(dsViewDisplayStyle_e* Val);
	DSRESULT put_ViewDisplayStyle(dsViewDisplayStyle_e NewVal);
	DSRESULT get_Quality(long* Val);
	DSRESULT put_Quality(long NewVal);
	DSRESULT get_Orientation(dsPrintOrientation_e* Val);
	DSRESULT put_Orientation(dsPrintOrientation_e NewVal);
	DSRESULT get_PrintOnCenter(bool* Val);
	DSRESULT put_PrintOnCenter(bool NewVal);
	DSRESULT GetPrintOffset(double* XOffset, double* YOffset);
	DSRESULT SetPrintOffset(double XOffset, double YOffset);
	DSRESULT PrintOut(long Copies, const dsString& FileName);
	DSRESULT AvailablePaperSizes(dsStringArray* PaperSizesStrArray);
	DSRESULT get_PaperSize(dsString* Val);
	DSRESULT put_PaperSize(const dsString& NewVal);
	DSRESULT GetUserScaleValue(double * PaperUnits, double * DrawingUnits);
	DSRESULT SetUserScaleValue(double  PaperUnits, double  DrawingUnits);
	DSRESULT GetStandardScale(dsStandardPrintScale_e* StdScaleType, double * ScaleValue);
	DSRESULT SetStandardScale(dsStandardPrintScale_e StdScaleType);
	DSRESULT SetPrintRange(dsPrintRange_e PrintRange, const dsString&  NamedView, bool  WithinSpecifiedWindow, double  WinXMin, double  WinYMin, double  WinXMax, double  WinYMax);
	DSRESULT get_PrintInverse(bool * Val);
	DSRESULT put_PrintInverse(bool  NewVal);
	DSRESULT get_HideGeometryOnSheet(bool * Val);
	DSRESULT put_HideGeometryOnSheet(bool  NewVal);
	DSRESULT get_PrintInBackground(bool * Val);
	DSRESULT put_PrintInBackground(bool  NewVal);
	DSRESULT get_PrintSheetLast(bool * Val);
	DSRESULT put_PrintSheetLast(bool  NewVal);
	DSRESULT get_UseAssignedLineWeight(bool * Val);
	DSRESULT put_UseAssignedLineWeight(bool  NewVal);
	DSRESULT get_UseAssignedPrintStyle(bool * Val);
	DSRESULT put_UseAssignedPrintStyle(bool  NewVal);
	DSRESULT GetPrintRange(dsPrintRange_e* PrintRange, dsString*  NamedView, bool * WithinSpecifiedWindow, double * WinXMin, double * WinYMin, double * WinXMax, double * WinYMax);
	DSRESULT GetAvailablePrinters(dsStringArray * PrintersStrArray);
	DSRESULT AvailablePaperSizesInLocale(dsStringArray * PaperSizesStrArray);
	DSRESULT PaperSizeInLocale(const dsString&  PaperSize, dsString*  PaperSizeInLocale);
};