//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsReferenceImage_c.h, C++ API dsReferenceImage_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsDoubleArray.h"

class dsReferenceImage_p;
class dsReferenceImage;
class dsColor_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsReferenceImage_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsReferenceImage)
public:
	DSRESULT IsSame(dsReferenceImage_c* Obj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT get_Brightness(long * Val);
	DSRESULT put_Brightness(long  NewVal);
	DSRESULT get_Contrast(long * Val);
	DSRESULT put_Contrast(long  NewVal);
	DSRESULT get_Fade(long * Val);
	DSRESULT put_Fade(long  NewVal);
	DSRESULT get_Height(double * Val);
	DSRESULT put_Height(double  NewVal);
	DSRESULT get_Width(double * Val);
	DSRESULT put_Width(double  NewVal);
	DSRESULT get_ScaleImage(double * Val);
	DSRESULT put_ScaleImage(double  NewVal);
	DSRESULT get_Rotation(double * Val);
	DSRESULT put_Rotation(double  NewVal);
	DSRESULT get_ShowClipped(bool * Val);
	DSRESULT put_ShowClipped(bool  NewVal);
	DSRESULT get_ShowImage(bool * Val);
	DSRESULT put_ShowImage(bool  NewVal);
	DSRESULT get_Transparency(bool * Val);
	DSRESULT put_Transparency(bool  NewVal);
	DSRESULT GetPosition(double * X, double * Y, double * Z);
	DSRESULT SetPosition(double  X, double  Y, double  Z);
	DSRESULT GetPath(dsString*  ImagePath);
	DSRESULT SetPath(const dsString&  ImagePath);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
    DSRESULT Reload();
    DSRESULT Unload();
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT SetClipBoundary(const dsDoubleArray&  ClipPointsDblArray);
	DSRESULT GetClipBoundary(dsDoubleArray * ClipPointsDblArray );
	DSRESULT RemoveClipBoundary( );
};
