//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsRegion_c.h, C++ API dsRegion_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsRegion_p;
class dsRegion;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathPlane_c;
class dsMathVector_c;
class dsColor_c;
class dsDictionary_c;
class dsTransparency_c;
class dsMathPoint_c;

class DSINTERFACE_EXPORT dsRegion_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsRegion)
public:
	DSRESULT IsSame(dsRegion_c* dsObj);

	DSRESULT Select(bool  SelectFlag, bool * Res);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT GetArea(double * Area);
	DSRESULT GetPerimeter(double * Perimeter);
	DSRESULT GetPlane(dsMathPlane_c ** Plane);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT get_Layer(dsString*  Val);
	DSRESULT put_Layer(const dsString&  NewVal);
	DSRESULT get_LineStyle(dsString*  Val);
	DSRESULT put_LineStyle(const dsString&  NewVal);
	DSRESULT get_LineScale(double * Val);
	DSRESULT put_LineScale(double  NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);
	DSRESULT get_Visible(bool * Val);
	DSRESULT put_Visible(bool  NewVal);
	DSRESULT get_Color(dsColor_c** Color);
	DSRESULT put_Color(dsColor_c*  Color);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT get_Handle(dsString*  Val);
	//DSRESULT put_Handle(const dsString&  NewVal);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
	DSRESULT GetCentroid(dsMathPoint_c ** Centroid);
};
