//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsSelectionManager_c.h, C++ API dsSelectionManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsDoubleArray.h"
#include "dsLongArray.h"

class dsSelectionManager_p;
class dsSelectionManager;
class dsSelectionFilter_c;
class dsMathPoint_c;
class DSINTERFACE_EXPORT dsSelectionManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsSelectionManager)
public:
	DSRESULT IsSame(dsSelectionManager_c* Obj);

	DSRESULT GetSelectedObjectCount(dsSelectionSetType_e SSType, long* SelCount);
	DSRESULT GetSelectedObject(dsSelectionSetType_e SSType, long AtIndex, dsObjectType_e* ObjType, dsObject **SelObj);
	DSRESULT ClearSelections(dsSelectionSetType_e SSType);
	DSRESULT RegisterEvent(dsSelectionManagerEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT UnRegisterEvent(dsSelectionManagerEvent_id_e eventId, void* eventClassPtr, void *eventFuncPtr);
	DSRESULT GetSelectionFilter(dsSelectionFilter_c ** SelectionFilter);
	DSRESULT SelectByPoint(dsMathPoint_c * Point, bool * Result);
	DSRESULT SelectByWindow(dsMathPoint_c *  FirstPoint, dsMathPoint_c * SecondPoint, bool  Crossing, bool * Result );
    DSRESULT SelectByPolygon(const dsDoubleArray& CoordinateDblArray, bool  Crossing, bool * Result );
	DSRESULT SelectByCrossline( const dsDoubleArray& CoordinateDblArray, bool * Result );
	DSRESULT GetPickPoints(dsSelectionSetType_e  SSType, dsDoubleArray *  CoordinateDblArray);
	DSRESULT GetSelectedObjects(dsSelectionSetType_e  SSType, dsLongArray* EntityTypeLongArray, dsObjectPtrArray* EntitiesArray);
	DSRESULT get_PaperSpaceSelectionEnabled(bool * Val);
	DSRESULT put_PaperSpaceSelectionEnabled(bool  NewVal);
	DSRESULT get_RemoveOptions(long * Val);
	DSRESULT put_RemoveOptions(long  NewVal);
};


class dsSelectionManagerEvents_c
{
public:
	virtual bool SelectionChangedNotify() {return true;}
	virtual bool SelectionPreNotify() {return true;}
};



#define DeclareSelectionManagerSelectionChangedNotifyHook static bool SelectionChangedNotifyHook(void* eventClassPtr);

#define DeclareSelectionManagerSelectionPreNotifyHook static bool SelectionPreNotifyHook(void* eventClassPtr);


#define ImplementSelectionManagerSelectionChangedNotifyHook(EventClass)\
bool EventClass::SelectionChangedNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->SelectionChangedNotify(); \
}

#define ImplementSelectionManagerSelectionPreNotifyHook(EventClass)\
bool EventClass::SelectionPreNotifyHook(void* eventClassPtr) \
{ \
	return ((EventClass *) eventClassPtr)->SelectionPreNotify(); \
}


#define RegisterSelectionManagerSelectionChangedNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsSelectionManager_SelectionChangedNotify_id, this, (void *) SelectionChangedNotifyHook);

#define RegisterSelectionManagerSelectionPreNotifyHook(dsObject)\
    dsObject->RegisterEvent(dsSelectionManager_SelectionPreNotify_id, this, (void *) SelectionPreNotifyHook);

#define UnRegisterSelectionManagerSelectionChangedNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsSelectionManager_SelectionChangedNotify_id, this, (void *) SelectionChangedNotifyHook);

#define UnRegisterSelectionManagerSelectionPreNotifyHook(dsObject)\
    dsObject->UnRegisterEvent(dsSelectionManager_SelectionPreNotify_id, this, (void *) SelectionPreNotifyHook);
