//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsSheet_c.h, C++ API dsSheet_c interface
//

#pragma once
#include "dsinterface_global.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"
#include "dsInterfaceDefs.h"
#include "dsDoubleArray.h"

class dsSketchManager_c;
class dsSheet_p;
class dsSheet;
class dsCustomData_c;
class dsViewport_c;
class dsMathPoint_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsSheet_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsSheet)
public:
	DSRESULT IsSame(dsSheet_c* Obj);


	DSRESULT get_Name(dsString* Val);
	DSRESULT put_Name(const dsString& NewVal);
	DSRESULT IsActive(bool* Val);
	DSRESULT Activate();
	DSRESULT GetSketchManager(dsSketchManager_c** SkMngr);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetViewports(dsObjectPtrArray * ViewportArray);
	DSRESULT GetActiveViewport(dsViewport_c ** Viewport);
	DSRESULT InsertRectangularViewport(dsStandardViewports_e Mode, bool  Fit, dsMathPoint_c * StartCorner, dsMathPoint_c * OppositeCorner, dsViewport_c ** Viewport);
	DSRESULT InsertPolygonalViewport(const dsDoubleArray&  VerticesCoordinateDblArray, dsViewport_c ** Viewport);
	DSRESULT InsertViewportByEntity(dsObject * Entity, dsViewport_c ** Viewport);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_PrintStyleTable(dsString*  Val);
	DSRESULT put_PrintStyleTable(const dsString&  NewVal);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
};