//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsStringArray.h, C++ API dsStringArray interface
//

#pragma once

#include "dsLibrary_global.h"
#include "dsString.h"

class dsStringArray_pimpl;
class DSLIBRARY_EXPORT dsStringArray
{
public:
    dsStringArray (void);
    dsStringArray (const dsStringArray &other); 
    ~dsStringArray (void);
    dsStringArray & operator = (const dsStringArray &dsArr); 
    dsString operator [] (unsigned int index) const; 
    void add(const dsString &item); 
    void clear(); 
    bool removeAt(unsigned int index); 

	unsigned int getSize() const; // get size of array 

	enum exception { WRONG_INDEX }; // exception enum 

private:
    dsStringArray_pimpl *m_pimpl;    
};
