//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsTable_c.h, C++ API dsTable_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTransparency_c;
class dsTable_p;
class dsTable;
class dsColor_c;
class dsTableStyle_c;
class dsCustomData_c;
class dsHyperLink_c;
class dsMathVector_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsTable_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsTable)
public:
	DSRESULT IsSame(dsTable_c* dsObj);

	DSRESULT get_Layer(dsString* Val);
	DSRESULT put_Layer(const dsString& NewVal);
	DSRESULT get_LineStyle(dsString* Val);
	DSRESULT put_LineStyle(const dsString& NewVal);
	DSRESULT get_LineScale(double* Val);
	DSRESULT put_LineScale(double NewVal);
	DSRESULT get_LineWeight(dsLineWeight_e* Val);
	DSRESULT put_LineWeight(dsLineWeight_e NewVal);	
	DSRESULT get_Visible(bool* Val);
	DSRESULT put_Visible(bool NewVal);
	DSRESULT Select(bool SelectFlag, bool* Res);
	DSRESULT get_Color(dsColor_c ** Val);
	DSRESULT put_Color(dsColor_c * NewVal);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
	DSRESULT get_TableStyle(dsTableStyle_c ** Val);
	DSRESULT put_TableStyle(dsTableStyle_c * NewVal);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT GetHyperLink(dsHyperLink_c ** HyperLink);
	DSRESULT SetHyperLink(dsHyperLink_c * HyperLink);
	DSRESULT DeleteHyperLink( );
	DSRESULT GetBoundingBox(double * X1, double * Y1, double * Z1, double * X2, double * Y2, double * Z2);
	DSRESULT GetNormal(dsMathVector_c ** Normal);
	DSRESULT SetNormal(dsMathVector_c * Normal);
	DSRESULT GetText(long  Row, long  Column, dsString*  CellText);
	DSRESULT SetText(long  Row, long  Column, const dsString&  CellText);
	DSRESULT DeleteColumn(long  Index, bool * Retval);
	DSRESULT DeleteRow(long  Index, bool * Retval);
	DSRESULT TotalColumnCount(long * Count);
	DSRESULT TotalRowCount(long * Count);
	DSRESULT InsertColumn(long  Index, double  Width, bool * Retval);
	DSRESULT InsertRow(long  Index, double  Height, bool * Retval);
	DSRESULT GetRowHeight(long  Row, double * Height);
	DSRESULT SetRowHeight(double  Height);
	DSRESULT SetRowHeightAt(long  Row, double  Height);
	DSRESULT GetColumnWidth(long  Column, double * Width);
	DSRESULT SetColumnWidth(double  Width);
	DSRESULT SetColumnWidthAt(long  Column, double  Width);
	DSRESULT SaveAsCSVFile(const dsString&  FileName, bool * Retval);
	DSRESULT GetPosition(double * X, double * Y, double * Z);
	DSRESULT SetPosition(double  X, double  Y, double  Z);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT get_Direction(dsTableDirection_e* Val);
	DSRESULT put_Direction(dsTableDirection_e  NewVal);
	DSRESULT GetCellType(long  Row, long  Column, dsTableCellType_e*  CellType);
	DSRESULT SetCellType(long  Row, long  Column, dsTableCellType_e  CellType);
	DSRESULT MergeCells(long  MinRow, long  MaxRow, long  MinColumn, long  MaxColumn);
	DSRESULT UnmergeCells(long  MinRow, long  MaxRow, long  MinColumn, long  MaxColumn);
	DSRESULT GetAlignment(dsTableCellType_e  CellType, dsTableCellAlignment_e*  Alignment);
	DSRESULT SetAlignment(dsTableCellType_e  CellType, dsTableCellAlignment_e  Alignment);
	DSRESULT GetCellAlignment(long  Row, long  Column, dsTableCellAlignment_e*  Alignment);
	DSRESULT SetCellAlignment(long  Row, long  Column, dsTableCellAlignment_e  Alignment);
	DSRESULT GetBackgroundColor(dsTableCellType_e  CellType, dsColor_c ** Val);
	DSRESULT SetBackgroundColor(dsTableCellType_e  CellType, dsColor_c * NewVal);
	DSRESULT GetCellBackgroundColor(long  Row, long  Column, dsColor_c ** Val);
	DSRESULT SetCellBackgroundColor(long  Row, long  Column, dsColor_c * NewVal);
	DSRESULT GetBordersColor(dsTableCellType_e  CellType, dsTableBordersLineType_e  LineType, dsColor_c ** Val);
	DSRESULT SetBordersColor(dsTableCellType_e  CellType, dsTableBordersLineType_e  LineType, dsColor_c * NewVal);
	DSRESULT GetCellBordersColor(long  Row, long  Column, dsTableBordersLineType_e  LineType, dsColor_c ** Val);
	DSRESULT SetCellBordersColor(long  Row, long  Column, dsTableBordersLineType_e  LineType, dsColor_c * NewVal);
	DSRESULT GetBordersLineWeight(dsTableCellType_e  CellType, dsTableBordersLineType_e  LineType, dsLineWeight_e*  LineWeight);
	DSRESULT SetBordersLineWeight(dsTableCellType_e  CellType, dsTableBordersLineType_e  LineType, dsLineWeight_e  LineWeight);
	DSRESULT GetCellBordersLineWeight(long  Row, long  Column, dsTableBordersLineType_e  LineType, dsLineWeight_e*  LineWeight);
	DSRESULT SetCellBordersLineWeight(long  Row, long  Column, dsTableBordersLineType_e  LineType, dsLineWeight_e  LineWeight);
	DSRESULT GetBordersVisibility(dsTableCellType_e  CellType, dsTableBordersLineType_e  LineType, bool * Visible);
	DSRESULT SetBordersVisibility(dsTableCellType_e  CellType , dsTableBordersLineType_e  LineType, bool  Visible);
	DSRESULT GetCellBordersVisibility(long  Row, long  Column, dsTableBordersLineType_e  LineType, bool * Visible);
	DSRESULT SetCellBordersVisibility(long  Row, long  Column, dsTableBordersLineType_e  LineType, bool  Visible);
	DSRESULT GetHorizontalMargin(double * Margin);
	DSRESULT SetHorizontalMargin(double  Margin);
	DSRESULT GetCellHorizontalMargin(long  Row, long  Column, double * Margin);
	DSRESULT SetCellHorizontalMargin(long  Row, long  Column, double  Margin);
	DSRESULT GetVerticalMargin(double * Margin);
	DSRESULT SetVerticalMargin(double  Margin);
	DSRESULT GetCellVerticalMargin(long  Row, long  Column, double * Margin);
	DSRESULT SetCellVerticalMargin(long  Row, long  Column, double  Margin);
	DSRESULT GetTextColor(dsTableCellType_e  CellType, dsColor_c ** Val);
	DSRESULT SetTextColor(dsTableCellType_e  CellType, dsColor_c * NewVal);
	DSRESULT GetCellTextColor(long  Row, long  Column, dsColor_c ** Val);
	DSRESULT SetCellTextColor(long  Row, long  Column, dsColor_c * NewColor);
	DSRESULT GetTextHeight(dsTableCellType_e  CellType, double * Height);
	DSRESULT SetTextHeight(dsTableCellType_e  CellType, double  Height);
	DSRESULT GetCellTextHeight(long  Row, long  Column, double * Height);
	DSRESULT SetCellTextHeight(long  Row, long  Column, double  Height);
	DSRESULT GetTextStyle(dsTableCellType_e  CellType, dsString*  TextStyle);
	DSRESULT SetTextStyle(dsTableCellType_e  CellType, const dsString&  TextStyle);
	DSRESULT GetCellTextStyle(long  Row, long  Column, dsString*  TextStyle);
	DSRESULT SetCellTextStyle(long  Row, long  Column, const dsString&  TextStyle);
	DSRESULT get_PrintStyle(dsString*  Val);
	DSRESULT put_PrintStyle(const dsString&  NewVal);
	DSRESULT get_Transparency(dsTransparency_c ** Val);
	DSRESULT put_Transparency(dsTransparency_c * NewVal);
};
