//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsTextStyleManager_c.h, C++ API dsTextStyleManager_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTextStyleManager_p;
class dsTextStyle_c;
class dsTextStyleManager;
class DSINTERFACE_EXPORT dsTextStyleManager_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsTextStyleManager)
public:
	DSRESULT IsSame(dsTextStyleManager_c* dsObj);

	DSRESULT CreateTextStyle(const dsString&  Name, dsTextStyle_c ** TextStyle, dsCreateObjectResult_e* Result);
	DSRESULT GetTextStyle(const dsString&  Name, dsTextStyle_c ** TextStyle);
	DSRESULT GetTextStyles(dsObjectPtrArray * TextStyleArray);
	DSRESULT RemoveTextStyle(const dsString&  Name, bool * Result);
	DSRESULT GetActiveTextStyle(dsTextStyle_c ** TextStyle);
};
