//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2012 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsTextStyle_c.h, C++ API dsTextStyle_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"
#include "dsString.h"

class dsTextStyle_p;
class dsTextStyle;
class dsCustomData_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsTextStyle_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsTextStyle)
public:
	DSRESULT IsSame(dsTextStyle_c* dsObj);

	DSRESULT get_Name(dsString*  Val);
	DSRESULT Rename(const dsString&  Name, dsCreateObjectResult_e* Result);
	DSRESULT Activate( );
	DSRESULT get_Angle(double * Val);
	DSRESULT put_Angle(double  NewVal);
	DSRESULT get_Height(double * Val);
	DSRESULT put_Height(double  NewVal);
	DSRESULT get_Spacing(double * Val);
	DSRESULT put_Spacing(double  NewVal);
	DSRESULT get_Backwards(bool * Val);
	DSRESULT put_Backwards(bool  NewVal);
	DSRESULT get_UpsideDown(bool * Val);
	DSRESULT put_UpsideDown(bool  NewVal);
	DSRESULT get_Vertical(bool * Val);
	DSRESULT put_Vertical(bool  NewVal);
	DSRESULT get_Font(dsString*  Val);
	DSRESULT put_Font(const dsString&  NewVal);
	DSRESULT get_BigFont(dsString*  Val);
	DSRESULT put_BigFont(const dsString&  NewVal);
	DSRESULT get_TextStyleFontType(dsTextStyleFontType_e* Val);
	DSRESULT GetFontParameters(dsString*  Typeface, bool * Bold, bool * Italic, long * Charset, long * PitchAndFamily);
	DSRESULT SetFontParameters(const dsString&  Typeface, bool  Bold, bool  Italic, long  Charset, long  PitchAndFamily);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
};
