//========================================================================//
//         SOURCE CODE LICENSE                                            //
//  Copyright 2011 Dassault Systmes SolidWorks Corporation               //
//  All rights reserved.                                                  //
//  This software and related documentation are proprietary to            // 
//  Dassault Systmes SolidWorks Corporation                              //
//========================================================================//
// dsXRecord_c.h, C++ API dsXRecord_c interface
//

#pragma once

#include "dsinterface_global.h"
#include "dsInterfaceDefs.h"
#include "dsConstants.h"
#include "dsObject.h"

class dsXRecord_p;
class dsXRecord;
class dsMathPoint_c;
class dsCustomData_c;
class dsDictionary_c;
class DSINTERFACE_EXPORT dsXRecord_c : public dsObject
{
	DECLARE_DSCPP_INTERFACE(dsXRecord)
public:
	DSRESULT IsSame(dsXRecord_c* dsObj);

	DSRESULT Delete(long  Index);
	DSRESULT Empty( );
	DSRESULT GetDataCount(long * Count);
	DSRESULT GetDataMarker(long  Index, long * Marker);
	DSRESULT GetDataType(long  Index, dsCustomDataType_e*  DataType);
	DSRESULT GetByteData(long  Index, dsByteArray* ByteArray);
	DSRESULT GetDoubleData(long  Index, double * Value);
	DSRESULT GetHandleData(long  Index, dsString* Handle);
	DSRESULT GetInteger8Data(long  Index, long * Value);
	DSRESULT GetInteger16Data(long  Index, long * Value);
	DSRESULT GetInteger32Data(long  Index, long * Value);
	DSRESULT GetInteger64Data(long  Index, long long* Value);
	DSRESULT GetPointData(long  Index, dsMathPoint_c ** Point);
	DSRESULT GetStringData(long  Index, dsString* Value);
	DSRESULT InsertByteData(long  Index, long  Marker, const dsByteArray&  ByteArray);
	DSRESULT InsertDoubleData(long  Index, long  Marker, double  Value);
	DSRESULT InsertHandle(long  Index, long  Marker, const dsString&  Handle);
	DSRESULT InsertInteger8Data(long  Index, long  Marker, long  Value);
	DSRESULT InsertInteger16Data(long  Index, long  Marker, long  Value);
	DSRESULT InsertInteger32Data(long  Index, long  Marker, long  Value);
	DSRESULT InsertPointData(long  Index, long  Marker, dsMathPoint_c * Point);
	DSRESULT InsertStringData(long  Index, long  Marker, const dsString&  Value);
	DSRESULT SetByteData(long  Index, const dsByteArray&  ByteArray);
	DSRESULT SetDoubleData(long  Index, double  Value);
	DSRESULT SetHandle(long  Index, const dsString&  Handle);
	DSRESULT SetInteger8Data(long  Index, long  Value);
	DSRESULT SetInteger16Data(long  Index, long  Value);
	DSRESULT SetInteger32Data(long  Index, long  Value);
	DSRESULT SetPointData(long  Index, dsMathPoint_c * Point);
	DSRESULT SetStringData(long  Index, const dsString&  Value);
	DSRESULT GetCustomData(const dsString&  ApplicationName, dsCustomData_c ** CustomData);
	DSRESULT SetCustomData(const dsString&  ApplicationName, dsCustomData_c * CustomData);
	DSRESULT DeleteCustomData(const dsString&  ApplicationName);
	DSRESULT CreateExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT GetExtensionDictionary(dsDictionary_c ** Dictionary);
	DSRESULT ReleaseExtensionDictionary(bool * Result);
	DSRESULT InsertInteger64Data(long  Index, long  Marker, long  long Value);
	DSRESULT SetInteger64Data(long  Index, long long Value);
	DSRESULT get_Handle(dsString*  Val);
	DSRESULT get_Erased(bool * Val);
	DSRESULT put_Erased(bool  NewVal);
};
