#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Test for python 3.x
if ("unicode" not in dir(__builtins__)):
  print("ERROR: This application is written for python2, please use that instead")
  quit()

# Imports (Global)
import dbus, os, signal, sys
from PyQt4.QtCore import QLocale, QTranslator
from PyQt4.QtGui import QApplication, QMessageBox

# Imports (Custom)
from w_festige import FeSTigeMainW, DBus
import jacklib

lang_path = os.path.join(sys.path[0].replace("src",""), "lang")

#--------------- main ------------------
if __name__ == '__main__':

    # App initialization
    app = QApplication(sys.argv)
    app.setApplicationName("FeSTige")
    app.setOrganizationName("falkTX")

    # Translations
    locale = QLocale.system().name()
    appTranslator = QTranslator()
    if appTranslator.load(locale, lang_path):
      app.installTranslator(appTranslator)

    # Check for JACK
    jack_client = jacklib.client_open("festige", jacklib.NullOption, 0)

    if not jack_client:
      QMessageBox.critical(None, app.translate("FeSTigeMainW", "Error"), app.translate("FeSTigeMainW", "JACK is not started!\n"
                                  "Please start it first, then run FeSTige again"))
      sys.exit(1)

    # Do not close on SIGUSR1
    signal.signal(signal.SIGUSR1, signal.SIG_IGN)

    # Connect to DBus
    DBus.loopBus = dbus.SessionBus()

    if ("org.ladish" in DBus.loopBus.list_names()):
      DBus.controlBus = DBus.loopBus.get_object("org.ladish", "/org/ladish/Control")
      DBus.studioBus = DBus.loopBus.get_object("org.ladish", "/org/ladish/Studio")
      DBus.roomBus = None
      DBus.appBus = dbus.Interface(DBus.studioBus, 'org.ladish.AppSupervisor')
    else:
      DBus.controlBus = None
      DBus.studioBus = None
      DBus.roomBus = None
      DBus.appBus = None

    # Show GUI
    gui = FeSTigeMainW(app)
    gui.show()

    # App-Loop
    ret = gui.systray.exec_(app)
    
    # Close JACK
    if (jack_client):
      jacklib.client_close(jack_client)

    # Exit
    sys.exit(ret)
