// SPDX-License-Identifier: LGPL-2.1-or-later
/*
 * Copyright (C) 2009-2013 Cyril Hrubis <metan@ucw.cz>
 */

/**
 * @file gp_byte_order.h
 * @brief A byte order (endians) defintions.
 */

#ifndef CORE_GP_BYTE_ORDER_H
#define CORE_GP_BYTE_ORDER_H

/*
 * To get macros as __BYTE_ORDER __BIG_ENDIAN and __LITTLE_ENDIAN
 */
#ifdef __linux__
# include <endian.h>
#else /* BSD Family */
# include <machine/endian.h>
# define __BYTE_ORDER _BYTE_ORDER
# define __BIG_ENDIAN _BIG_ENDIAN
# define __LITTLE_ENDIAN _LITTLE_ENDIAN
#endif

#endif /* CORE_GP_BYTE_ORDER_H */
