// SPDX-License-Identifier: LGPL-2.1-or-later
/*
 * Copyright (C) 2023 Cyril Hrubis <metan@ucw.cz>
 */

#ifndef GP_DISPLAY_UC8179_LUTS_H
#define GP_DISPLAY_UC8179_LUTS_H

#include "gp_display_uc8179.h"

#define GP_UC81XX_LUT_SIZE 60

struct gp_uc81xx_lut {
	uint8_t lut_c[GP_UC81XX_LUT_SIZE];
	uint8_t lut_ww[GP_UC81XX_LUT_SIZE];
	uint8_t lut_kw[GP_UC81XX_LUT_SIZE];
	uint8_t lut_wk[GP_UC81XX_LUT_SIZE];
	uint8_t lut_kk[GP_UC81XX_LUT_SIZE];
	uint8_t lut_bd[GP_UC81XX_LUT_SIZE];
};

/* Fast full refresh LUT for uc8179 BW mode */
static const struct gp_uc81xx_lut gp_uc8179_bw_lut_full = {
	.lut_c = {
		0x00,0x0f,0x0f,0x00,0x00,0x01,
		0x00,0x07,0x01,0x07,0x01,0x02,
		0x00,0x0f,0x0f,0x00,0x00,0x01,
	},
	.lut_ww = {
	},
	.lut_kw = {
		0x40,0x0f,0x0f,0x00,0x00,0x01,
		0x84,0x07,0x01,0x07,0x01,0x02,
		0x80,0x0f,0x0f,0x00,0x00,0x01,
	},
	.lut_wk = {
		0x20,0x0f,0x0f,0x00,0x00,0x01,
		0x84,0x07,0x01,0x07,0x01,0x02,
		0x10,0x0f,0x0f,0x00,0x00,0x01,
	},
	.lut_kk = {
	},
	/** Border LUT -- unused */
	.lut_bd = {
	}
};

/* Fast partial refresh LUT for uc8179 BW mode */
static const struct gp_uc81xx_lut gp_uc8179_bw_lut_part = {
	.lut_c = {
	//	0x00,0x0f,0x0f,0x00,0x00,0x01,
		0x00,0x0f,0x0f,0x00,0x00,0x01,
	},
	.lut_ww = {
	},
	.lut_kw = {
	//	0x40,0x0f,0x0f,0x00,0x00,0x01,
		0x80,0x0f,0x0f,0x00,0x00,0x01,
	},
	.lut_wk = {
	//	0x20,0x0f,0x0f,0x00,0x00,0x01,
		0x10,0x0f,0x0f,0x00,0x00,0x01,
	},
	.lut_kk = {
	},
	/** Border LUT -- unused */
	.lut_bd = {
	}
};

static void uc8179_write_lut(struct gp_display_spi *disp, const struct gp_uc81xx_lut *lut)
{
	gp_display_spi_cmd(disp, UC8179_LUTC);
	gp_display_spi_data_write(disp, lut->lut_c, sizeof(lut->lut_c));

	gp_display_spi_cmd(disp, UC8179_LUTWW);
	gp_display_spi_data_write(disp, lut->lut_ww, sizeof(lut->lut_ww));

	gp_display_spi_cmd(disp, UC8179_LUTKW);
	gp_display_spi_data_write(disp, lut->lut_kw, sizeof(lut->lut_kw));

	gp_display_spi_cmd(disp, UC8179_LUTWK);
	gp_display_spi_data_write(disp, lut->lut_wk, sizeof(lut->lut_wk));

	gp_display_spi_cmd(disp, UC8179_LUTKK);
	gp_display_spi_data_write(disp, lut->lut_kk, sizeof(lut->lut_kk));

	gp_display_spi_cmd(disp, UC8179_LUTBD);
	gp_display_spi_data_write(disp, lut->lut_bd, sizeof(lut->lut_bd));
}

#endif /* GP_DISPLAY_UC8179_LUTS_H */
