@ # array of [tag name, id, type, num components, comment]
@ exif = [
@        ['Interop Version', 0x0002, 'Undefined', 4, 'Stored in interop IFD'],
@        ['Image Width', 0x0100, 'Unsigned Short', 1],
@        ['Image Height', 0x0100, 'Unsigned Short', 1],
@        ['Bits Per Sample', 0x0102, 'Unsigned Short', 3],
@        ['Compression', , 'Unsigned Short', 1],
@        ['Photometric Interpretation', , 'Unsigned Short', 1],
@        ['Image Description', , 'ASCII String', 0],
@        ['Make', , 'ASCII String', 0],
@        ['Model', , 'ASCII String', 0],
@        ['Orientation', , 'Unsigned Short', 1],
@        ['Samples Per Pixel', , 'Unsigned Short', 1],
@        ['X Resolution', , 'Unsigned Rational', 1],
@        ['Y Resolution', , 'Unsinged Rational', 1],
@        ['Planar Configuration', , 'Unsigned Short', 1],
@        ['Resolution Unit', , 'Unsigned Short', 1],
@        ["Software", IFD_ASCII_STRING, 0},
	{IFD_DATE_TIME, "Date Time", IFD_ASCII_STRING, 20},
	{IFD_ARTIST, "Artist", IFD_ASCII_STRING, 0},
	{IFD_WHITE_POINT, "White Point", IFD_UNSIGNED_RATIONAL, 2},
	{IFD_PRIMARY_CHROMATICIES, "Primary Chromaticies", IFD_UNSIGNED_RATIONAL, 6},
	{IFD_Y_CB_CR_COEFFICIENTS, "YCbCr Conefficients", IFD_UNSIGNED_RATIONAL, 3},
	{IFD_Y_CB_CR_POSITIONING, "YCbCr Positioning", IFD_UNSIGNED_SHORT, 1},
	{IFD_REFERENCE_BLACK_WHITE, "Reference Black White", IFD_UNSIGNED_RATIONAL, 6},

	/* Stored in interop IFD */
	{IFD_RELATED_IMAGE_WIDTH, "Related Image Width", IFD_UNSIGNED_LONG, 1},
	{IFD_RELATED_IMAGE_HEIGHT, "Related Image Height", IFD_UNSIGNED_LONG, 1},

	{IFD_COPYRIGHT, "Copyright", IFD_ASCII_STRING, 0},

	/* TAGs from Exif SubIFD */
	{IFD_EXPOSURE_TIME, "Exposure Time", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_F_NUMBER, "F-Number", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_EXIF_OFFSET, "Exif Offset", IFD_UNSIGNED_LONG, 1},
	{IFD_EXPOSURE_PROGRAM, "Exposure Program", IFD_UNSIGNED_SHORT, 1},
	{IFD_GPS_OFFSET, "GPS Offset", IFD_UNSIGNED_LONG, 1},
	{IFD_ISO_SPEED_RATINGS, "ISO Speed Ratings", IFD_UNSIGNED_SHORT, 1},
	{IFD_EXIF_VERSION, "Exif Version", IFD_UNDEFINED, 4},
	{IFD_DATE_TIME_ORIGINAL, "Date Time Original", IFD_ASCII_STRING, 20},
	{IFD_DATE_TIME_DIGITIZED, "Date Time Digitized", IFD_ASCII_STRING, 20},
	{IFD_COMPONENT_CONFIGURATION, "Component Configuration", IFD_UNDEFINED, 0},
	{IFD_COMPRESSED_BITS_PER_PIXEL, "Compressed Bits Per Pixel", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_SHUTTER_SPEED_VALUE, "Shutter Speed", IFD_SIGNED_RATIONAL, 1},
	{IFD_APERTURE_VALUE, "Aperture", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_BRIGHTNESS_VALUE, "Brightness", IFD_SIGNED_RATIONAL, 1},
	{IFD_EXPOSURE_BIAS_VALUE, "Exposure Bias", IFD_SIGNED_RATIONAL, 1},
	{IFD_MAX_APERTURE_VALUE, "Max Aperture", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_SUBJECT_DISTANCE, "Subject Distance", IFD_SIGNED_RATIONAL, 1},
	{IFD_METERING_MODE, "Metering Mode", IFD_UNSIGNED_SHORT, 1},
	{IFD_LIGHT_SOURCE, "Light Source", IFD_UNSIGNED_SHORT, 1},
	{IFD_FLASH, "Flash", IFD_UNSIGNED_SHORT, 1},
	{IFD_FOCAL_LENGTH, "Focal Length", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_MAKER_NOTE, "Maker Note", IFD_UNDEFINED, 0},
	{IFD_USER_COMMENT, "User Comment", IFD_UNDEFINED, 0},
	{IFD_SUBSEC_TIME, "Subsec Time", IFD_ASCII_STRING, 0},
	{IFD_SUBSEC_TIME_ORIGINAL, "Subsec Time Original", IFD_ASCII_STRING, 0},
	{IFD_SUBSEC_TIME_DIGITIZED, "Subsec Time Digitized", IFD_ASCII_STRING, 0},
	{IFD_FLASH_PIX_VERSION, "Flash Pix Version", IFD_UNDEFINED, 4},
	{IFD_COLOR_SPACE, "Color Space", IFD_UNSIGNED_SHORT, 1},
	/* these two may be short in some cases */
	{IFD_EXIF_IMAGE_WIDTH, "Exif Image Width", IFD_UNSIGNED_LONG, 1},
	{IFD_EXIF_IMAGE_HEIGHT, "Exif Image Height", IFD_UNSIGNED_LONG, 1},
	{IFD_RELATED_SOUND_FILE, "Related Soundfile", IFD_ASCII_STRING, 0},
	{IFD_INTEROPERABILITY_OFFSET, "Interoperability Offset", IFD_UNSIGNED_LONG, 1},
	{IFD_FOCAL_PLANE_X_RESOLUTION, "Focal Plane X Resolution", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_FOCAL_PLANE_Y_RESOLUTION, "Focal Plane Y Resolution", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_FOCAL_PLANE_RESOLUTION_UNIT, "Focal Plane Resolution Unit", IFD_UNSIGNED_SHORT, 1},
	{IFD_SENSING_METHOD, "Sensing Method", IFD_UNSIGNED_SHORT, 1},
	{IFD_FILE_SOURCE, "File Source", IFD_UNDEFINED, 1},
	{IFD_SCENE_TYPE, "Scene Type", IFD_UNDEFINED, 1},
	{IFD_CFA_PATTERN, "CFA Pattern", IFD_UNDEFINED, 0},
	{IFD_CUSTOM_RENDERER, "Custom Renderer", IFD_UNSIGNED_SHORT, 1},
	{IFD_EXPOSURE_MODE, "Exposure Mode", IFD_UNSIGNED_SHORT, 1},
	{IFD_WHITE_BALANCE, "White Balance", IFD_UNSIGNED_SHORT, 1},
	{IFD_DIGITAL_ZOOM_RATIO, "Digital Zoom Ratio", IFD_UNSIGNED_RATIONAL, 1},
	{IFD_FOCAL_LENGTH_IN_35_MM_FILM, "Focal Lenght In 35mm Film", IFD_UNSIGNED_SHORT, 1},
	{IFD_SCENE_CAPTURE_TYPE, "Scene Capture Type", IFD_UNSIGNED_SHORT, 1},
	{IFD_GAIN_CONTROL, "Gain Control", IFD_UNSIGNED_SHORT, 1},
	{IFD_CONTRAST, "Contrast", IFD_UNSIGNED_SHORT, 1},
	{IFD_SATURATION, "Saturation", IFD_UNSIGNED_SHORT, 1},
	{IFD_SHARPNESS, "Sharpness", IFD_UNSIGNED_SHORT, 1},
	{IFD_SUBJECT_DISTANCE_RANGE, "Subject Distance Range", IFD_UNSIGNED_SHORT, 1},
	{IFD_IMAGE_UNIQUE_ID, "Image Unique ID", IFD_ASCII_STRING, 33},
	{IFD_CAMERA_OWNER_NAME, "Camera Owner Name", IFD_ASCII_STRING, 0},
	{IFD_BODY_SERIAL_NUMBER, "Body Serial Number", IFD_ASCII_STRING, 0},
	{IFD_LENS_SPECIFICATION, "Lens Specification", IFD_UNSIGNED_RATIONAL, 4},
	{IFD_LENS_MODEL, "Lens Model", IFD_ASCII_STRING, 0},
	{IFD_LENS_SERIAL_NUMBER, "Lens Serial Number", IFD_ASCII_STRING, 0},

	{IFD_PRINT_IM, "Print IM", IFD_UNDEFINED, 0},
	{IFD_PADDING, "Padding", IFD_UNDEFINED, 0},
	{IFD_OFFSET_SCHEMA, "Offset Schema", IFD_SIGNED_LONG, 1},
@        ]
@
@ def exif_tag_name(exif):
@     return 'IFD_' + exif[0].upper().replace(' ', '_')
@
@ def exif_tag_type(exif):
@     return 'IFD_' + exif[2].upper().replace(' ', '_')
