//SPDX-License-Identifier: LGPL-2.0-or-later

/*

   Copyright (c) 2014-2023 Cyril Hrubis <metan@ucw.cz>

 */

#ifndef GP_WIDGETS_H
#define GP_WIDGETS_H

#include <utils/gp_htable.h>
#include <utils/gp_json.h>

#include <widgets/gp_widget_keys.h>

#include <widgets/gp_widget_ops.h>
#include <widgets/gp_widget_style.h>
#include <widgets/gp_widget.h>
#include <widgets/gp_widget_render.h>
#include <widgets/gp_widget_gfx.h>
#include <widgets/gp_widget_grid.h>
#include <widgets/gp_widget_hvbox.h>
#include <widgets/gp_widget_tabs.h>
#include <widgets/gp_widget_button.h>
#include <widgets/gp_widget_label.h>
#include <widgets/gp_widget_class_int.h>
#include <widgets/gp_widget_slider.h>
#include <widgets/gp_widget_spinner.h>
#include <widgets/gp_widget_tbox.h>
#include <widgets/gp_widget_tbox.h>

/* Bool widget and subclasses */
#include <widgets/gp_widget_class_bool.h>
#include <widgets/gp_widget_checkbox.h>
#include <widgets/gp_widget_switch.h>
#include <widgets/gp_widget_stock_switch.h>

/* Choice widget and subclasses */
#include <widgets/gp_widget_class_choice.h>
#include <widgets/gp_widget_radiobutton.h>
#include <widgets/gp_widget_spinbutton.h>

#include <widgets/gp_widget_table.h>
#include <widgets/gp_widget_pbar.h>
#include <widgets/gp_widget_pixmap.h>
#include <widgets/gp_widget_scroll_area.h>
#include <widgets/gp_widget_frame.h>
#include <widgets/gp_widget_markup.h>
#include <widgets/gp_widget_layout_switch.h>
#include <widgets/gp_widget_overlay.h>
#include <widgets/gp_widget_log.h>
#include <widgets/gp_widget_graph.h>

#include <widgets/gp_app_layout.h>
#include <widgets/gp_app_event.h>
#include <widgets/gp_app_info.h>
#include <widgets/gp_app_timer.h>
#include <widgets/gp_app_poll.h>
#include <widgets/gp_app_task.h>

#include <widgets/gp_widget_tattr.h>
#include <widgets/gp_widget_size_units.h>

#include <widgets/gp_widget_json.h>
#include <widgets/gp_widget_uid.h>
#include <widgets/gp_file_size.h>

#include <widgets/gp_widget_stock.h>

/* Dialogs */
#include <widgets/gp_dialog.h>
#include <widgets/gp_dialog_msg.h>
#include <widgets/gp_dialog_input.h>
#include <widgets/gp_dialog_file.h>

#endif /* GP_WIDGETS_H */
