//SPDX-License-Identifier: GPL-2.1-or-later
/*
 * Copyright (C) 2025 Cyril Hrubis <metan@ucw.cz>
 */

#ifndef XTERM_256_PALETTE
#define XTERM_256_PALETTE

struct RGB {
	uint8_t r;
	uint8_t g;
	uint8_t b;
};

struct RGB RGB_colors[256] = {
	/* BLACK */
	{0x00, 0x00, 0x00},
	/* RED */
	{0xcd, 0x00, 0x00},
	/* GREEN */
	{0x00, 0xcd, 0x00},
	/* YELLOW */
	{0xcd, 0xcd, 0x00},
	/* BLUE */
	{0x00, 0x00, 0xee},
	/* MAGENTA */
	{0xcd, 0x00, 0xcd},
	/* CYAN */
	{0x00, 0xcd, 0xcd},
	/* GRAY */
	{0xe5, 0xe5, 0xe5},

	/* BRIGHT BLACK */
	{0x7f, 0x7f, 0x7f},
	/* BRIGHT RED */
	{0xff, 0x00, 0x00},
	/* BRIGHT GREEN */
	{0x00, 0xff, 0x00},
	/* BRIGHT YELLOW */
	{0xff, 0xff, 0x00},
	/* BRIGHT BLUE */
	{0x5c, 0x5c, 0xff},
	/* BRIGHT MAGENTA */
	{0xff, 0x00, 0xff},
	/* BRIGHT CYAN */
	{0x00, 0xff, 0xff},
	/* WHITE */
	{0xff, 0xff, 0xff},

	/* The rest of 256 color palette */
	{0x00, 0x00, 0x00},
	{0x00, 0x00, 0x5f},
	{0x00, 0x00, 0x87},
	{0x00, 0x00, 0xaf},
	{0x00, 0x00, 0xd7},
	{0x00, 0x00, 0xff},
	{0x00, 0x5f, 0x00},
	{0x00, 0x5f, 0x5f},
	{0x00, 0x5f, 0x87},
	{0x00, 0x5f, 0xaf},
	{0x00, 0x5f, 0xd7},
	{0x00, 0x5f, 0xff},
	{0x00, 0x87, 0x00},
	{0x00, 0x87, 0x5f},
	{0x00, 0x87, 0x87},
	{0x00, 0x87, 0xaf},
	{0x00, 0x87, 0xd7},
	{0x00, 0x87, 0xff},
	{0x00, 0xaf, 0x00},
	{0x00, 0xaf, 0x5f},
	{0x00, 0xaf, 0x87},
	{0x00, 0xaf, 0xaf},
	{0x00, 0xaf, 0xd7},
	{0x00, 0xaf, 0xff},
	{0x00, 0xd7, 0x00},
	{0x00, 0xd7, 0x5f},
	{0x00, 0xd7, 0x87},
	{0x00, 0xd7, 0xaf},
	{0x00, 0xd7, 0xd7},
	{0x00, 0xd7, 0xff},
	{0x00, 0xff, 0x00},
	{0x00, 0xff, 0x5f},
	{0x00, 0xff, 0x87},
	{0x00, 0xff, 0xaf},
	{0x00, 0xff, 0xd7},
	{0x00, 0xff, 0xff},
	{0x5f, 0x00, 0x00},
	{0x5f, 0x00, 0x5f},
	{0x5f, 0x00, 0x87},
	{0x5f, 0x00, 0xaf},
	{0x5f, 0x00, 0xd7},
	{0x5f, 0x00, 0xff},
	{0x5f, 0x5f, 0x00},
	{0x5f, 0x5f, 0x5f},
	{0x5f, 0x5f, 0x87},
	{0x5f, 0x5f, 0xaf},
	{0x5f, 0x5f, 0xd7},
	{0x5f, 0x5f, 0xff},
	{0x5f, 0x87, 0x00},
	{0x5f, 0x87, 0x5f},
	{0x5f, 0x87, 0x87},
	{0x5f, 0x87, 0xaf},
	{0x5f, 0x87, 0xd7},
	{0x5f, 0x87, 0xff},
	{0x5f, 0xaf, 0x00},
	{0x5f, 0xaf, 0x5f},
	{0x5f, 0xaf, 0x87},
	{0x5f, 0xaf, 0xaf},
	{0x5f, 0xaf, 0xd7},
	{0x5f, 0xaf, 0xff},
	{0x5f, 0xd7, 0x00},
	{0x5f, 0xd7, 0x5f},
	{0x5f, 0xd7, 0x87},
	{0x5f, 0xd7, 0xaf},
	{0x5f, 0xd7, 0xd7},
	{0x5f, 0xd7, 0xff},
	{0x5f, 0xff, 0x00},
	{0x5f, 0xff, 0x5f},
	{0x5f, 0xff, 0x87},
	{0x5f, 0xff, 0xaf},
	{0x5f, 0xff, 0xd7},
	{0x5f, 0xff, 0xff},
	{0x87, 0x00, 0x00},
	{0x87, 0x00, 0x5f},
	{0x87, 0x00, 0x87},
	{0x87, 0x00, 0xaf},
	{0x87, 0x00, 0xd7},
	{0x87, 0x00, 0xff},
	{0x87, 0x5f, 0x00},
	{0x87, 0x5f, 0x5f},
	{0x87, 0x5f, 0x87},
	{0x87, 0x5f, 0xaf},
	{0x87, 0x5f, 0xd7},
	{0x87, 0x5f, 0xff},
	{0x87, 0x87, 0x00},
	{0x87, 0x87, 0x5f},
	{0x87, 0x87, 0x87},
	{0x87, 0x87, 0xaf},
	{0x87, 0x87, 0xd7},
	{0x87, 0x87, 0xff},
	{0x87, 0xaf, 0x00},
	{0x87, 0xaf, 0x5f},
	{0x87, 0xaf, 0x87},
	{0x87, 0xaf, 0xaf},
	{0x87, 0xaf, 0xd7},
	{0x87, 0xaf, 0xff},
	{0x87, 0xd7, 0x00},
	{0x87, 0xd7, 0x5f},
	{0x87, 0xd7, 0x87},
	{0x87, 0xd7, 0xaf},
	{0x87, 0xd7, 0xd7},
	{0x87, 0xd7, 0xff},
	{0x87, 0xff, 0x00},
	{0x87, 0xff, 0x5f},
	{0x87, 0xff, 0x87},
	{0x87, 0xff, 0xaf},
	{0x87, 0xff, 0xd7},
	{0x87, 0xff, 0xff},
	{0xaf, 0x00, 0x00},
	{0xaf, 0x00, 0x5f},
	{0xaf, 0x00, 0x87},
	{0xaf, 0x00, 0xaf},
	{0xaf, 0x00, 0xd7},
	{0xaf, 0x00, 0xff},
	{0xaf, 0x5f, 0x00},
	{0xaf, 0x5f, 0x5f},
	{0xaf, 0x5f, 0x87},
	{0xaf, 0x5f, 0xaf},
	{0xaf, 0x5f, 0xd7},
	{0xaf, 0x5f, 0xff},
	{0xaf, 0x87, 0x00},
	{0xaf, 0x87, 0x5f},
	{0xaf, 0x87, 0x87},
	{0xaf, 0x87, 0xaf},
	{0xaf, 0x87, 0xd7},
	{0xaf, 0x87, 0xff},
	{0xaf, 0xaf, 0x00},
	{0xaf, 0xaf, 0x5f},
	{0xaf, 0xaf, 0x87},
	{0xaf, 0xaf, 0xaf},
	{0xaf, 0xaf, 0xd7},
	{0xaf, 0xaf, 0xff},
	{0xaf, 0xd7, 0x00},
	{0xaf, 0xd7, 0x5f},
	{0xaf, 0xd7, 0x87},
	{0xaf, 0xd7, 0xaf},
	{0xaf, 0xd7, 0xd7},
	{0xaf, 0xd7, 0xff},
	{0xaf, 0xff, 0x00},
	{0xaf, 0xff, 0x5f},
	{0xaf, 0xff, 0x87},
	{0xaf, 0xff, 0xaf},
	{0xaf, 0xff, 0xd7},
	{0xaf, 0xff, 0xff},
	{0xd7, 0x00, 0x00},
	{0xd7, 0x00, 0x5f},
	{0xd7, 0x00, 0x87},
	{0xd7, 0x00, 0xaf},
	{0xd7, 0x00, 0xd7},
	{0xd7, 0x00, 0xff},
	{0xd7, 0x5f, 0x00},
	{0xd7, 0x5f, 0x5f},
	{0xd7, 0x5f, 0x87},
	{0xd7, 0x5f, 0xaf},
	{0xd7, 0x5f, 0xd7},
	{0xd7, 0x5f, 0xff},
	{0xd7, 0x87, 0x00},
	{0xd7, 0x87, 0x5f},
	{0xd7, 0x87, 0x87},
	{0xd7, 0x87, 0xaf},
	{0xd7, 0x87, 0xd7},
	{0xd7, 0x87, 0xff},
	{0xd7, 0xaf, 0x00},
	{0xd7, 0xaf, 0x5f},
	{0xd7, 0xaf, 0x87},
	{0xd7, 0xaf, 0xaf},
	{0xd7, 0xaf, 0xd7},
	{0xd7, 0xaf, 0xff},
	{0xd7, 0xd7, 0x00},
	{0xd7, 0xd7, 0x5f},
	{0xd7, 0xd7, 0x87},
	{0xd7, 0xd7, 0xaf},
	{0xd7, 0xd7, 0xd7},
	{0xd7, 0xd7, 0xff},
	{0xd7, 0xff, 0x00},
	{0xd7, 0xff, 0x5f},
	{0xd7, 0xff, 0x87},
	{0xd7, 0xff, 0xaf},
	{0xd7, 0xff, 0xd7},
	{0xd7, 0xff, 0xff},
	{0xff, 0x00, 0x00},
	{0xff, 0x00, 0x5f},
	{0xff, 0x00, 0x87},
	{0xff, 0x00, 0xaf},
	{0xff, 0x00, 0xd7},
	{0xff, 0x00, 0xff},
	{0xff, 0x5f, 0x00},
	{0xff, 0x5f, 0x5f},
	{0xff, 0x5f, 0x87},
	{0xff, 0x5f, 0xaf},
	{0xff, 0x5f, 0xd7},
	{0xff, 0x5f, 0xff},
	{0xff, 0x87, 0x00},
	{0xff, 0x87, 0x5f},
	{0xff, 0x87, 0x87},
	{0xff, 0x87, 0xaf},
	{0xff, 0x87, 0xd7},
	{0xff, 0x87, 0xff},
	{0xff, 0xaf, 0x00},
	{0xff, 0xaf, 0x5f},
	{0xff, 0xaf, 0x87},
	{0xff, 0xaf, 0xaf},
	{0xff, 0xaf, 0xd7},
	{0xff, 0xaf, 0xff},
	{0xff, 0xd7, 0x00},
	{0xff, 0xd7, 0x5f},
	{0xff, 0xd7, 0x87},
	{0xff, 0xd7, 0xaf},
	{0xff, 0xd7, 0xd7},
	{0xff, 0xd7, 0xff},
	{0xff, 0xff, 0x00},
	{0xff, 0xff, 0x5f},
	{0xff, 0xff, 0x87},
	{0xff, 0xff, 0xaf},
	{0xff, 0xff, 0xd7},
	{0xff, 0xff, 0xff},
	{0x08, 0x08, 0x08},
	{0x12, 0x12, 0x12},
	{0x1c, 0x1c, 0x1c},
	{0x26, 0x26, 0x26},
	{0x30, 0x30, 0x30},
	{0x3a, 0x3a, 0x3a},
	{0x44, 0x44, 0x44},
	{0x4e, 0x4e, 0x4e},
	{0x58, 0x58, 0x58},
	{0x60, 0x60, 0x60},
	{0x66, 0x66, 0x66},
	{0x76, 0x76, 0x76},
	{0x80, 0x80, 0x80},
	{0x8a, 0x8a, 0x8a},
	{0x94, 0x94, 0x94},
	{0x9e, 0x9e, 0x9e},
	{0xa8, 0xa8, 0xa8},
	{0xb2, 0xb2, 0xb2},
	{0xbc, 0xbc, 0xbc},
	{0xc6, 0xc6, 0xc6},
	{0xd0, 0xd0, 0xd0},
	{0xda, 0xda, 0xda},
	{0xe4, 0xe4, 0xe4},
	{0xee, 0xee, 0xee},
};

#endif /* XTERM_256_PALETTE */
