// SPDX-License-Identifier: LGPL-2.1-or-later
/*
 * Copyright (C) 2009-2010 Jiri "BlueBear" Dluhos
 *                         <jiri.bluebear.dluhos@gmail.com>
 *
 * Copyright (C) 2009-2023 Cyril Hrubis <metan@ucw.cz>
 */

/**
 * @defgroup gfx Graphics algorithms
 * @brief A graphic drawing algorithms.
 */

#ifndef GP_GFX_H
#define GP_GFX_H

/* basic definitions and structures */
#include <core/gp_pixmap.h>
#include <core/gp_get_put_pixel.h>
#include <core/gp_write_pixels.gen.h>
#include <core/gp_fill.h>

/* public drawing API */
#include <gfx/gp_hline.h>
#include <gfx/gp_vline.h>
#include <gfx/gp_line.h>
#include <gfx/gp_rect.h>
#include <gfx/gp_triangle.h>
#include <gfx/gp_tetragon.h>
#include <gfx/gp_circle.h>
#include <gfx/gp_circle_seg.h>
#include <gfx/gp_ellipse.h>
#include <gfx/gp_arc.h>
#include <gfx/gp_polygon.h>
#include <gfx/gp_symbol.h>

#endif /* GP_GFX_H */
