# A tiling window manager for GFXprim proxy backend

NekoWM is a simple compositor and tiling window manager written on the top of
the GFXprim proxy backend.

A [gfxprim backend](http://gfxprim.ucw.cz/api-docs/html/gp__backend_8h.html)
is an abstraction for a screen or a (e-ink or LCD) display to render to and
also for input devices e.g. keyboard, mouse, touchscreen, etc. There are
different backends implemented in GFXprim ranging from X11 and Wayland, where
applications run inside of a window, to a Linux DRM or a Framebuffer together
with linux input layer where application runs on a whole display, all the way
down to a small SPI e-ink or LCD displays connected to a small embedded Linux
computer.

A proxy backend sits between applications and another backend (e.g. Linux DRM)
and is multiplexing access to the screen and input devices.
GFXprim proxy backend consists of a
[simple protocol](http://gfxprim.ucw.cz/api-docs/html/gp__proxy__proto_8h.html) for events
and a [SHM buffer](http://gfxprim.ucw.cz/api-docs/html/gp__proxy__shm_8h.html) for an
application to render to. NekoWM uses proxy backend
[client library](http://gfxprim.ucw.cz/api-docs/html/gp__proxy__cli_8h.html)
build on the top of the simple protocol to talk to the applications so that it can switch
between which of them are shown on the screen and which receives input events.

![nekowm](nekowm-color.png)

## Animation

![nekowm-screenshots](nekowm-screenshots.png)

See autogenerated source code documentation at https://gfxprim.github.io/nekowm/files.html

## How to setup NekoWM

[NekoWM setup](SETUP.md)
