//SPDX-License-Identifier: GPL-2.0-or-later
/*

   Copyright (c) 2019-2025 Cyril Hrubis <metan@ucw.cz>

 */

/**
 * @brief View is an abstraction for a piece of a screen.
 * @file neko_view.h
 */
#ifndef NEKO_LOGO_H
#define NEKO_LOGO_H

#include <core/gp_core.h>
#include <stdint.h>

struct neko_logo {
	uint32_t w;
	uint32_t h;
	uint8_t data[];
};

/**
 * @brief Paletted cat logo outline.
 *
 * Colors:
 *
 * 0 - bacground
 * 1 - outline
 * 2 - fur
 * 3 - dark fur
 * 4 - eye
 */
static inline struct neko_logo neko_logo_cat = {
	.w = 18,
	.h = 17,
	.data = {
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0,
		0, 1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 0,
		0, 1, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 3, 1, 0,
		0, 1, 2, 1, 3, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 0,
		0, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 1, 3, 1, 0,
		0, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 0,
		0, 1, 2, 2, 2, 2, 2, 3, 1, 2, 2, 2, 2, 2, 2, 2, 1, 0,
		0, 1, 2, 2, 2, 2, 2, 3, 1, 3, 2, 2, 2, 2, 2, 2, 1, 0,
		1, 3, 3, 2, 2, 2, 2, 2, 2, 1, 3, 2, 2, 2, 2, 1, 2, 1,
		1, 3, 3, 2, 2, 4, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1,
		1, 3, 2, 2, 2, 4, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1,
		0, 1, 2, 2, 2, 4, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 0,
		1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 3, 1, 1,
		0, 0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 0, 0,
		0, 1, 0, 0, 1, 3, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0,
	}
};

/**
 * @brief Paletted cat logo with nekowm text.
 *
 * Colors:
 *
 * 0 - bacground
 * 1 - outline
 * 2 - fur
 * 3 - dark fur
 * 4 - eye
 */
static inline struct neko_logo neko_logo_text = {
	.w = 28,
	.h = 28,
	.data = {
		0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 3, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 2, 1, 3, 2, 1, 1, 1, 1, 1, 1, 2, 2, 1, 2, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 1, 3, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 3, 1, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 3, 1, 3, 2, 2, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 3, 3, 2, 2, 2, 2, 2, 2, 1, 3, 2, 2, 2, 2, 1, 2, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 3, 3, 2, 2, 4, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 2, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 3, 2, 2, 2, 4, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 2, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 2, 2, 2, 4, 2, 2, 2, 2, 2, 1, 1, 1, 2, 2, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2, 1, 1, 2, 2, 2, 2, 2, 3, 1, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 3, 2, 2, 2, 2, 2, 2, 2, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		4, 4, 4, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0,
		4, 4, 4, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0,
		4, 0, 0, 4, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
		4, 0, 0, 4, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
		4, 0, 0, 4, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1,
		4, 0, 0, 4, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1,
	}
};

void neko_logo_render(gp_pixmap *pixmap, struct neko_logo *logo, gp_size y_off);

#endif /* NEKO_LOGO_H */
