See <https://cr.yp.to/qmail/faq.html> for newer FAQs not included in this
document, and <http://qmail.org/> for qmail community contributions.

1. Controlling the appearance of outgoing messages  
1.1. How do I set up host masquerading?  
1.2. How do I set up user masquerading?  
1.3. How do I set up Mail-Followup-To automatically?  

2. Routing outgoing messages  
2.1. How do I send local messages to another host?  
2.2. How do I set up a null client?  
2.3. How do I send outgoing mail through UUCP?  
2.4. How do I set up a separate queue for a SLIP/PPP link?  

3. Routing incoming messages by host  
3.1. How do I receive mail for another host name?  
3.2. How do I set up a virtual domain?  
3.3. How do I set up several virtual domains for one user?  

4. Routing incoming messages by user  
4.1. How do I forward unrecognized usernames to another host?  
4.2. How do I set up a mailing list?  
4.3. How do I use majordomo with qmail?  
4.4. How do I use procmail with qmail?  
4.5. How do I use elm's filter with qmail?  
4.6. How do I create aliases with dots?  
4.7. How do I use sendmail's .forward files with qmail?  
4.8. How do I use sendmail's /etc/aliases with qmail?  
4.9. How do I make qmail defer messages during NFS or NIS outages?  
4.10. How do I change which account controls an address?  

5. Setting up servers  
5.1. How do I run qmail-smtpd under tcpserver?  
5.2. How do I set up qmail-qmtpd?  
5.3. How do I set up qmail-pop3d?  
5.4. How do I allow selected clients to use this host as a relay?  
5.5. How do I fix up messages from broken SMTP clients?  
5.6. How do I set up qmail-qmqpd?  

6. Configuring MUAs to work with qmail  
6.1. How do I make BSD mail generate a Date with the local time zone?  
6.2. How do I make pine work with qmail?  
6.3. How do I make MH work with qmail?  
6.4. How do I stop Sun's dtcm from hanging?  

7. Managing the mail system  
7.1. How do I safely stop qmail-send?  
7.2. How do I manually run the queue?  
7.3. How do I rejuvenate a message?  
7.4. How do I organize a big network?  
7.5. How do I back up and restore the queue disk?  
7.6. How do I run a supervised copy of qmail?  
7.7. How do I avoid syslog?  

8. Miscellany  
8.1. How do I tell qmail to do more deliveries at once?  
8.2. How do I keep a copy of all incoming and outgoing mail messages?  
8.3. How do I switch slowly from sendmail to qmail?  



1. Controlling the appearance of outgoing messages


1.1. How do I set up host masquerading? All the users on this host,
zippy.af.mil, are users on af.mil. When joe sends a message to fred, the
message should say "From: joe@af.mil" and "To: fred@af.mil", without
"zippy" anywhere.

Answer: echo af.mil > /var/qmail/control/defaulthost; chmod 644
/var/qmail/control/defaulthost.


1.2. How do I set up user masquerading? I'd like my own From lines to
show boss@af.mil rather than god@heaven.af.mil.

Answer: Add MAILHOST=af.mil and MAILUSER=boss to your environment. To
override From lines supplied by your MUA, add QMAILINJECT=f to your
environment.


1.3. How do I set up Mail-Followup-To automatically? When I send a
message to the sos@heaven.af.mil mailing list, I'd like to include
"Mail-Followup-To: sos@heaven.af.mil".

Answer: Add QMAILMFTFILE=$HOME/.lists to your environment, and put
sos@heaven.af.mil into ~/.lists.



2. Routing outgoing messages


2.1. How do I send local messages to another host? All the mail for
af.mil should be delivered to our disk server, pokey.af.mil. I've set up
an MX from af.mil to pokey.af.mil, but when a user on the af.mil host
sends a message to boss@af.mil, af.mil tries to deliver it locally. How
do I stop that?

Answer: Remove af.mil from /var/qmail/control/locals. If qmail-send is
running, give it a HUP. Make sure the MX is set up properly before you
do this. Also make sure that pokey can receive mail for af.mil -- see
question 3.1.


2.2. How do I set up a null client? I'd like zippy.af.mil to
send all mail to bigbang.af.mil.

Answer: echo :bigbang.af.mil > /var/qmail/control/smtproutes;
chmod 644 /var/qmail/control/smtproutes. Disable local delivery as in
question 2.1. Turn off qmail-smtpd in /etc/inetd.conf.


2.3. How do I send outgoing mail through UUCP? I need qmail to send all
outgoing mail via UUCP to my upstream UUCP site, gonzo.

Answer: Put

   `:alias-uucp`

into control/virtualdomains and

   ```
   |preline -df /usr/bin/uux - -r -gC
      -a"${SENDER:-MAILER-DAEMON}" gonzo!rmail "($DEFAULT@$HOST)"
   ```

(all on one line) into ~alias/.qmail-uucp-default. (For some UUCP
software you will need to use -d instead of -df.) If qmail-send is
running, give it a HUP.


2.4. How do I set up a separate queue for a SLIP/PPP link?

Answer: Use serialmail (<https://cr.yp.to/serialmail.html>).



3. Routing incoming messages by host


3.1. How do I receive mail for another host name? I'd like our disk
server, pokey.af.mil, to receive mail addressed to af.mil. I've set up
an MX from af.mil to pokey.af.mil, but how do I get pokey to treat
af.mil as a name for the local host?

Answer: Add af.mil to /var/qmail/control/locals and to
/var/qmail/control/rcpthosts. If qmail-send is running, give it a HUP
(or do svc -h /var/run/qmail if qmail is supervised).


3.2. How do I set up a virtual domain? I'd like any mail for
nowhere.mil, including root@nowhere.mil and postmaster@nowhere.mil and
so on, to be delivered to Bob. I've set up the MX already.

Answer: Put

   `nowhere.mil:bob`

into control/virtualdomains. Add nowhere.mil to control/rcpthosts. If
qmail-send is running, give it a HUP (or do svc -h /var/run/qmail if
qmail is supervised).

Now mail for whatever@nowhere.mil will be delivered locally to
bob-whatever. Bob can set up ~bob/.qmail-default to catch all the
possible addresses, ~bob/.qmail-info to catch info@nowhere.mil, etc.


3.3. How do I set up several virtual domains for one user? Bob wants
another virtual domain, everywhere.org, but he wants to handle
nowhere.mil users and everywhere.org users differently. How can we do
that without setting up a second account?

Answer: Put two lines into control/virtualdomains:

   ```
   nowhere.mil:bob-nowhere
   everywhere.org:bob-everywhere
   ```

Add nowhere.mil and everywhere.org to control/rcpthosts. If qmail-send
is running, give it a HUP (or do svc -h /var/run/qmail if qmail is
supervised).

Now Bob can set up separate .qmail-nowhere-* and everywhere-* files. He
can even set up .qmail-nowhere-default and .qmail-everywhere-default.



4. Routing incoming messages by user


4.1. How do I forward unrecognized usernames to another host? I'd like
to set up a LUSER_RELAY pointing at bigbang.af.mil.

Answer: Put

   `| forward "$LOCAL"@bigbang.af.mil`

into ~alias/.qmail-default.


4.2. How do I set up a mailing list? I'd like me-sos@my.host.name to be
forwarded to a bunch of people.

Answer: Put a list of addresses into ~me/.qmail-sos, one per line. Then
incoming mail for me-sos will be forwarded to each of those addresses.
You should also touch ~me/.qmail-sos-owner so that bounces come back to
you rather than the original sender.

Alternative: ezmlm (<https://cr.yp.to/ezmlm.html>) is a modern
mailing list manager, supporting automatic subscriptions, confirmations,
archives, fully automatic bounce handling (including warnings to
subscribers saying which messages they've missed), and more.


4.3. How do I use majordomo with qmail?

Answer: See <ftp://ftp.eyrie.org/pub/software/majordomo/mjqmail> and
<http://www.qmail.org> for various methods. majordomo 2.0 is expected to
support qmail directly.

Beware that majordomo's lists are not crashproof.



4.4. How do I use procmail with qmail?

Answer: Put 

   `| preline procmail`

into ~/.qmail. You'll have to use a full path for procmail unless
procmail is in the system's startup PATH. Note that procmail will try to
deliver to /var/spool/mail/$USER by default; to change this, see
INSTALL.mbox.md.


4.5. How do I use elm's filter with qmail?

Answer: Put 

   `| preline filter`

into ~/.qmail. You'll have to use a full path for filter unless filter
is in the system's startup PATH.


4.6. How do I create aliases with dots? I tried setting up
~alias/.qmail-P.D.Q.Bach, but it doesn't do anything.

Answer: Use .qmail-p:d:q:bach. Dots are converted to colons, and
uppercase is converted to lowercase.


4.7. How do I use sendmail's .forward files with qmail?

Answer: Install the dot-forward package
(<https://cr.yp.to/dot-forward.html>).


4.8. How do I use sendmail's /etc/aliases with qmail?

Answer: Install the fastforward package
(<https://cr.yp.to/fastforward.html>).


To make majordomo 1.94.* work with qmail under fastforward, insert

   `# system("newinclude","$listdir/$clean_list");`

before the lclose(LIST) line in do_subscribe and do_unsubscribe in
majordomo. See <ftp://ftp.eyrie.org/pub/software/majordomo/mjqmail>
and <http://www.qmail.org> for other methods of using majordomo with
qmail. majordomo 2.0 is expected to support qmail directly.

4.9. How do I make qmail defer messages during NFS or NIS outages? If
~joe suddenly disappears, I'd like mail for joe to be deferred.

Answer: Build a qmail-users database, so that qmail no longer checks
home directories and the password database. This takes three steps.
First, put your complete user list (including local and NIS passwords)
into /var/qmail/users/passwd. Second, run

   `# qmail-pw2u -h < /var/qmail/users/passwd > /var/qmail/users/assign`

Here -h means that every user must have a home directory; if you happen
to run qmail-pw2u during an NFS outage, it will print an error message
and stop. Third, run

   `# qmail-newu`

Make sure to rebuild the database whenever you change your user list.


4.10. How do I change which account controls an address? I set up
~alias/.qmail-www, but qmail is looking at ~www/.qmail instead.

Answer: If you do

   `# chown root ~www`

then qmail will no longer consider www to be a user; see qmail-getpw.0.
For more precise control over address assignments, see qmail-users.0.



5. Setting up servers


5.1. How do I run qmail-smtpd under tcpserver? inetd is barfing at high
loads, cutting off service for ten-minute stretches. I'd also like
better connection logging.

Answer: Install ucspi-tcp (<https://cr.yp.to/ucspi-tcp.html>). Remove the
smtp line from /etc/inetd.conf, and put the two lines

   ```
   tcpserver -v -u 7770 -g 2108 0 smtp /var/qmail/bin/qmail-smtpd \
   2>&1 | /var/qmail/bin/splogger smtpd 3 &
   ```

into your system startup files. Replace 7770 with your qmaild uid, and
replace 2108 with your nofiles gid. Don't forget the &. The change will
take effect at your next reboot.

By default, tcpserver allows at most 40 simultaneous qmail-smtpd
processes. To raise this limit to 400, use tcpserver -c 400.


5.2. How do I set up qmail-qmtpd?

Answer: Two steps. First, put a

   `qmtp 209/tcp`

line into /etc/services. Second, put (all on one line)

   ```
   qmtp stream tcp nowait qmaild
   /var/qmail/bin/tcp-env tcp-env /var/qmail/bin/qmail-qmtpd
   ```

into /etc/inetd.conf, and give inetd a HUP.

If you have tcpserver installed, skip the inetd step, and set up

   `tcpserver -u 7770 -g 2108 0 qmtp /var/qmail/bin/qmail-qmtpd &`

replacing 7770 and 2108 with the qmaild uid and nofiles gid. See
question 5.1 for more details on tcpserver.


5.3. How do I set up qmail-pop3d? My old POP server works with mbox
delivery; I'd like to switch to maildir delivery.

Answer: Install ucspi-tcp (<https://cr.yp.to/ucspi-tcp.html>) and
checkpassword (<https://cr.yp.to/checkpwd.html>). Put

   ```
   tcpserver 0 110 /var/qmail/bin/qmail-popup YOURHOST \
   /bin/checkpassword /var/qmail/bin/qmail-pop3d Maildir &
   ```

(on two lines) into your system boot scripts; replace YOURHOST with your
host's fully qualified domain name. Set up Maildir delivery for any user
who wants to read mail via POP. The new service will start after you
reboot.

Security note: You should do this only within a secure network; otherwise
an eavesdropper can steal passwords.

There are several programs that can be substituted for checkpassword.
See <https://cr.yp.to/qmail/toaster.html> for more information.


5.4. How do I allow selected clients to use this host as a relay? I see
that qmail-smtpd rejects messages to any host not listed in
control/rcpthosts.

Answer: Three steps. First, install tcp-wrappers, available separately,
including hosts_options. Second, change your qmail-smtpd line in
inetd.conf to

   ```
   smtp stream tcp nowait qmaild /usr/local/bin/tcpd
   /var/qmail/bin/tcp-env /var/qmail/bin/qmail-smtpd
   ```

(all on one line) and give inetd a HUP. Third, in tcpd's hosts.allow,
make a line setting the environment variable RELAYCLIENT to the empty
string for the selected clients:

   `tcp-env: 1.2.3.4, 1.2.3.5: setenv = RELAYCLIENT`

Here 1.2.3.4 and 1.2.3.5 are the clients' IP addresses. qmail-smtpd
ignores control/rcpthosts when RELAYCLIENT is set. (It also appends
RELAYCLIENT to each envelope recipient address. See question 5.5 for an
application.)

Alternative procedure, if you are using tcpserver 0.80 or above: Create
/etc/tcp.smtp containing

   ```
   1.2.3.6:allow,RELAYCLIENT=""
   127.:allow,RELAYCLIENT=""
   ```

to allow clients with IP addresses 1.2.3.6 and 127.*. Run

   `tcprules /etc/tcp.smtp.cdb /etc/tcp.smtp.tmp < /etc/tcp.smtp`

Finally, insert

   `-x /etc/tcp.smtp.cdb`

after tcpserver in your qmail-smtpd invocation.


5.5. How do I fix up messages from broken SMTP clients?

Answer: Three steps. First, put

   ```
   | bouncesaying 'Permission denied' [ "@$HOST" != "@fixme" ]
   | qmail-inject -f "$SENDER" -- "$DEFAULT"
   ```

into ~alias/.qmail-fixup-default. Second, put

   `fixme:fixup`

into /var/qmail/control/virtualdomains, and give qmail-send a HUP.
Third, follow the procedure in question 5.4, but set RELAYCLIENT to the
string "@fixme":

   `tcp-env: 1.2.3.6, 1.2.3.7: setenv = RELAYCLIENT @fixme`

Here 1.2.3.6 and 1.2.3.7 are the clients' IP addresses. If you are using
tcpserver instead of inetd and tcpd, put

   ```
   1.2.3.6:allow,RELAYCLIENT="@fixme"
   1.2.3.7:allow,RELAYCLIENT="@fixme"
   ```

into /etc/tcp.smtp, and run tcprules as in question 5.4.


5.6. How do I set up qmail-qmqpd? I'd like to allow fast queueing of
outgoing mail from authorized clients.

Answer: Make sure you have installed tcpserver 0.80 or above. Create
/etc/qmqp.tcp in tcprules format to allow connections from authorized
hosts. For example, if queueing is allowed from 1.2.3.*:

   ```
   1.2.3.:allow
   :deny
   ```

Convert /etc/qmqp.tcp to /etc/qmqp.cdb:

   `tcprules /etc/qmqp.cdb /etc/qmqp.tmp < /etc/qmqp.tcp`

Finally, set up

   `tcpserver -x /etc/qmqp.cdb -u 7770 -g 2108 0 628 /var/qmail/bin/qmail-qmqpd &`

replacing 7770 and 2108 with the qmaild uid and nofiles gid. See
question 5.1 for more details on tcpserver.



6. Configuring MUAs to work with qmail


6.1. How do I make BSD mail generate a Date with the local time zone?
When I send mail, I'd rather use the local time zone than GMT, since
some MUAs don't know how to display Date in the receiver's time zone.

Answer: Put

   `set sendmail=/var/qmail/bin/datemail`

into your .mailrc or your system-wide Mail.rc. Beware that BSD mail is
neither secure nor reliable.


6.2. How do I make pine work with qmail?

Answer: Put

   `sendmail-path=/usr/lib/sendmail -oem -oi -t`

into /usr/local/lib/pine.conf. (This will work with sendmail too.)
Beware that pine is neither secure nor reliable.


6.3. How do I make MH work with qmail?

Answer: Put

   `postproc: /usr/mh/lib/spost`

into each user's .mh_profile. (This will work with sendmail too.) Beware
that MH is neither secure nor reliable.


6.4. How do I stop Sun's dtcm from hanging?

Answer: There is a novice programming error in dtcm, known as "failure
to close the output side of the pipe in the child." Sun has, at the
time of this writing, not yet provided a patch. Sorry.



7. Managing the mail system


7.1. How do I safely stop qmail-send? Back when we were running
sendmail, it was always tricky to kill sendmail without risking the loss
of current deliveries; what should I do with qmail-send?

Answer: Go ahead and kill the qmail-send process. It will shut down
cleanly. Wait for "exiting" to show up in the log. To restart qmail,
run /var/qmail/rc the same way it is run from your system boot scripts,
with the proper PATH, resource limits, etc.

Alternative, if qmail is supervised: svc -t /var/run/qmail. The
supervise process will kill qmail, wait for it to stop, and restart it.
Use -d instead of -t if you don't want qmail to restart automatically;
to manually restart it, use -u.


7.2. How do I manually run the queue? I'd like qmail to try delivering
all the remote messages right now.

Answer: Give the qmail-send process an ALRM. (Do svc -a /var/run/qmail
if qmail is supervised.)

You may want to run qmail-tcpok first, to guarantee that qmail-remote
will try all addresses. Normally, if an address fails repeatedly,
qmail-remote leaves it alone for an hour.


7.3. How do I rejuvenate a message? Somebody broke into Eric's computer
again; it's going to be down for at least another two days. I know Eric
has been expecting an important message -- in fact, I see it sitting here
in /var/qmail/queue/mess/15/26902. It's been in the queue for six days;
how can I make sure it isn't bounced tomorrow?

Answer: Just touch /var/qmail/queue/info/15/26902. (This is the only
form of queue modification that's safe while qmail is running.)


7.4. How do I organize a big network? I have a lot of machines, and I
don't know where to start.

Answer: First, choose the domain name where your users will receive
mail. This is normally the shortest domain name you control. If you are
in charge of *.movie.edu, you can use addresses like joe@movie.edu.

Second, choose the machine that will know what to do with different
users at movie.edu. Set up a host name in DNS for this machine:

   ```
   mailhost.movie.edu IN A 1.2.3.4
   4.3.2.1.in-addr.arpa IN PTR mailhost.movie.edu
   ```

Here 1.2.3.4 is the IP address of that machine.

Third, make a list of machines where mail should end up. For example, if
mail for Bob should end up on Bob's workstation, put Bob's workstation
onto the list. For each of these machines, set up a host name in DNS:

   ```
   bobshost.movie.edu IN A 1.2.3.7
   7.3.2.1.in-addr.arpa IN PTR bobshost.movie.edu
   ```

Fourth, install qmail on bobshost.movie.edu. qmail will automatically
configure itself to accept messages for bob@bobshost.movie.edu and
deliver them to ~bob/Mailbox on bobshost. Do the same for the other
machines where mail should end up.

Fifth, install qmail on mailhost.movie.edu. Put

   `movie.edu:alias-movie`

into control/virtualdomains on mailhost. Then forward bob@movie.edu to
bob@bobshost.movie.edu, by putting

   `bob@bobshost.movie.edu`

into ~alias/.qmail-movie-bob. Do the same for other users.

Sixth, put movie.edu into control/rcpthosts on mailhost.movie.edu, so
that mailhost.movie.edu will accept messages for users at movie.edu.

Seventh, set up an MX record in DNS to deliver movie.edu messages to
mailhost:

   `movie.edu IN MX 10 mailhost.movie.edu`

Eighth, on all your machines, put movie.edu into control/defaulthost.


7.5. How do I back up and restore the queue disk?

Answer: You can't.

One difficulty is that you can't get a consistent snapshot of the queue
while qmail-send is running. Another difficulty is that messages in the
queue must have filenames that match their inode numbers.

However, the big problem is that backups -- even twice-daily backups -- 
are far too unreliable for mail. If your disk dies, there will be very
little overlap between the messages saved in the last backup and the
messages that were lost.

There are several ways to add real reliability to a mail server. Battery
backups will keep your server alive, letting you park the disk to avoid
a head crash, when the power goes out. Solid-state disks have their own
battery backups. RAID boxes let you replace dead disks without losing
any data.


7.6. How do I run a supervised copy of qmail? svc sounds useful.

Answer: Install daemontools (<https://cr.yp.to/daemontools.html>).
Create a /var/run/qmail directory. Change

   `/var/qmail/rc`

to

   `supervise /var/run/qmail /var/qmail/rc`

in your boot scripts. Make sure that supervise is in the startup PATH.
Now you can use svc to stop or restart qmail, and svstat to check
whether qmail is running.


7.7. How do I avoid syslog? It chews up a lot of CPU time and isn't
reliable.

Answer: Install daemontools (<https://cr.yp.to/daemontools.html>).
Make a /var/log/qmail directory, owned by qmaill, mode 2700. Do

   ```
   qmail-start ./Mailbox /usr/local/bin/accustamp \
   | setuser qmaill /usr/local/bin/cyclog /var/log/qmail &
   ```

in /var/qmail/rc.

If you are logging tcpserver connections, make a /var/log/smtpd
directory, and use cyclog /var/log/smtpd for tcpserver. You shouldn't
run several copies of cyclog with the same log directory.

By default, cyclog keeps 10 automatically rotated log files, each
containing up to 100KB of log data. To keep 20 files with 1MB each, use
cyclog -s 1000000 -n 20.



8. Miscellany


8.1. How do I tell qmail to do more deliveries at once? It's running
only 20 parallel qmail-remote processes.

Answer: Decide how many deliveries you want to allow at once. Put that
number into control/concurrencyremote. Restart qmail-send as in question
7.1. If your system has resource limits, make sure you set the
descriptors limit to at least double the concurrency plus 5; otherwise
you'll get lots of unnecessary deferrals whenever a big burst of mail
shows up. Note that qmail also imposes a compile-time concurrency limit,
120 by default; this is set in conf-spawn.


8.2. How do I keep a copy of all incoming and outgoing mail messages?

Answer: Set QUEUE_EXTRA to "Tlog\0" and QUEUE_EXTRALEN to 5 in extra.h.
Recompile qmail. Put ./msg-log into ~alias/.qmail-log.

You can also use QUEUE_EXTRA to, e.g., record the Message-ID of every
message: run

   `| awk '/^$/ { exit } /^[mM][eE][sS][sS][aA][gG][eE]-/ { print }'`

from ~alias/.qmail-log.


8.3. How do I switch slowly from sendmail to qmail? I'm thinking of
moving the heaven.af.mil network over to qmail, but first I'd like to
give my users a chance to try out qmail without affecting current
sendmail deliveries. We're using NFS.

Answer: Find a host in your network, say pc.heaven.af.mil, that isn't
running an SMTP server. (If addresses at pc.heaven.af.mil are used, you
should already have an MX pointing pc.heaven.af.mil to your mail hub.)

Set up a new MX record pointing lists.heaven.af.mil to pc.heaven.af.mil.
Install qmail on pc.heaven.af.mil. Replace pc with lists in the control
files. Make the qmail man pages available on all your machines.

Now tell your users about qmail. A user can forward joe@heaven.af.mil to
joe@lists.heaven.af.mil to get ~/Mailbox delivery; he can set up .qmail
files; he can start running his own mailing lists @lists.heaven.af.mil.

When you're ready to turn sendmail off, you can set up pc.heaven.af.mil
as your new mail hub. Add heaven.af.mil to control/locals, and change
the heaven.af.mil MX to point to pc.heaven.af.mil. Make sure you leave
lists.heaven.af.mil in control/locals so that transition addresses will
continue to work.
