---
title: ikeda~
description: Ikeda map chaotic generator

categories:
 - object

pdcategory: ELSE, Random and Noise, Signal Generators

arguments:
- type: float
  description: sets frequency in Hz
  default: Nyquist
- type: float
  description: sets initial "u" parameter
  default: 0.75
- type: float
  description: sets initial value of y1[n-1]
  default: 0
- type: float
  description: sets initial value of y2[n-1]
  default: 0

inlets:
  1st:
  - type: float/signal
    description: frequency in Hz (negative values accepted)

outlets:
  1st:
  - type: signal
    description: y1[n]: Ikeda map chaotic signal 1st output
  2nd:
  - type: signal
    description: y2[n]: Ikeda map chaotic signal 2nd output

methods:
  - type: u <float>
    description: sets the value of u
  - type: list
    description: 2 floats set y1[n-1] and y2[n-1], respectively
  - type: clear
    description: clears previous outputs

draft: false
---

[ikeda~] is an ikeda map chaotic generator, it had two audio outputs generated by the difference equations;
y1[n] = 1 + u * (y1[n-1] * cos(t) - y2[n-1] * sin(t));
y2[n] = u * (y1[n-1] * sin(t) + y2[n-1] * cos(t));
where t = 0.4 - 6 / (1 + y1[n-1]ˆ2 + y2[n-1]ˆ2

