#!/bin/bash

SRC_DIR="$1"
TARGET_OS="$2"
TARGET_OS_ARCH="$3"
CC_LAUNCHER="$4"

[ "$TARGET_OS_ARCH" = "none" ] && TARGET_OS_ARCH=""
[ "$CC_LAUNCHER" = "none" ] && CC_LAUNCHER=""

# Variables
FFMPEG_DIR="ffmpeg-7.0.1"

# Define platform-specific configurations
if [[ $TARGET_OS == "Darwin" ]]; then
    ffmpeg_config="--enable-securetransport --extra-cflags=-mmacosx-version-min=10.9 --extra-ldflags=-mmacosx-version-min=10.9"
    ffmpeg_cc="clang -arch x86_64 -arch arm64"
elif [[ $TARGET_OS == "iOS" ]]; then
    SDK_PATH=$(xcrun --sdk iphoneos --show-sdk-path)
    ffmpeg_cc="xcrun --sdk iphoneos gcc -arch arm64"
    ffmpeg_config="--disable-securetransport --sysroot=$SDK_PATH --enable-cross-compile --arch=arm64"
elif [[ $TARGET_OS == "Linux" ]]; then
    ffmpeg_config="--enable-pic"
    ffmpeg_cc="${CC:-gcc}"
elif [ "$(expr substr $(uname -s) 1 10)" == "MINGW64_NT" ]; then
    ffmpeg_config="--toolchain=msvc --arch=$3 --target-os=win64 --extra-cflags=-MT"
    ffmpeg_cc="cl.exe"
    sed -i.bak '5021c\
            _DEPCMD='\''$(DEP$(1)) $(DEP$(1)FLAGS) $($(1)DEP_FLAGS) $< 2>&1 | grep "^Note:.*file:" | sed -e "s^.*file: *^$@: ^" | tr \\\\\\\\/ \/ > $(@:.o=.d)'\'' '$'\n' "$FFMPEG_DIR/configure"
else
    echo "Unsupported OS: $TARGET_OS"
    exit 1
fi

CHERE_INVOKING=1
MSYS2_PATH_TYPE=inherit
MSYSTEM=MSYS

AVUTIL_FILE="$FFMPEG_DIR/libavutil/avconfig.h"
# Check if the file already exists
if [ ! -f "$AVUTIL_FILE" ]; then
    # Write the content to the file
    touch "$AVUTIL_FILE"
    cat <<EOL > "$AVUTIL_FILE"
/* Generated by ffmpeg configure */
#ifndef AVUTIL_AVCONFIG_H
#define AVUTIL_AVCONFIG_H
#define AV_HAVE_BIGENDIAN 0
#define AV_HAVE_FAST_UNALIGNED 0
#endif /* AVUTIL_AVCONFIG_H */
EOL

    echo "File '$AVUTIL_FILE' created."
else
    echo "File '$AVUTIL_FILE' already exists. No changes made."
fi

# Configure and compile FFmpeg
cd "$FFMPEG_DIR"
./configure --disable-asm --disable-libxcb --disable-bzlib --disable-lzma --disable-sdl2 --disable-libdrm --disable-vaapi --enable-static --disable-shared --enable-optimizations --disable-debug --disable-doc \
            --disable-programs --disable-iconv --disable-avdevice --disable-postproc --disable-network \
            --disable-everything --enable-avcodec --enable-avformat --enable-avutil --enable-swscale \
            --enable-swresample --enable-decoder=mp3*,pcm*,aac*,flac,vorbis,opus,alac,mulaw,alaw --enable-parser=mpegaudio,aac \
            --enable-demuxer=mp3,wav,aiff,flac,aac,ogg,pcm*,caf,au --enable-filter=aresample --enable-protocol=file \
            --enable-demuxer=avi --enable-demuxer=mov --enable-demuxer=mp3 \
            --enable-demuxer=flv --enable-demuxer=asf --enable-muxer=avi --enable-muxer=mov --enable-muxer=mp4 \
            --enable-muxer=flv --enable-muxer=asf --enable-muxer=caf --enable-muxer=au --enable-decoder=mp3 --enable-decoder=aac --enable-decoder=h264 \
            --enable-decoder=mpeg4 --enable-decoder=mpeg1video --enable-decoder=mpeg2video --enable-decoder=mjpeg --enable-encoder=aac --enable-encoder=mpeg4 \
            --enable-encoder=mpeg1video --enable-encoder=alac --enable-encoder=pcm_mulaw --enable-encoder=pcm_alaw --enable-parser=mpeg4video --enable-network --enable-protocol=http --enable-protocol=https --enable-protocol=rtmp --enable-protocol=rtmpt --enable-protocol=rtmps --enable-protocol=hls --enable-protocol=tcp --enable-protocol=udp \
            $ffmpeg_config

make CC="$CC_LAUNCHER $ffmpeg_cc"
