--------------------------------------------------------------------------------
--
-- CTU CAN FD IP Core
-- Copyright (C) 2021-present Ondrej Ille
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
--
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
--
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
--
-- -------------------------------------------------------------------------------
--
-- CTU CAN FD IP Core
-- Copyright (C) 2015-2020 MIT License
--
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
--
-- Project advisors:
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
--
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
--
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
--
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
--
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- @TestInfoStart
--
-- @Purpose:
--  Stuff bit on last bit of Data field.
--
-- @Verifies:
--  @1. When stuff bit is inserted after last bit of Data field, no extra stuff
--      bit will be inserted during first bit of Stuff count (with fixed
--      stuffing). Wait until frame is sent. Read frame and check it is received
--      succesfully!
--
-- @Test sequence:
--  @1. Generate CAN frame which has last 5 bits of data field dominant! Send
--      it by DUT. Wait until frame is sent and read it from Test node. Check
--      that frames are equal.
--      Note: The check is only visual so far...
--
-- @TestInfoEnd
--------------------------------------------------------------------------------
-- Revision History:
--   02.12.2019   Created file
--------------------------------------------------------------------------------

Library ctu_can_fd_tb;
context ctu_can_fd_tb.ieee_context;
context ctu_can_fd_tb.rtl_context;
context ctu_can_fd_tb.tb_common_context;

use ctu_can_fd_tb.feature_test_agent_pkg.all;

package stuff_in_data_ftest is
    procedure stuff_in_data_ftest_exec(
        signal      chn             : inout  t_com_channel
    );
end package;


package body stuff_in_data_ftest is
    procedure stuff_in_data_ftest_exec(
        signal      chn             : inout  t_com_channel
    ) is
        variable CAN_frame          :        SW_CAN_frame_type;
        variable CAN_frame_2        :        SW_CAN_frame_type  := SW_CAN_Frame_type_rst_val;
        variable frame_sent         :        boolean;
        variable frames_equal       :        boolean;
    begin

        ----------------------------------------------------------------------
        -- @1. Generate CAN frame which has last 5 bits of data field dominant!
        --    Send it by DUT. Wait until frame is sent and read it from
        --    Test node. Check that frames are equal. Note: The actual check is
        --    done by assertion!
        ----------------------------------------------------------------------
        info_m("Step 1");

        CAN_generate_frame(CAN_frame);

        -- Use only DLC of 1, as data byte 1 is set so that stuff bit is
        -- inserted at last bit of data field!
        CAN_frame.dlc := "0001";
        CAN_frame.data(0) := x"21";
        CAN_frame.rtr := NO_RTR_FRAME;
        CAN_frame.frame_format := FD_CAN;
        decode_dlc(CAN_frame.dlc, CAN_frame.data_length);
        decode_dlc_rx_buff(CAN_frame.dlc, CAN_frame.rwcnt);

        CAN_send_frame(CAN_frame, 1, DUT_NODE, chn, frame_sent);
        CAN_wait_frame_sent(DUT_NODE, chn);
        CAN_wait_bus_idle(DUT_NODE, chn);
        CAN_wait_bus_idle(TEST_NODE, chn);

        CAN_read_frame(CAN_frame_2, TEST_NODE, chn);
        CAN_compare_frames(CAN_frame, CAN_frame_2, false, frames_equal);
        check_m(frames_equal, "Frame received OK!");

  end procedure;

end package body;