/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "Atr.h"

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include "Error.h"
//Added by qt3to4:
#include <QTextStream>

extern Errors  gErr;

static const char *AtrName[] = { "Ref", "Val", "SubV", "Comm", "Pkg",
                                 "ToPCB", "PartL", 0 };

Atrib::Atrib()
{
 int i;
// Atr=new QString[AtrN];
 AL=new AtrLst[VerN];
 for(i=0;i<VerN;i++){
  AL[i]=NULL;
 }
 Poc=new int;
 Ver=new int;
 *Poc=1;
 *Ver=0;
}

Atrib::~Atrib()
{
// printf("Atrib~ : poc %d\n",*Poc);
 (*Poc)--;
 if(!*Poc){
  int i;
//  delete[] Atr;
  delete Poc;
  delete Ver;
  if(AL){
   for(i=0;i<VerN;i++){
    if(AL[i]) delete AL[i];
   }
   delete[] AL;
  }
 }
}


Atrib  &Atrib::operator=(Atrib &A)
{
// printf("Atrib= : poc %d\n",*Poc);
 (*Poc)--;
 if(!*Poc){
  int i;
//  delete[] Atr;
  delete Poc;
  delete Ver;
  if(AL){
   for(i=0;i<VerN;i++){
    if(AL[i]) delete AL[i];
   }
   delete[] AL;
  }
 }

// Atr=A.GetAtr();
 AL=A.GetAL();
 Poc=A.GetPoc();
 Ver=A.GetVer();
 (*Poc)++;
 return *this;
}

bool  Atrib::operator==(Atrib &A)
{
 AtrLst * L;
 int i;
 if(AL==A.GetAL()) return true;
 L=A.GetAL();
 if(AL[0] && L[0]){
  for(i=1;i<AtrN;i++){
   if(!AL[0]->Atr[i].isEmpty() && !L[0]->Atr[i].isEmpty()){
    if(AL[0]->Atr[i]!=L[0]->Atr[i]){
//     printf("Atrib : %s!=%s\n",(const char *)AL[0]->Atr[i],
//                               (const char *)L[0]->Atr[i]);
     return false;
    }
   }
  }
  return true;
 }
 return false;
}

bool  Atrib::OneData(Atrib &A)
{
 if(AL==A.GetAL()) return true;
 return false;
}

QString * Atrib::GetAtr(int n,int ver)
{
 if(n<0 || n>=AtrN) return NULL;
// printf("GetAtr: %d %d\n",ver,*Ver);
 if(ver==-1){
  if(AL[*Ver]) return &(AL[*Ver]->Atr[n]);
  else if(AL[0]) return &(AL[0]->Atr[n]);
 }
 else if(ver==-2){
  if(AL[0]) return &(AL[0]->Atr[n]);
 }
 else if(ver>=0 && ver<VerN){
  if(AL[ver]) return &(AL[ver]->Atr[n]);
 }
 return NULL;
}

bool Atrib::GetRef(QString & s,int ver)
{
 QString * s1;
 int i;
 s1=GetAtr(0,ver);
 if(s1){
  if (s1->isEmpty()) return false;
  i=0;
  while(s1->at(i).toAscii()>'?' && i<s1->length()) i++;
  s=s1->left(i);
  return true;
 }
 return false;
}

int Atrib::GetRefNum(int ver)
{
 QString * s1;
 int i;
 s1=GetAtr(0,ver);
 if(s1){
  if(s1->contains("?")) return -1;
  if (s1->isEmpty()) return -1;
  i=0;
  while(s1->at(i).toAscii()>'9' && i<s1->length()) i++;
  return (s1->right(s1->length()-i)).toInt();
 }
 return -1;
}


void Atrib::ClrRefNum(int ver)
{
 QString * s1;
 int i;
 s1=GetAtr(0,ver);
 if(s1){
  if(s1->contains("?")) return;
  if (s1->isEmpty()) return;
  i=0;
  while(s1->at(i).toAscii()>'9' && i<s1->length()) i++;
  *s1=s1->left(i)+'?';
 }
}



bool Atrib::isEmpty(int n,int ver)
{
 if(n<0 || n>=AtrN) return true;
// printf("GetAtr: %d %d\n",ver,*Ver);
 if(ver==-1){
  if(AL[*Ver]) return AL[*Ver]->Atr[n].isEmpty();
  else if(AL[0]) return AL[0]->Atr[n].isEmpty();
 }
 else if(ver==-2){
  if(AL[0]) return AL[0]->Atr[n].isEmpty();
 }
 else if(ver>=0 && ver<VerN){
  if(AL[ver]) return AL[ver]->Atr[n].isEmpty();
 }
 return true;
}


void Atrib::SetAtr(int n,QString s,int ver)
{
 int i;
 if(n>=0 && n<AtrN){
  if(ver==-2){
   for(i=0;i<VerN;i++){
    if(AL[i]){
     AL[i]->Atr[n]=s;
    }
   }
  }
  else if(ver==-1){
   if(!AL[*Ver] && n==0 && *Ver==0) AL[*Ver]=new AtrS;
   if(!AL[*Ver] && n==0){
    if(gErr.YesNo("Insert new version ?")) AL[*Ver]=new AtrS;
   }
   if(AL[*Ver]){
    AL[*Ver]->Atr[n]=s;
   }
  }
  else if(ver>=0 && ver<VerN){
   if(!AL[ver] && n==0 && ver==0) AL[ver]=new AtrS;
   if(!AL[ver] && n==0){
    if(gErr.YesNo("Insert new version ?")) AL[ver]=new AtrS;
   }
   if(AL[ver]){
    AL[ver]->Atr[n]=s;
   }
  }
 }
}

/*
QString * Atrib::GetAtr()
{
 return Atr;
}*/

Atrib::AtrLst * Atrib::GetAL()
{
 return AL;
}

int * Atrib::GetPoc()
{
 return Poc;
}

int * Atrib::GetVer()
{
 return Ver;
}

void Atrib::SetVer(int ver)
{
 *Ver=ver;
}

const char * Atrib::GetName(int n)
{
 if(n>=0 && n<AtrN){
  return AtrName[n];
 }
 return NULL;
}

bool Atrib::ValToNum(const char * v,double & n)
{
 int i;
 int j;
 i=0;
 j=0;
 double m=1;

 if(!v){
//  printf("ValToNum  false\n");
  return false;
 }

 while(v[i]){
  if(v[i]<'0' || v[i]>'9') j++;
  i++;
 }
 if(j<=1 && j<i){
  char s[i+1];
  i=0;
  while(v[i]){
   if(v[i]>='0' && v[i]<='9') s[i]=v[i];
   else {
    s[i]='.';
    if(v[i]=='K' || v[i]=='k') m=1000;
    else if(v[i]=='M') m=1e6;
    else if(v[i]=='G' || v[i]=='g') m=1e9;
    else if(v[i]=='m') m=1e-3;
    else if(v[i]=='u') m=1e-6;
    else if(v[i]=='n') m=1e-9;
    else if(v[i]=='p') m=1e-19;
   }
   i++;
  }
  s[i]=0;
  n=strtod(s,NULL)*m;
//  printf("ValToNum %s %f\n",v,n);
  return true;
 }
// printf("ValToNum %s false\n",v);
 return false;
}


bool Atrib::TextLoadNext(QTextStream * S,QString* s)
{
 int i;
 int j;
 QString s1;
 for(j=VerN-1;j>=0;j--){
  for(i=0;i<AtrN;i++){
   s1.setNum(j);
   s1="."+s1;
   s1=AtrName[i]+s1;
//   printf("'%s' '%s'\n",(const char *)*s,(const char *)s1);
   if (s->contains(s1) || (s->contains(AtrName[i]) && j==0)){
//    printf("OK\n");
    if(AL[j]==NULL){
     AL[j]=new AtrS;
    }
    AL[j]->Atr[i]=TextLoadStr(S);
    return true;
   }
  }
 }
 return false;
}


void Atrib::TextSave(QTextStream * S)
{
 int i;
 int j;
 for (j=0;j<VerN;j++){
  if(AL[j]){
   for (i=0;i<AtrN;i++){
    if(!AL[j]->Atr[i].isEmpty()){
     *S << "    {" << AtrName[i]<<"." << j << " " << AL[j]->Atr[i] << " }\n";
    }
   }
  }
 }
}


QString Atrib::TextLoadStr(QTextStream * S)
{
  QString s,s1;
//  int i=1;
  *S >> s;
  while (!s.contains('}')) {
   s1+=s;
   s1+=" ";
   *S >> s;
  }
  return (s1.simplified());
}
