/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef Atr_included
#define Atr_included

#include <QString>
#include <QTextStream>


#define kAtrRef 0
#define kAtrVal 1
#define kAtrSubV 2
#define kAtrComm 3
#define kAtrPkg 4
#define kAtrToPcb 5
#define kAtrPartL 6

#define AtrN 7
#define VerN 10

class Atrib
{

struct AtrS {
 int Stav;
 QString Atr[AtrN];
};

typedef AtrS* AtrLst;

public:

 Atrib();
 virtual ~Atrib();

 Atrib  &operator=(Atrib &A);
 bool  operator==(Atrib &A);

 bool  OneData(Atrib &A);

 QString * GetAtr(int n,int ver=-1);
 void SetAtr(int n,QString s,int ver=-1);
 QString * GetAtr();
 Atrib::AtrLst * GetAL();
 int * GetPoc();
 int * GetVer();

 bool GetRef(QString & s,int ver=-1);
 int GetRefNum(int ver=-1);
 void ClrRefNum(int ver=-1);

 bool isEmpty(int n,int ver=-1);

 void SetVer(int ver);

 const char * GetName(int n);

 bool ValToNum(const char * v,double & n);

 bool TextLoadNext(QTextStream * S,QString* s);
 void TextSave(QTextStream * S);

protected:

 QString TextLoadStr(QTextStream * S);



private:

//  QString * Atr;
  AtrLst  * AL;
  int * Poc;

  int * Ver;
};


#endif
